/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.Locale;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.delete.DeleteAction;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.VersionType;

public class HttpDeleteAction
extends HttpAction {
    protected final DeleteAction action;

    public HttpDeleteAction(HttpClient client, DeleteAction action) {
        super(client);
        this.action = action;
    }

    public void execute(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                DeleteResponse deleteResponse = this.fromXContent(parser);
                listener.onResponse((Object)deleteResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected DeleteResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        DeleteResponse.Builder context = new DeleteResponse.Builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            DeleteResponse.parseXContentFields((XContentParser)parser, (DeleteResponse.Builder)context);
        }
        return context.build();
    }

    protected CurlRequest getCurlRequest(DeleteRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)DELETE, "/_doc/" + UrlUtils.encode(request.id()), request.index());
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (!WriteRequest.RefreshPolicy.NONE.equals((Object)request.getRefreshPolicy())) {
            curlRequest.param("refresh", request.getRefreshPolicy().getValue());
        }
        if (!VersionType.INTERNAL.equals((Object)request.versionType())) {
            curlRequest.param("version_type", request.versionType().name().toLowerCase(Locale.ROOT));
        }
        curlRequest.param("if_seq_no", Long.toString(request.ifSeqNo()));
        curlRequest.param("if_primary_term", Long.toString(request.ifPrimaryTerm()));
        if (!ActiveShardCount.DEFAULT.equals((Object)request.waitForActiveShards())) {
            curlRequest.param("wait_for_active_shards", String.valueOf(this.getActiveShardsCountValue(request.waitForActiveShards())));
        }
        return curlRequest.param("routing", request.routing()).param("version", String.valueOf(request.version()));
    }
}

