/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.ingest.DeletePipelineAction;
import org.opensearch.action.ingest.DeletePipelineRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpDeletePipelineAction
extends HttpAction {
    protected final DeletePipelineAction action;

    public HttpDeletePipelineAction(HttpClient client, DeletePipelineAction action) {
        super(client);
        this.action = action;
    }

    public void execute(DeletePipelineRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                AcknowledgedResponse deletePipelineResponse = AcknowledgedResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)deletePipelineResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(DeletePipelineRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)DELETE, "/_ingest/pipeline/" + UrlUtils.encode(request.getId()), new String[0]);
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }
}

