/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.admin.cluster.snapshots.delete.DeleteSnapshotAction;
import org.opensearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpDeleteSnapshotAction
extends HttpAction {
    protected final DeleteSnapshotAction action;

    public HttpDeleteSnapshotAction(HttpClient client, DeleteSnapshotAction action) {
        super(client);
        this.action = action;
    }

    public void execute(DeleteSnapshotRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                AcknowledgedResponse cancelTasksResponse = AcknowledgedResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)cancelTasksResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(DeleteSnapshotRequest request) {
        StringBuilder pathBuf = new StringBuilder(100).append("/_snapshot");
        if (request.repository() != null) {
            pathBuf.append('/').append(UrlUtils.encode(request.repository()));
        }
        if (request.snapshots() != null && request.snapshots().length > 0) {
            pathBuf.append('/').append(UrlUtils.encode(Arrays.stream(request.snapshots()).collect(Collectors.joining(","))));
        }
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)DELETE, pathBuf.toString(), new String[0]);
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }
}

