/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.Locale;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.get.GetAction;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.VersionType;

public class HttpGetAction
extends HttpAction {
    protected final GetAction action;

    public HttpGetAction(HttpClient client, GetAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetRequest request, ActionListener<GetResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetResponse getResponse = GetResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)getResponse);
            }
            catch (Exception e) {
                if (response.getHttpStatusCode() == 404) {
                    throw new IndexNotFoundException(request.index(), (Throwable)e);
                }
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    private CurlRequest getCurlRequest(GetRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_doc/" + UrlUtils.encode(request.id()), request.index());
        if (request.refresh()) {
            curlRequest.param("refresh", "true");
        }
        if (request.routing() != null) {
            curlRequest.param("routing", request.routing());
        }
        if (request.preference() != null) {
            curlRequest.param("preference", request.preference());
        }
        if (request.realtime()) {
            curlRequest.param("realtime", "true");
        }
        if (request.storedFields() != null) {
            curlRequest.param("stored_fields", String.join((CharSequence)",", request.storedFields()));
        }
        if (request.version() >= 0L) {
            curlRequest.param("version", Long.toString(request.version()));
        }
        if (!VersionType.INTERNAL.equals((Object)request.versionType())) {
            curlRequest.param("version_type", request.versionType().name().toLowerCase(Locale.ROOT));
        }
        return curlRequest;
    }
}

