/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.io.stream.ByteArrayStreamOutput;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.admin.indices.alias.get.GetAliasesAction;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class HttpGetAliasesAction
extends HttpAction {
    protected final GetAliasesAction action;

    public HttpGetAliasesAction(HttpClient client, GetAliasesAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetAliasesRequest request, ActionListener<GetAliasesResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetAliasesResponse getAliasesResponse = this.getGetAliasesResponse(parser);
                listener.onResponse((Object)getAliasesResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(GetAliasesRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_alias/" + UrlUtils.joinAndEncode(",", request.aliases()), request.indices());
        curlRequest.param("local", Boolean.toString(request.local()));
        return curlRequest;
    }

    protected GetAliasesResponse getGetAliasesResponse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        HashMap<String, List<AliasMetadata>> aliases = new HashMap<String, List<AliasMetadata>>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        String index = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                index = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (ALIASES_FIELD.match(currentFieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                    aliases.put(index, HttpGetAliasesAction.getAliases(parser));
                    continue;
                }
                parser.skipChildren();
            }
        }
        try (ByteArrayStreamOutput out = new ByteArrayStreamOutput();){
            out.writeVInt(aliases.size());
            for (Map.Entry entry : aliases.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeVInt(((List)entry.getValue()).size());
                for (AliasMetadata aliasMetaData : (List)entry.getValue()) {
                    aliasMetaData.writeTo((StreamOutput)out);
                }
            }
            GetAliasesResponse getAliasesResponse = (GetAliasesResponse)this.action.getResponseReader().read(out.toStreamInput());
            return getAliasesResponse;
        }
    }

    public static List<AliasMetadata> getAliases(XContentParser parser) throws IOException {
        ArrayList<AliasMetadata> aliases = new ArrayList<AliasMetadata>();
        XContentParser.Token token = parser.nextToken();
        if (token == null) {
            return aliases;
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            aliases.add(AliasMetadata.Builder.fromXContent((XContentParser)parser));
        }
        return aliases;
    }
}

