/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.EngineInfo;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsAction;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class HttpGetFieldMappingsAction
extends HttpAction {
    protected final GetFieldMappingsAction action;

    public HttpGetFieldMappingsAction(HttpClient client, GetFieldMappingsAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetFieldMappingsRequest request, ActionListener<GetFieldMappingsResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetFieldMappingsResponse getFieldMappingsResponse = this.fromXContent(parser);
                listener.onResponse((Object)getFieldMappingsResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(GetFieldMappingsRequest request) {
        StringBuilder pathSuffix = new StringBuilder(100).append("/_mapping/field/");
        if (request.fields().length > 0) {
            pathSuffix.append(UrlUtils.joinAndEncode(",", request.fields()));
        }
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, pathSuffix.toString(), request.indices());
        curlRequest.param("include_defaults", Boolean.toString(request.includeDefaults()));
        if (this.client.getEngineInfo().getType() != EngineInfo.EngineType.ELASTICSEARCH8) {
            curlRequest.param("local", Boolean.toString(request.local()));
        }
        return curlRequest;
    }

    protected GetFieldMappingsResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        HashMap<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>>> mappings = new HashMap<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>>>();
        if (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            while (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                String index = parser.currentName();
                Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>> typeMappings = this.parseTypeMappings(parser, index);
                mappings.put(index, typeMappings);
                parser.nextToken();
            }
        }
        return this.newGetFieldMappingsResponse(mappings);
    }

    protected Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>> parseTypeMappings(XContentParser parser, String index) throws IOException {
        ObjectParser objectParser = new ObjectParser(MAPPINGS_FIELD.getPreferredName(), true, HashMap::new);
        objectParser.declareField((p, typeMappings, idx) -> {
            p.nextToken();
            while (p.currentToken() == XContentParser.Token.FIELD_NAME) {
                String typeName = p.currentName();
                if (p.nextToken() == XContentParser.Token.START_OBJECT) {
                    HashMap<String, GetFieldMappingsResponse.FieldMappingMetadata> typeMapping = new HashMap<String, GetFieldMappingsResponse.FieldMappingMetadata>();
                    typeMappings.put(typeName, typeMapping);
                    do {
                        String fieldName = p.currentName();
                        GetFieldMappingsResponse.FieldMappingMetadata fieldMappingMetaData = this.getFieldMappingMetadata(p);
                        typeMapping.put(fieldName, fieldMappingMetaData);
                    } while (p.nextToken() == XContentParser.Token.START_OBJECT);
                } else {
                    p.skipChildren();
                }
                p.nextToken();
            }
        }, MAPPINGS_FIELD, ObjectParser.ValueType.OBJECT);
        return (Map)objectParser.parse(parser, (Object)index);
    }

    protected GetFieldMappingsResponse.FieldMappingMetadata getFieldMappingMetadata(XContentParser parser) throws IOException {
        ConstructingObjectParser objectParser = new ConstructingObjectParser("field_mapping_meta_data", true, a -> new GetFieldMappingsResponse.FieldMappingMetadata((String)a[0], (BytesReference)a[1]));
        objectParser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), FULL_NAME_FIELD, ObjectParser.ValueType.STRING);
        objectParser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().copyCurrentStructure(p)), MAPPING_FIELD, ObjectParser.ValueType.OBJECT);
        return (GetFieldMappingsResponse.FieldMappingMetadata)objectParser.parse(parser, null);
    }

    protected GetFieldMappingsResponse newGetFieldMappingsResponse(Map<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>>> mappings) {
        Class<GetFieldMappingsResponse> clazz = GetFieldMappingsResponse.class;
        Class[] types = new Class[]{Map.class};
        try {
            Constructor constructor = clazz.getDeclaredConstructor(types);
            constructor.setAccessible(true);
            return (GetFieldMappingsResponse)constructor.newInstance(mappings);
        }
        catch (Exception e) {
            throw new OpenSearchException("Failed to create GetFieldMappingsResponse.", (Throwable)e, new Object[0]);
        }
    }
}

