/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpGetSnapshotsAction
extends HttpAction {
    protected final GetSnapshotsAction action;

    public HttpGetSnapshotsAction(HttpClient client, GetSnapshotsAction action) {
        super(client);
        this.action = action;
    }

    public void execute(GetSnapshotsRequest request, ActionListener<GetSnapshotsResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                GetSnapshotsResponse cancelTasksResponse = GetSnapshotsResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)cancelTasksResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(GetSnapshotsRequest request) {
        StringBuilder pathBuf = new StringBuilder(100).append("/_snapshot");
        if (request.repository() != null) {
            pathBuf.append('/').append(UrlUtils.encode(request.repository()));
        } else {
            pathBuf.append("/_all");
        }
        if (request.snapshots() != null && request.snapshots().length > 0) {
            pathBuf.append('/').append(UrlUtils.joinAndEncode(",", request.snapshots()));
        } else {
            pathBuf.append("/_all");
        }
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, pathBuf.toString(), new String[0]);
        curlRequest.param("ignore_unavailable", String.valueOf(request.ignoreUnavailable()));
        curlRequest.param("verbose", String.valueOf(request.verbose()));
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }
}

