/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsAction;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.core.action.ActionListener;

public class HttpIndicesExistsAction
extends HttpAction {
    protected final IndicesExistsAction action;

    public HttpIndicesExistsAction(HttpClient client, IndicesExistsAction action) {
        super(client);
        this.action = action;
    }

    public void execute(IndicesExistsRequest request, ActionListener<IndicesExistsResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            boolean exists = switch (response.getHttpStatusCode()) {
                case 200 -> true;
                case 404 -> false;
                default -> throw new OpenSearchException("Unexpected status: " + response.getHttpStatusCode(), new Object[0]);
            };
            try {
                IndicesExistsResponse indicesExistsResponse = new IndicesExistsResponse(exists);
                listener.onResponse((Object)indicesExistsResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(IndicesExistsRequest request) {
        return this.client.getCurlRequest((Function<String, CurlRequest>)HEAD, null, request.indices());
    }
}

