/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.EngineInfo;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.MultiSearchAction;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class HttpMultiSearchAction
extends HttpAction {
    protected final MultiSearchAction action;

    public HttpMultiSearchAction(HttpClient client, MultiSearchAction action) {
        super(client);
        this.action = action;
    }

    public void execute(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        String source = null;
        try {
            source = new String(this.writeMultiLineFormat(request, XContentType.JSON.xContent()));
        }
        catch (Exception e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                MultiSearchResponse multiSearchResponse = MultiSearchResponse.fromXContext((XContentParser)parser);
                listener.onResponse((Object)multiSearchResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected byte[] writeMultiLineFormat(MultiSearchRequest multiSearchRequest, XContent xContent) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (SearchRequest request : multiSearchRequest.requests()) {
            try (XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)xContent);){
                this.writeSearchRequestParams(request, xContentBuilder);
                BytesReference.bytes((XContentBuilder)xContentBuilder).writeTo((OutputStream)output);
            }
            output.write(xContent.streamSeparator());
            xContentBuilder = XContentBuilder.builder((XContent)xContent);
            try {
                if (request.source() != null) {
                    request.source().toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                } else {
                    xContentBuilder.startObject();
                    xContentBuilder.endObject();
                }
                BytesReference.bytes((XContentBuilder)xContentBuilder).writeTo((OutputStream)output);
            }
            finally {
                if (xContentBuilder != null) {
                    xContentBuilder.close();
                }
            }
            output.write(xContent.streamSeparator());
        }
        return output.toByteArray();
    }

    protected void writeSearchRequestParams(SearchRequest request, XContentBuilder xContentBuilder) throws IOException {
        EngineInfo.EngineType engineType = this.client.getEngineInfo().getType();
        if (engineType == EngineInfo.EngineType.ELASTICSEARCH8 || engineType == EngineInfo.EngineType.OPENSEARCH2) {
            xContentBuilder.startObject();
            if (request.indices() != null) {
                xContentBuilder.field("index", (Object)request.indices());
            }
            if (request.indicesOptions() != null && request.indicesOptions() != SearchRequest.DEFAULT_INDICES_OPTIONS) {
                IndicesOptions.WildcardStates.toXContent((EnumSet)request.indicesOptions().getExpandWildcards(), (XContentBuilder)xContentBuilder);
                xContentBuilder.field("ignore_unavailable", request.indicesOptions().ignoreUnavailable());
                xContentBuilder.field("allow_no_indices", request.indicesOptions().allowNoIndices());
            }
            if (request.searchType() != null) {
                xContentBuilder.field("search_type", request.searchType().name().toLowerCase(Locale.ROOT));
            }
            xContentBuilder.field("ccs_minimize_roundtrips", request.isCcsMinimizeRoundtrips());
            if (request.requestCache() != null) {
                xContentBuilder.field("request_cache", request.requestCache());
            }
            if (request.preference() != null) {
                xContentBuilder.field("preference", request.preference());
            }
            if (request.routing() != null) {
                xContentBuilder.field("routing", request.routing());
            }
            if (request.allowPartialSearchResults() != null) {
                xContentBuilder.field("allow_partial_search_results", request.allowPartialSearchResults());
            }
            if (request.getCancelAfterTimeInterval() != null) {
                xContentBuilder.field("cancel_after_time_interval", request.getCancelAfterTimeInterval().getStringRep());
            }
            xContentBuilder.endObject();
        } else {
            MultiSearchRequest.writeSearchRequestParams((SearchRequest)request, (XContentBuilder)xContentBuilder);
        }
    }

    protected CurlRequest getCurlRequest(MultiSearchRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, HttpClient.ContentType.X_NDJSON, "/_msearch", new String[0]);
        if (request.maxConcurrentSearchRequests() > 0) {
            curlRequest.param("max_concurrent_searches", Integer.toString(request.maxConcurrentSearchRequests()));
        }
        return curlRequest;
    }
}

