/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.io.stream.ByteArrayStreamOutput;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.node.stats.NodeStats;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.action.search.SearchRequestStats;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.DiskUsage;
import org.opensearch.cluster.coordination.PendingClusterStateStats;
import org.opensearch.cluster.coordination.PublishClusterStateStats;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.WeightedRoutingStats;
import org.opensearch.cluster.service.ClusterManagerThrottlingStats;
import org.opensearch.common.metrics.OperationStats;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.indices.breaker.AllCircuitBreakerStats;
import org.opensearch.core.indices.breaker.CircuitBreakerStats;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.discovery.DiscoveryStats;
import org.opensearch.http.HttpStats;
import org.opensearch.index.cache.query.QueryCacheStats;
import org.opensearch.index.cache.request.RequestCacheStats;
import org.opensearch.index.engine.SegmentsStats;
import org.opensearch.index.fielddata.FieldDataStats;
import org.opensearch.index.flush.FlushStats;
import org.opensearch.index.get.GetStats;
import org.opensearch.index.merge.MergeStats;
import org.opensearch.index.recovery.RecoveryStats;
import org.opensearch.index.refresh.RefreshStats;
import org.opensearch.index.search.stats.SearchStats;
import org.opensearch.index.shard.DocsStats;
import org.opensearch.index.shard.IndexingStats;
import org.opensearch.index.stats.IndexingPressureStats;
import org.opensearch.index.stats.ShardIndexingPressureStats;
import org.opensearch.index.store.StoreStats;
import org.opensearch.index.store.remote.filecache.FileCacheStats;
import org.opensearch.index.translog.TranslogStats;
import org.opensearch.index.warmer.WarmerStats;
import org.opensearch.indices.NodeIndicesStats;
import org.opensearch.ingest.IngestStats;
import org.opensearch.monitor.fs.FsInfo;
import org.opensearch.monitor.jvm.JvmStats;
import org.opensearch.monitor.os.OsStats;
import org.opensearch.monitor.process.ProcessStats;
import org.opensearch.node.AdaptiveSelectionStats;
import org.opensearch.script.ScriptCacheStats;
import org.opensearch.script.ScriptStats;
import org.opensearch.search.backpressure.settings.SearchBackpressureMode;
import org.opensearch.search.backpressure.stats.SearchBackpressureStats;
import org.opensearch.search.backpressure.stats.SearchShardTaskStats;
import org.opensearch.search.backpressure.stats.SearchTaskStats;
import org.opensearch.search.pipeline.SearchPipelineStats;
import org.opensearch.search.suggest.completion.CompletionStats;
import org.opensearch.tasks.SearchShardTaskCancellationStats;
import org.opensearch.tasks.TaskCancellationStats;
import org.opensearch.threadpool.ThreadPoolStats;
import org.opensearch.transport.TransportStats;

public class HttpNodesStatsAction
extends HttpAction {
    protected NodesStatsAction action;

    public HttpNodesStatsAction(HttpClient client, NodesStatsAction action) {
        super(client);
        this.action = action;
    }

    public void execute(NodesStatsRequest request, ActionListener<NodesStatsResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                NodesStatsResponse nodesStatsResponse = this.fromXContent(parser);
                listener.onResponse((Object)nodesStatsResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected NodesStatsResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        List<Object> nodes = Collections.emptyList();
        String fieldName = null;
        ClusterName clusterName = ClusterName.DEFAULT;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                if ("_nodes".equals(fieldName)) {
                    this.parseNodeResults(parser);
                } else if ("nodes".equals(fieldName)) {
                    parser.nextToken();
                    nodes = this.parseNodes(parser);
                }
            } else if (token == XContentParser.Token.VALUE_STRING && "cluster_name".equals(fieldName)) {
                clusterName = new ClusterName(parser.text());
            }
            parser.nextToken();
        }
        return new NodesStatsResponse(clusterName, nodes, Collections.emptyList());
    }

    protected List<NodeStats> parseNodes(XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<NodeStats> list = new ArrayList<NodeStats>();
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                list.add(this.parseNodeStats(parser, fieldName));
            }
            parser.nextToken();
        }
        return list;
    }

    protected NodeStats parseNodeStats(XContentParser parser, String nodeId) throws IOException {
        XContentParser.Token token;
        new ArrayList();
        String fieldName = null;
        String nodeName = "";
        long timestamp = 0L;
        HashSet roles = new HashSet();
        NodeIndicesStats indices = null;
        OsStats os = null;
        ProcessStats process = null;
        JvmStats jvm = null;
        ThreadPoolStats threadPool = null;
        FsInfo fs = null;
        TransportStats transport = null;
        HttpStats http = null;
        AllCircuitBreakerStats breaker = null;
        ScriptStats scriptStats = null;
        DiscoveryStats discoveryStats = null;
        IngestStats ingestStats = null;
        AdaptiveSelectionStats adaptiveSelectionStats = null;
        ScriptCacheStats scriptCacheStats = null;
        IndexingPressureStats indexingPressureStats = null;
        ShardIndexingPressureStats shardIndexingPressureStats = null;
        SearchBackpressureStats searchBackpressureStats = null;
        ClusterManagerThrottlingStats clusterManagerThrottlingStats = null;
        WeightedRoutingStats weightedRoutingStats = null;
        FileCacheStats fileCacheStats = null;
        TaskCancellationStats taskCancellationStats = null;
        SearchPipelineStats searchPipelineStats = null;
        HashMap attributes = new HashMap();
        TransportAddress transportAddress = new TransportAddress(TransportAddress.META_ADDRESS, 0);
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("indices".equals(fieldName)) {
                    indices = this.parseNodeIndicesStats(parser);
                } else if ("os".equals(fieldName)) {
                    os = this.parseOsStats(parser);
                } else if ("process".equals(fieldName)) {
                    process = this.parseProcessStats(parser);
                } else if ("jvm".equals(fieldName)) {
                    jvm = this.parseJvmStats(parser);
                } else if ("thread_pool".equals(fieldName)) {
                    threadPool = this.parseThreadPoolStats(parser);
                } else if ("fs".equals(fieldName)) {
                    fs = this.parseFsInfo(parser);
                } else if ("transport".equals(fieldName)) {
                    transport = this.parseTransportStats(parser);
                } else if ("http".equals(fieldName)) {
                    http = this.parseHttpStats(parser);
                } else if ("breakers".equals(fieldName)) {
                    breaker = this.parseAllCircuitBreakerStats(parser);
                } else if ("script".equals(fieldName)) {
                    scriptStats = this.parseScriptStats(parser);
                } else if ("discovery".equals(fieldName)) {
                    discoveryStats = this.parseDiscoveryStats(parser);
                } else if ("ingest".equals(fieldName)) {
                    ingestStats = this.parseIngestStats(parser);
                } else if ("adaptive_selection".equals(fieldName)) {
                    adaptiveSelectionStats = this.parseAdaptiveSelectionStats(parser);
                } else if ("script_cache".equals(fieldName)) {
                    scriptCacheStats = this.parseScriptCacheStats(parser);
                } else if ("indexing_pressure".equals(fieldName)) {
                    indexingPressureStats = this.parseIndexingPressureStats(parser);
                } else if ("shard_indexing_pressure".equals(fieldName)) {
                    shardIndexingPressureStats = this.parseShardIndexingPressureStats(parser);
                } else if ("search_backpressure".equals(fieldName)) {
                    searchBackpressureStats = this.parseSearchBackpressureStats(parser);
                } else if ("cluster_manager_throttling".equals(fieldName)) {
                    clusterManagerThrottlingStats = this.parseClusterManagerThrottlingStats(parser);
                } else if ("weighted_routing".equals(fieldName)) {
                    weightedRoutingStats = this.parseWeightedRoutingStats(parser);
                } else if ("file_cache".equals(fieldName)) {
                    fileCacheStats = this.parseFileCacheStats(parser);
                } else if ("task_cancellation".equals(fieldName)) {
                    taskCancellationStats = this.parseTaskCancellationStats(parser);
                } else if ("search_pipeline".equals(fieldName)) {
                    searchPipelineStats = this.parseSearchPipelineStats(parser);
                } else {
                    this.consumeObject(parser);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("timestamp".equals(fieldName)) {
                    timestamp = parser.longValue();
                }
            } else if (token == XContentParser.Token.VALUE_STRING) {
                if ("name".equals(fieldName)) {
                    nodeName = parser.text();
                } else if ("transport_address".equals(fieldName)) {
                    transportAddress = HttpNodesStatsAction.parseTransportAddress(parser.text());
                }
            }
            parser.nextToken();
        }
        DiscoveryNode node = new DiscoveryNode(nodeName, nodeId, transportAddress, attributes, roles, Version.CURRENT);
        return new NodeStats(node, timestamp, indices, os, process, jvm, threadPool, fs, transport, http, breaker, scriptStats, discoveryStats, ingestStats, adaptiveSelectionStats, scriptCacheStats, indexingPressureStats, shardIndexingPressureStats, searchBackpressureStats, clusterManagerThrottlingStats, weightedRoutingStats, fileCacheStats, taskCancellationStats, searchPipelineStats);
    }

    public static TransportAddress parseTransportAddress(String addr) {
        try {
            if (addr.startsWith("[")) {
                String[] values = addr.split("\\]:");
                int port = 0;
                if (values.length > 1) {
                    port = Integer.parseInt(values[1]);
                }
                return new TransportAddress(InetAddress.getByName(values[0].replace('[', ' ').replace(']', ' ').trim()), port);
            }
            String[] values = addr.split(":");
            int port = 0;
            if (values.length > 1) {
                port = Integer.parseInt(values[1]);
            }
            return new TransportAddress(InetAddress.getByName(values[0]), port);
        }
        catch (Exception e) {
            return new TransportAddress(TransportAddress.META_ADDRESS, 0);
        }
    }

    protected AdaptiveSelectionStats parseAdaptiveSelectionStats(XContentParser parser) throws IOException {
        this.consumeObject(parser);
        return new AdaptiveSelectionStats(Collections.emptyMap(), Collections.emptyMap());
    }

    protected ScriptCacheStats parseScriptCacheStats(XContentParser parser) throws IOException {
        this.consumeObject(parser);
        return new ScriptCacheStats(Collections.emptyMap());
    }

    protected IndexingPressureStats parseIndexingPressureStats(XContentParser parser) throws IOException {
        this.consumeObject(parser);
        return new IndexingPressureStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    protected ShardIndexingPressureStats parseShardIndexingPressureStats(XContentParser parser) throws IOException {
        this.consumeObject(parser);
        return new ShardIndexingPressureStats(Collections.emptyMap(), 0L, 0L, 0L, false, false);
    }

    protected SearchBackpressureStats parseSearchBackpressureStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        SearchBackpressureMode mode = SearchBackpressureMode.DISABLED;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("search_task".equals(fieldName) || "search_shard_task".equals(fieldName)) {
                    this.consumeObject(parser);
                } else if ("mode".equals(fieldName)) {
                    mode = SearchBackpressureMode.valueOf((String)parser.text());
                }
            }
            parser.nextToken();
        }
        return new SearchBackpressureStats(new SearchTaskStats(0L, 0L, Collections.emptyMap()), new SearchShardTaskStats(0L, 0L, Collections.emptyMap()), mode);
    }

    protected ClusterManagerThrottlingStats parseClusterManagerThrottlingStats(XContentParser parser) throws IOException {
        this.consumeObject(parser);
        return new ClusterManagerThrottlingStats();
    }

    protected WeightedRoutingStats parseWeightedRoutingStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        int failOpenCount = 0;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER && "stats".equals(fieldName)) {
                failOpenCount = this.parseFailOpenCount(parser);
            }
            parser.nextToken();
        }
        WeightedRoutingStats stats = WeightedRoutingStats.getInstance();
        stats.resetFailOpenCount();
        for (int i = 0; i < failOpenCount; ++i) {
            stats.updateFailOpenCount();
        }
        return stats;
    }

    protected int parseFailOpenCount(XContentParser parser) throws IOException {
        XContentParser.Token token;
        int failOpenCount = 0;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER && "fail_open_count".equals(fieldName)) {
                failOpenCount = parser.intValue();
            }
            parser.nextToken();
        }
        return failOpenCount;
    }

    protected FileCacheStats parseFileCacheStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        long timestamp = 0L;
        long active = 0L;
        long total = 0L;
        long used = 0L;
        long evicted = 0L;
        long hits = 0L;
        long misses = 0L;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("timestamp".equals(fieldName)) {
                    timestamp = parser.longValue();
                } else if ("active_in_bytes".equals(fieldName)) {
                    active = parser.longValue();
                } else if ("total_in_bytes".equals(fieldName)) {
                    total = parser.longValue();
                } else if ("used_in_bytes".equals(fieldName)) {
                    used = parser.longValue();
                } else if ("evictions_in_bytes".equals(fieldName)) {
                    evicted = parser.longValue();
                } else if ("hit_count".equals(fieldName)) {
                    hits = parser.longValue();
                } else if ("miss_count".equals(fieldName)) {
                    misses = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new FileCacheStats(timestamp, active, total, used, evicted, hits, misses);
    }

    protected TaskCancellationStats parseTaskCancellationStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        SearchShardTaskCancellationStats searchShardTaskCancellationStats = null;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER && "search_shard_task".equals(fieldName)) {
                searchShardTaskCancellationStats = this.parseSearchShardTaskCancellationStats(parser);
            }
            parser.nextToken();
        }
        return new TaskCancellationStats(searchShardTaskCancellationStats);
    }

    protected SearchShardTaskCancellationStats parseSearchShardTaskCancellationStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        long currentLongRunningCancelledTaskCount = 0L;
        long totalLongRunningCancelledTaskCount = 0L;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("current_count_post_cancel".equals(fieldName)) {
                    currentLongRunningCancelledTaskCount = parser.longValue();
                } else if ("total_count_post_cancel".equals(fieldName)) {
                    totalLongRunningCancelledTaskCount = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new SearchShardTaskCancellationStats(currentLongRunningCancelledTaskCount, totalLongRunningCancelledTaskCount);
    }

    protected SearchPipelineStats parseSearchPipelineStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        OperationStats totalRequestStats = null;
        OperationStats totalResponseStats = null;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total_request".equals(fieldName)) {
                    totalRequestStats = this.parseOperationStats(parser);
                } else if ("total_response".equals(fieldName)) {
                    totalResponseStats = this.parseOperationStats(parser);
                } else if ("pipelines".equals(fieldName)) {
                    this.consumeObject(parser);
                }
            }
            parser.nextToken();
        }
        return new SearchPipelineStats(totalRequestStats, totalResponseStats, Collections.emptyList(), Collections.emptyMap());
    }

    protected OperationStats parseOperationStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        long count = 0L;
        long totalTimeInMillis = 0L;
        long current = 0L;
        long failedCount = 0L;
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("count".equals(fieldName)) {
                    count = parser.longValue();
                } else if ("time_in_millis".equals(fieldName)) {
                    totalTimeInMillis = parser.longValue();
                } else if ("current".equals(fieldName)) {
                    current = parser.longValue();
                } else if ("failed".equals(fieldName)) {
                    failedCount = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new OperationStats(count, totalTimeInMillis, current, failedCount);
    }

    protected IngestStats parseIngestStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        OperationStats totalStats = null;
        ArrayList<IngestStats.PipelineStat> pipelineStats = new ArrayList<IngestStats.PipelineStat>();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("total".equals(fieldName)) {
                    ingestCount = 0L;
                    ingestTimeInMillis = 0L;
                    ingestCurrent = 0L;
                    ingestFailedCount = 0L;
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                        } else if (token == XContentParser.Token.VALUE_NUMBER) {
                            if ("count".equals(fieldName)) {
                                ingestCount = parser.longValue();
                            } else if ("time_in_millis".equals(fieldName)) {
                                ingestTimeInMillis = parser.longValue();
                            } else if ("current".equals(fieldName)) {
                                ingestCurrent = parser.longValue();
                            } else if ("failed".equals(fieldName)) {
                                ingestFailedCount = parser.longValue();
                            }
                        }
                        parser.nextToken();
                    }
                    totalStats = new OperationStats(ingestCount, ingestTimeInMillis, ingestCurrent, ingestFailedCount);
                } else if ("pipelines".equals(fieldName)) {
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            ingestCount = 0L;
                            ingestTimeInMillis = 0L;
                            ingestCurrent = 0L;
                            ingestFailedCount = 0L;
                            String name = fieldName;
                            while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    fieldName = parser.currentName();
                                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                                    if ("count".equals(fieldName)) {
                                        ingestCount = parser.longValue();
                                    } else if ("time_in_millis".equals(fieldName)) {
                                        ingestTimeInMillis = parser.longValue();
                                    } else if ("current".equals(fieldName)) {
                                        ingestCurrent = parser.longValue();
                                    } else if ("failed".equals(fieldName)) {
                                        ingestFailedCount = parser.longValue();
                                    }
                                }
                                parser.nextToken();
                            }
                            pipelineStats.add(new IngestStats.PipelineStat(name, new OperationStats(ingestCount, ingestTimeInMillis, ingestCurrent, ingestFailedCount)));
                        }
                        parser.nextToken();
                    }
                } else {
                    this.consumeObject(parser);
                }
            }
            parser.nextToken();
        }
        return new IngestStats(totalStats, pipelineStats, Collections.emptyMap());
    }

    protected DiscoveryStats parseDiscoveryStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        PendingClusterStateStats queueStats = null;
        PublishClusterStateStats publishStats = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("cluster_state_queue".equals(fieldName)) {
                    queueStats = this.parsePendingClusterStateStats(parser);
                } else if ("published_cluster_states".equals(fieldName)) {
                    publishStats = this.parsePublishClusterStateStats(parser);
                } else {
                    this.consumeObject(parser);
                }
            }
            parser.nextToken();
        }
        return new DiscoveryStats(queueStats, publishStats);
    }

    protected PublishClusterStateStats parsePublishClusterStateStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long fullClusterStateReceivedCount = 0L;
        long incompatibleClusterStateDiffReceivedCount = 0L;
        long compatibleClusterStateDiffReceivedCount = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("full_states".equals(fieldName)) {
                    fullClusterStateReceivedCount = parser.intValue();
                } else if ("incompatible_diffs".equals(fieldName)) {
                    incompatibleClusterStateDiffReceivedCount = parser.intValue();
                } else if ("compatible_diffs".equals(fieldName)) {
                    compatibleClusterStateDiffReceivedCount = parser.intValue();
                }
            }
            parser.nextToken();
        }
        return new PublishClusterStateStats(fullClusterStateReceivedCount, incompatibleClusterStateDiffReceivedCount, compatibleClusterStateDiffReceivedCount);
    }

    protected PendingClusterStateStats parsePendingClusterStateStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        int total = 0;
        int pending = 0;
        int committed = 0;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total".equals(fieldName)) {
                    total = parser.intValue();
                } else if ("pending".equals(fieldName)) {
                    pending = parser.intValue();
                } else if ("committed".equals(fieldName)) {
                    committed = parser.intValue();
                }
            }
            parser.nextToken();
        }
        return new PendingClusterStateStats(total, pending, committed);
    }

    protected ScriptStats parseScriptStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("compilations".equals(fieldName)) {
                    compilations = parser.longValue();
                } else if ("cache_evictions".equals(fieldName)) {
                    cacheEvictions = parser.longValue();
                } else if ("compilation_limit_triggered".equals(fieldName)) {
                    compilationLimitTriggered = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new ScriptStats(compilations, cacheEvictions, compilationLimitTriggered);
    }

    protected AllCircuitBreakerStats parseAllCircuitBreakerStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        ArrayList<CircuitBreakerStats> allStats = new ArrayList<CircuitBreakerStats>();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                long limit = 0L;
                long estimated = 0L;
                double overhead = 0.0;
                long trippedCount = 0L;
                String name = fieldName;
                while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        if ("limit_size_in_bytes".equals(fieldName)) {
                            limit = parser.longValue();
                        } else if ("estimated_size_in_bytes".equals(fieldName)) {
                            estimated = parser.longValue();
                        } else if ("overhead".equals(fieldName)) {
                            overhead = parser.doubleValue();
                        } else if ("tripped".equals(fieldName)) {
                            trippedCount = parser.longValue();
                        }
                    }
                    parser.nextToken();
                }
                allStats.add(new CircuitBreakerStats(name, limit, estimated, overhead, trippedCount));
            }
            parser.nextToken();
        }
        return new AllCircuitBreakerStats(allStats.toArray(new CircuitBreakerStats[allStats.size()]));
    }

    protected HttpStats parseHttpStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long serverOpen = 0L;
        long totalOpened = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("current_open".equals(fieldName)) {
                    serverOpen = parser.longValue();
                } else if ("total_opened".equals(fieldName)) {
                    totalOpened = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new HttpStats(serverOpen, totalOpened);
    }

    protected TransportStats parseTransportStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long serverOpen = 0L;
        long totalOutboundConnections = 0L;
        long rxCount = 0L;
        long rxSize = 0L;
        long txCount = 0L;
        long txSize = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("server_open".equals(fieldName)) {
                    serverOpen = parser.longValue();
                } else if ("total_outbound_connections".equals(fieldName)) {
                    totalOutboundConnections = parser.longValue();
                } else if ("rx_count".equals(fieldName)) {
                    rxCount = parser.longValue();
                } else if ("rx_size_in_bytes".equals(fieldName)) {
                    rxSize = parser.longValue();
                } else if ("tx_count".equals(fieldName)) {
                    txCount = parser.longValue();
                } else if ("tx_size_in_bytes".equals(fieldName)) {
                    txSize = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new TransportStats(serverOpen, totalOutboundConnections, rxCount, rxSize, txCount, txSize);
    }

    protected FsInfo parseFsInfo(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long timestamp = 0L;
        FsInfo.IoStats ioStats = null;
        ArrayList<FsInfo.Path> paths = new ArrayList<FsInfo.Path>();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("data".equals(fieldName)) {
                    parser.nextToken();
                    while ((token = parser.currentToken()) != XContentParser.Token.END_ARRAY) {
                        String path = null;
                        String mount = null;
                        long total = 0L;
                        long available = 0L;
                        long free = 0L;
                        parser.nextToken();
                        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                fieldName = parser.currentName();
                            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                                if ("total_in_bytes".equals(fieldName)) {
                                    total = parser.longValue();
                                } else if ("available_in_bytes".equals(fieldName)) {
                                    available = parser.longValue();
                                } else if ("free_in_bytes".equals(fieldName)) {
                                    free = parser.longValue();
                                }
                            } else if (token == XContentParser.Token.VALUE_STRING) {
                                if ("path".equals(fieldName)) {
                                    path = parser.text();
                                } else if ("mount".equals(fieldName)) {
                                    mount = parser.text();
                                }
                            }
                            parser.nextToken();
                        }
                        paths.add(new FsInfo.Path(path, mount, total, free, available));
                        parser.nextToken();
                    }
                } else {
                    this.consumeObject(parser);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER && "timestamp".equals(fieldName)) {
                timestamp = parser.longValue();
            }
            parser.nextToken();
        }
        return new FsInfo(timestamp, ioStats, paths.toArray(new FsInfo.Path[paths.size()]));
    }

    protected DiskUsage parseFsInfoIskUsage(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        String nodeId = "";
        String nodeName = "";
        String path = null;
        long totalBytes = 0L;
        long freeBytes = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total_in_bytes".equals(fieldName)) {
                    totalBytes = parser.longValue();
                } else if ("available_in_bytes".equals(fieldName)) {
                    freeBytes = parser.longValue();
                }
            } else if (token == XContentParser.Token.VALUE_STRING && "path".equals(fieldName)) {
                path = parser.text();
            }
            parser.nextToken();
        }
        return new DiskUsage("", "", path, totalBytes, freeBytes);
    }

    protected ThreadPoolStats parseThreadPoolStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        ArrayList<ThreadPoolStats.Stats> stats = new ArrayList<ThreadPoolStats.Stats>();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                int threads = 0;
                int queue = 0;
                int active = 0;
                long rejected = 0L;
                int largest = 0;
                long completed = 0L;
                long waitTimeNanos = 0L;
                String name = fieldName;
                while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        if ("threads".equals(fieldName)) {
                            threads = parser.intValue();
                        } else if ("queue".equals(fieldName)) {
                            queue = parser.intValue();
                        } else if ("active".equals(fieldName)) {
                            active = parser.intValue();
                        } else if ("rejected".equals(fieldName)) {
                            rejected = parser.longValue();
                        } else if ("largest".equals(fieldName)) {
                            largest = parser.intValue();
                        } else if ("completed".equals(fieldName)) {
                            completed = parser.longValue();
                        } else if ("total_wait_time_in_nanos".equals(fieldName)) {
                            waitTimeNanos = parser.longValue();
                        }
                    }
                    parser.nextToken();
                }
                stats.add(new ThreadPoolStats.Stats(name, threads, queue, active, rejected, largest, completed, waitTimeNanos));
            }
            parser.nextToken();
        }
        return new ThreadPoolStats(stats);
    }

    protected JvmStats parseJvmStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long timestamp = 0L;
        long uptime = 0L;
        JvmStats.Mem mem = null;
        JvmStats.Threads threads = null;
        JvmStats.GarbageCollectors gc = null;
        List<JvmStats.BufferPool> bufferPools = null;
        JvmStats.Classes classes = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("mem".equals(fieldName)) {
                    mem = this.parseJvmStatsMem(parser);
                } else if ("threads".equals(fieldName)) {
                    threads = this.parseJvmStatsThreads(parser);
                } else if ("gc".equals(fieldName)) {
                    gc = this.parseJvmStatsGc(parser);
                } else if ("buffer_pools".equals(fieldName)) {
                    bufferPools = this.parseJvmStatsBufferPools(parser);
                } else if ("classes".equals(fieldName)) {
                    classes = this.parseJvmStatsClasses(parser);
                } else {
                    this.consumeObject(parser);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("timestamp".equals(fieldName)) {
                    timestamp = parser.longValue();
                } else if ("uptime_in_millis".equals(fieldName)) {
                    uptime = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new JvmStats(timestamp, uptime, mem, threads, gc, bufferPools, classes);
    }

    protected JvmStats.Classes parseJvmStatsClasses(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long loadedClassCount = 0L;
        long totalLoadedClassCount = 0L;
        long unloadedClassCount = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("current_loaded_count".equals(fieldName)) {
                    loadedClassCount = parser.longValue();
                } else if ("used_in_bytes".equals(fieldName)) {
                    totalLoadedClassCount = parser.longValue();
                } else if ("total_unloaded_count".equals(fieldName)) {
                    unloadedClassCount = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new JvmStats.Classes(loadedClassCount, totalLoadedClassCount, unloadedClassCount);
    }

    protected List<JvmStats.BufferPool> parseJvmStatsBufferPools(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        ArrayList<JvmStats.BufferPool> bufferPools = new ArrayList<JvmStats.BufferPool>();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                long count = 0L;
                long totalCapacity = 0L;
                long used = 0L;
                String name = fieldName;
                while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        if ("count".equals(fieldName)) {
                            count = parser.longValue();
                        } else if ("total_capacity_in_bytes".equals(fieldName)) {
                            totalCapacity = parser.longValue();
                        } else if ("used_in_bytes".equals(fieldName)) {
                            used = parser.longValue();
                        }
                    }
                    parser.nextToken();
                }
                bufferPools.add(new JvmStats.BufferPool(name, count, totalCapacity, used));
            }
            parser.nextToken();
        }
        return bufferPools;
    }

    protected JvmStats.GarbageCollectors parseJvmStatsGc(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        ArrayList<JvmStats.GarbageCollector> collectors = new ArrayList<JvmStats.GarbageCollector>();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("collectors".equals(fieldName)) {
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            parser.nextToken();
                            long collectionCount = 0L;
                            long collectionTime = 0L;
                            String name = fieldName;
                            while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    fieldName = parser.currentName();
                                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                                    if ("collection_count".equals(fieldName)) {
                                        collectionCount = parser.longValue();
                                    } else if ("collection_time_in_millis".equals(fieldName)) {
                                        collectionTime = parser.longValue();
                                    }
                                }
                                parser.nextToken();
                            }
                            collectors.add(new JvmStats.GarbageCollector(name, collectionCount, collectionTime));
                        }
                        parser.nextToken();
                    }
                } else {
                    this.consumeObject(parser);
                }
            }
            parser.nextToken();
        }
        return new JvmStats.GarbageCollectors(collectors.toArray(new JvmStats.GarbageCollector[collectors.size()]));
    }

    protected JvmStats.Threads parseJvmStatsThreads(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        int count = 0;
        int peakCount = 0;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("count".equals(fieldName)) {
                    count = parser.intValue();
                } else if ("peak_count".equals(fieldName)) {
                    peakCount = parser.intValue();
                }
            }
            parser.nextToken();
        }
        return new JvmStats.Threads(count, peakCount);
    }

    protected JvmStats.Mem parseJvmStatsMem(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long heapCommitted = 0L;
        long heapUsed = 0L;
        long heapMax = 0L;
        long nonHeapCommitted = 0L;
        long nonHeapUsed = 0L;
        ArrayList<JvmStats.MemoryPool> pools = new ArrayList<JvmStats.MemoryPool>();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("pools".equals(fieldName)) {
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            parser.nextToken();
                            long used = 0L;
                            long max = 0L;
                            long peakUsed = 0L;
                            long peakMax = 0L;
                            JvmStats.MemoryPoolGcStats lastGcStats = null;
                            String name = fieldName;
                            while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    fieldName = parser.currentName();
                                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                                    if ("used_in_bytes".equals(fieldName)) {
                                        used = parser.longValue();
                                    } else if ("max_in_bytes".equals(fieldName)) {
                                        max = parser.longValue();
                                    } else if ("peak_used_in_bytes".equals(fieldName)) {
                                        peakUsed = parser.longValue();
                                    } else if ("peak_max_in_bytes".equals(fieldName)) {
                                        peakMax = parser.longValue();
                                    }
                                } else if (token == XContentParser.Token.START_OBJECT) {
                                    if ("last_gc_stats".equals(fieldName)) {
                                        parser.nextToken();
                                        long lastUsed = 0L;
                                        long lastMax = 0L;
                                        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                                            if (token == XContentParser.Token.FIELD_NAME) {
                                                fieldName = parser.currentName();
                                            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                                                if ("used_in_bytes".equals(fieldName)) {
                                                    lastUsed = parser.longValue();
                                                } else if ("max_in_bytes".equals(fieldName)) {
                                                    lastMax = parser.longValue();
                                                }
                                            }
                                            parser.nextToken();
                                        }
                                        lastGcStats = new JvmStats.MemoryPoolGcStats(lastUsed, lastMax);
                                    } else {
                                        this.consumeObject(parser);
                                    }
                                }
                                parser.nextToken();
                            }
                            pools.add(new JvmStats.MemoryPool(name, used, max, peakUsed, peakMax, lastGcStats != null ? lastGcStats : new JvmStats.MemoryPoolGcStats(0L, 0L)));
                        }
                        parser.nextToken();
                    }
                } else {
                    this.consumeObject(parser);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("heap_committed_in_bytes".equals(fieldName)) {
                    heapCommitted = parser.longValue();
                } else if ("heap_used_in_bytes".equals(fieldName)) {
                    heapUsed = parser.longValue();
                } else if ("heap_max_in_bytes".equals(fieldName)) {
                    heapMax = parser.longValue();
                } else if ("non_heap_committed_in_bytes".equals(fieldName)) {
                    nonHeapCommitted = parser.longValue();
                } else if ("non_heap_used_in_bytes".equals(fieldName)) {
                    nonHeapUsed = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new JvmStats.Mem(heapCommitted, heapUsed, heapMax, nonHeapCommitted, nonHeapUsed, pools);
    }

    protected ProcessStats parseProcessStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long timestamp = 0L;
        long openFileDescriptors = 0L;
        long maxFileDescriptors = 0L;
        ProcessStats.Cpu cpu = null;
        ProcessStats.Mem mem = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("cpu".equals(fieldName)) {
                    cpu = this.parseProcessStatsCpu(parser);
                } else if ("mem".equals(fieldName)) {
                    mem = this.parseProcessStatsMem(parser);
                } else {
                    this.consumeObject(parser);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("timestamp".equals(fieldName)) {
                    timestamp = parser.longValue();
                } else if ("open_file_descriptors".equals(fieldName)) {
                    openFileDescriptors = parser.longValue();
                } else if ("max_file_descriptors".equals(fieldName)) {
                    maxFileDescriptors = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new ProcessStats(timestamp, openFileDescriptors, maxFileDescriptors, cpu, mem);
    }

    protected ProcessStats.Mem parseProcessStatsMem(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long totalVirtual = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER && "total_virtual_in_bytes".equals(fieldName)) {
                totalVirtual = parser.longValue();
            }
            parser.nextToken();
        }
        return new ProcessStats.Mem(totalVirtual);
    }

    protected ProcessStats.Cpu parseProcessStatsCpu(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        short percent = 0;
        long total = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("percent".equals(fieldName)) {
                    percent = parser.shortValue();
                } else if ("total_in_millis".equals(fieldName)) {
                    total = parser.intValue();
                }
            }
            parser.nextToken();
        }
        return new ProcessStats.Cpu(percent, total);
    }

    protected OsStats parseOsStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long timestamp = 0L;
        OsStats.Cpu cpu = null;
        OsStats.Mem mem = null;
        OsStats.Swap swap = null;
        OsStats.Cgroup cgroup = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("cpu".equals(fieldName)) {
                    cpu = this.parseOsStatsCpu(parser);
                } else if ("mem".equals(fieldName)) {
                    mem = this.parseOsStatsMem(parser);
                } else if ("swap".equals(fieldName)) {
                    swap = this.parseOsStatsSwap(parser);
                } else if ("cgroup".equals(fieldName)) {
                    cgroup = this.parseOsStatsCgroup(parser);
                } else {
                    this.consumeObject(parser);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER && "timestamp".equals(fieldName)) {
                timestamp = parser.longValue();
            }
            parser.nextToken();
        }
        return new OsStats(timestamp, cpu, mem, swap, cgroup);
    }

    protected OsStats.Cgroup parseOsStatsCgroup(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        String cpuAcctControlGroup = null;
        long cpuAcctUsageNanos = 0L;
        String cpuControlGroup = null;
        long cpuCfsPeriodMicros = 0L;
        long cpuCfsQuotaMicros = 0L;
        OsStats.Cgroup.CpuStat cpuStat = null;
        String memoryControlGroup = null;
        String memoryLimitInBytes = null;
        String memoryUsageInBytes = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("cpuacct".equals(fieldName)) {
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                        } else if (token == XContentParser.Token.VALUE_STRING) {
                            if ("control_group".equals(fieldName)) {
                                cpuAcctControlGroup = parser.text();
                            }
                        } else if (token == XContentParser.Token.VALUE_NUMBER && "usage_nanos".equals(fieldName)) {
                            cpuAcctUsageNanos = parser.longValue();
                        }
                        parser.nextToken();
                    }
                } else if ("cpu".equals(fieldName)) {
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                        } else if (token == XContentParser.Token.VALUE_STRING) {
                            if ("control_group".equals(fieldName)) {
                                cpuControlGroup = parser.text();
                            }
                        } else if (token == XContentParser.Token.VALUE_NUMBER) {
                            if ("cfs_period_micros".equals(fieldName)) {
                                cpuCfsPeriodMicros = parser.longValue();
                            } else if ("cfs_quota_micros".equals(fieldName)) {
                                cpuCfsQuotaMicros = parser.longValue();
                            }
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            parser.nextToken();
                            if ("stat".equals(fieldName)) {
                                long numberOfElapsedPeriods = 0L;
                                long numberOfTimesThrottled = 0L;
                                long timeThrottledNanos = 0L;
                                while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                                    if (token == XContentParser.Token.FIELD_NAME) {
                                        fieldName = parser.currentName();
                                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                                        if ("number_of_elapsed_periods".equals(fieldName)) {
                                            numberOfElapsedPeriods = parser.longValue();
                                        } else if ("number_of_times_throttled".equals(fieldName)) {
                                            numberOfTimesThrottled = parser.longValue();
                                        } else if ("time_throttled_nanos".equals(fieldName)) {
                                            timeThrottledNanos = parser.longValue();
                                        }
                                    }
                                    parser.nextToken();
                                }
                                cpuStat = new OsStats.Cgroup.CpuStat(numberOfElapsedPeriods, numberOfTimesThrottled, timeThrottledNanos);
                            } else {
                                this.consumeObject(parser);
                            }
                        }
                        parser.nextToken();
                    }
                } else if ("memory".equals(fieldName)) {
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                        } else if (token == XContentParser.Token.VALUE_STRING) {
                            if ("control_group".equals(fieldName)) {
                                memoryControlGroup = parser.text();
                            } else if ("limit_in_bytes".equals(fieldName)) {
                                memoryLimitInBytes = parser.text();
                            } else if ("usage_in_bytes".equals(fieldName)) {
                                memoryUsageInBytes = parser.text();
                            }
                        }
                        parser.nextToken();
                    }
                } else {
                    this.consumeObject(parser);
                }
            }
            parser.nextToken();
        }
        return new OsStats.Cgroup(cpuAcctControlGroup, cpuAcctUsageNanos, cpuControlGroup, cpuCfsPeriodMicros, cpuCfsQuotaMicros, cpuStat, memoryControlGroup, memoryLimitInBytes, memoryUsageInBytes);
    }

    protected OsStats.Swap parseOsStatsSwap(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long total = 0L;
        long free = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total_in_bytes".equals(fieldName)) {
                    total = parser.longValue();
                } else if ("free_in_bytes".equals(fieldName)) {
                    free = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new OsStats.Swap(total, free);
    }

    protected OsStats.Mem parseOsStatsMem(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long total = 0L;
        long free = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total_in_bytes".equals(fieldName)) {
                    total = parser.longValue();
                } else if ("free_in_bytes".equals(fieldName)) {
                    free = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new OsStats.Mem(total, free);
    }

    protected OsStats.Cpu parseOsStatsCpu(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        short systemCpuPercent = 0;
        double[] systemLoadAverage = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("load_average".equals(fieldName)) {
                    HashMap<String, Double> values = new HashMap<String, Double>();
                    String key = null;
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            key = parser.currentName();
                        } else if (token == XContentParser.Token.VALUE_NUMBER) {
                            values.put(key, parser.doubleValue());
                        }
                        parser.nextToken();
                    }
                    systemLoadAverage = new double[]{values.containsKey("1m") ? (Double)values.get("1m") : -1.0, values.containsKey("5m") ? (Double)values.get("5m") : -1.0, values.containsKey("15m") ? (Double)values.get("15m") : -1.0};
                } else {
                    this.consumeObject(parser);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER && "percent".equals(fieldName)) {
                systemCpuPercent = parser.shortValue();
            }
            parser.nextToken();
        }
        return new OsStats.Cpu(systemCpuPercent, systemLoadAverage);
    }

    protected NodeIndicesStats parseNodeIndicesStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        DocsStats docs = null;
        StoreStats store = null;
        IndexingStats indexing = null;
        GetStats get = null;
        SearchStats search = null;
        MergeStats merge = null;
        RefreshStats refresh = null;
        FlushStats flush = null;
        WarmerStats warmer = null;
        QueryCacheStats queryCache = null;
        FieldDataStats fieldData = null;
        CompletionStats completion = null;
        SegmentsStats segments = null;
        TranslogStats translog = null;
        RequestCacheStats requestCache = null;
        RecoveryStats recoveryStats = null;
        SearchRequestStats searchRequestStats = new SearchRequestStats();
        Map statsByShard = Collections.emptyMap();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("docs".equals(fieldName)) {
                    docs = this.parseDocsStats(parser);
                } else if ("store".equals(fieldName)) {
                    store = this.parseStoreStats(parser);
                } else if ("indexing".equals(fieldName)) {
                    indexing = this.parseIndexingStats(parser);
                } else if ("get".equals(fieldName)) {
                    get = this.parseGetStats(parser);
                } else if ("search".equals(fieldName)) {
                    search = this.parseSearchStats(parser);
                } else if ("merge".equals(fieldName)) {
                    merge = this.parseMergeStats(parser);
                } else if ("refresh".equals(fieldName)) {
                    refresh = this.parseRefreshStats(parser);
                } else if ("flush".equals(fieldName)) {
                    flush = this.parseFlushStats(parser);
                } else if ("warmer".equals(fieldName)) {
                    warmer = this.parseWarmerStats(parser);
                } else if ("query_cache".equals(fieldName)) {
                    queryCache = this.parseQueryCacheStats(parser);
                } else if ("fielddata".equals(fieldName)) {
                    fieldData = this.parseFieldDataStats(parser);
                } else if ("completion".equals(fieldName)) {
                    completion = this.parseCompletionStats(parser);
                } else if ("segments".equals(fieldName)) {
                    segments = this.parseSegmentsStats(parser);
                } else if ("translog".equals(fieldName)) {
                    translog = this.parseTranslogStats(parser);
                } else if ("request_cache".equals(fieldName)) {
                    requestCache = this.parseRequestCacheStats(parser);
                } else if ("recovery".equals(fieldName)) {
                    recoveryStats = this.parseRecoveryStats(parser);
                } else {
                    this.consumeObject(parser);
                }
            }
            parser.nextToken();
        }
        try (ByteArrayStreamOutput out = new ByteArrayStreamOutput();){
            NodeIndicesStats nodeIndicesStats;
            out.writeOptionalWriteable((Writeable)docs);
            out.writeOptionalWriteable((Writeable)store);
            out.writeOptionalWriteable((Writeable)indexing);
            out.writeOptionalWriteable((Writeable)get);
            out.writeOptionalWriteable((Writeable)search);
            out.writeOptionalWriteable((Writeable)merge);
            out.writeOptionalWriteable((Writeable)refresh);
            out.writeOptionalWriteable((Writeable)flush);
            out.writeOptionalWriteable((Writeable)warmer);
            out.writeOptionalWriteable((Writeable)queryCache);
            out.writeOptionalWriteable((Writeable)fieldData);
            out.writeOptionalWriteable((Writeable)completion);
            out.writeOptionalWriteable((Writeable)segments);
            out.writeOptionalWriteable((Writeable)translog);
            out.writeOptionalWriteable((Writeable)requestCache);
            out.writeOptionalWriteable((Writeable)recoveryStats);
            try (InputStreamStreamInput in = new InputStreamStreamInput((InputStream)new ByteArrayInputStream(out.toByteArray()));){
                nodeIndicesStats = new NodeIndicesStats(new CommonStats((StreamInput)in), statsByShard, searchRequestStats);
            }
            return nodeIndicesStats;
        }
    }

    protected RecoveryStats parseRecoveryStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        int currentAsSource = 0;
        int currentAsTarget = 0;
        long throttleTimeInNanos = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("current_as_source".equals(fieldName)) {
                    currentAsSource = parser.intValue();
                } else if ("current_as_target".equals(fieldName)) {
                    currentAsTarget = parser.intValue();
                } else if ("throttle_time_in_millis".equals(fieldName)) {
                    throttleTimeInNanos = parser.longValue();
                }
            }
            parser.nextToken();
        }
        try (ByteArrayStreamOutput out = new ByteArrayStreamOutput();){
            RecoveryStats recoveryStats;
            out.writeVInt(currentAsSource);
            out.writeVInt(currentAsTarget);
            out.writeLong(throttleTimeInNanos);
            try (InputStreamStreamInput in = new InputStreamStreamInput((InputStream)new ByteArrayInputStream(out.toByteArray()));){
                recoveryStats = new RecoveryStats((StreamInput)in);
            }
            return recoveryStats;
        }
    }

    protected RequestCacheStats parseRequestCacheStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long memorySize = 0L;
        long evictions = 0L;
        long hitCount = 0L;
        long missCount = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("memory_size_in_bytes".equals(fieldName)) {
                    memorySize = parser.longValue();
                } else if ("evictions".equals(fieldName)) {
                    evictions = parser.longValue();
                } else if ("hit_count".equals(fieldName)) {
                    hitCount = parser.longValue();
                } else if ("miss_count".equals(fieldName)) {
                    missCount = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new RequestCacheStats(memorySize, evictions, hitCount, missCount);
    }

    protected TranslogStats parseTranslogStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        int numberOfOperations = 0;
        long translogSizeInBytes = 0L;
        int uncommittedOperations = 0;
        long uncommittedSizeInBytes = 0L;
        long earliestLastModifiedAge = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("operations".equals(fieldName)) {
                    numberOfOperations = parser.intValue();
                } else if ("size_in_bytes".equals(fieldName)) {
                    translogSizeInBytes = parser.longValue();
                } else if ("uncommitted_operations".equals(fieldName)) {
                    uncommittedOperations = parser.intValue();
                } else if ("uncommitted_size_in_bytes".equals(fieldName)) {
                    uncommittedSizeInBytes = parser.longValue();
                } else if ("earliest_last_modified_age".equals(fieldName)) {
                    earliestLastModifiedAge = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new TranslogStats(numberOfOperations, translogSizeInBytes, uncommittedOperations, uncommittedSizeInBytes, earliestLastModifiedAge);
    }

    protected SegmentsStats parseSegmentsStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long count = 0L;
        long memoryInBytes = 0L;
        long termsMemoryInBytes = 0L;
        long storedFieldsMemoryInBytes = 0L;
        long termVectorsMemoryInBytes = 0L;
        long normsMemoryInBytes = 0L;
        long pointsMemoryInBytes = 0L;
        long docValuesMemoryInBytes = 0L;
        long indexWriterMemoryInBytes = 0L;
        long versionMapMemoryInBytes = 0L;
        long bitsetMemoryInBytes = 0L;
        long maxUnsafeAutoIdTimestamp = 0L;
        HashMap<String, Long> fileSizes = new HashMap<String, Long>();
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                if ("file_sizes".equals(fieldName)) {
                    String key = null;
                    while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            key = parser.currentName();
                        } else if (token == XContentParser.Token.VALUE_NUMBER) {
                            fileSizes.put(key, parser.longValue());
                        }
                        parser.nextToken();
                    }
                } else {
                    this.consumeObject(parser);
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("count".equals(fieldName)) {
                    count = parser.longValue();
                } else if ("memory_in_bytes".equals(fieldName)) {
                    memoryInBytes = parser.longValue();
                } else if ("terms_memory_in_bytes".equals(fieldName)) {
                    termsMemoryInBytes = parser.longValue();
                } else if ("stored_fields_memory_in_bytes".equals(fieldName)) {
                    storedFieldsMemoryInBytes = parser.longValue();
                } else if ("term_vectors_memory_in_bytes".equals(fieldName)) {
                    termVectorsMemoryInBytes = parser.longValue();
                } else if ("norms_memory_in_bytes".equals(fieldName)) {
                    normsMemoryInBytes = parser.longValue();
                } else if ("points_memory_in_bytes".equals(fieldName)) {
                    pointsMemoryInBytes = parser.longValue();
                } else if ("doc_values_memory_in_bytes".equals(fieldName)) {
                    docValuesMemoryInBytes = parser.longValue();
                } else if ("index_writer_memory_in_bytes".equals(fieldName)) {
                    indexWriterMemoryInBytes = parser.longValue();
                } else if ("version_map_memory_in_bytes".equals(fieldName)) {
                    versionMapMemoryInBytes = parser.longValue();
                } else if ("fixed_bit_set_memory_in_bytes".equals(fieldName)) {
                    bitsetMemoryInBytes = parser.longValue();
                } else if ("max_unsafe_auto_id_timestamp".equals(fieldName)) {
                    maxUnsafeAutoIdTimestamp = parser.longValue();
                }
            }
            parser.nextToken();
        }
        try (ByteArrayStreamOutput out = new ByteArrayStreamOutput();){
            SegmentsStats segmentsStats;
            out.writeVLong(count);
            out.writeLong(memoryInBytes);
            out.writeLong(termsMemoryInBytes);
            out.writeLong(storedFieldsMemoryInBytes);
            out.writeLong(termVectorsMemoryInBytes);
            out.writeLong(normsMemoryInBytes);
            out.writeLong(pointsMemoryInBytes);
            out.writeLong(docValuesMemoryInBytes);
            out.writeLong(indexWriterMemoryInBytes);
            out.writeLong(versionMapMemoryInBytes);
            out.writeLong(bitsetMemoryInBytes);
            out.writeLong(maxUnsafeAutoIdTimestamp);
            out.writeVInt(fileSizes.size());
            for (Map.Entry entry : fileSizes.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeLong((Long)entry.getValue());
            }
            try (InputStreamStreamInput in = new InputStreamStreamInput((InputStream)new ByteArrayInputStream(out.toByteArray()));){
                segmentsStats = new SegmentsStats((StreamInput)in);
            }
            return segmentsStats;
        }
    }

    protected CompletionStats parseCompletionStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long size = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER && "size_in_bytes".equals(fieldName)) {
                size = parser.longValue();
            }
            parser.nextToken();
        }
        return new CompletionStats(size, null);
    }

    protected FieldDataStats parseFieldDataStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long memorySize = 0L;
        long evictions = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("memory_size_in_bytes".equals(fieldName)) {
                    memorySize = parser.longValue();
                } else if ("evictions".equals(fieldName)) {
                    evictions = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new FieldDataStats(memorySize, evictions, null);
    }

    protected QueryCacheStats parseQueryCacheStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long ramBytesUsed = 0L;
        long hitCount = 0L;
        long missCount = 0L;
        long cacheCount = 0L;
        long cacheSize = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("memory_size_in_bytes".equals(fieldName)) {
                    ramBytesUsed = parser.longValue();
                } else if ("hit_count".equals(fieldName)) {
                    hitCount = parser.longValue();
                } else if ("miss_count".equals(fieldName)) {
                    missCount = parser.longValue();
                } else if ("cache_count".equals(fieldName)) {
                    cacheCount = parser.longValue();
                } else if ("cache_size".equals(fieldName)) {
                    cacheSize = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new QueryCacheStats(ramBytesUsed, hitCount, missCount, cacheCount, cacheSize);
    }

    protected WarmerStats parseWarmerStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long current = 0L;
        long total = 0L;
        long totalTimeInMillis = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("current".equals(fieldName)) {
                    current = parser.longValue();
                } else if ("total".equals(fieldName)) {
                    total = parser.longValue();
                } else if ("total_time_in_millis".equals(fieldName)) {
                    totalTimeInMillis = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new WarmerStats(current, total, totalTimeInMillis);
    }

    protected FlushStats parseFlushStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long total = 0L;
        long periodic = 0L;
        long totalTimeInMillis = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total".equals(fieldName)) {
                    total = parser.longValue();
                } else if ("periodic".equals(fieldName)) {
                    periodic = parser.longValue();
                } else if ("total_time_in_millis".equals(fieldName)) {
                    totalTimeInMillis = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new FlushStats(total, periodic, totalTimeInMillis);
    }

    protected RefreshStats parseRefreshStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long total = 0L;
        long totalTimeInMillis = 0L;
        long externalTotal = 0L;
        long externalTotalTimeInMillis = 0L;
        int listeners = 0;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total".equals(fieldName)) {
                    total = parser.longValue();
                } else if ("total_time_in_millis".equals(fieldName)) {
                    totalTimeInMillis = parser.longValue();
                } else if ("external_total".equals(fieldName)) {
                    externalTotal = parser.longValue();
                } else if ("external_total_time_in_millis".equals(fieldName)) {
                    externalTotalTimeInMillis = parser.longValue();
                } else if ("listeners".equals(fieldName)) {
                    listeners = parser.intValue();
                }
            }
            parser.nextToken();
        }
        return new RefreshStats(total, totalTimeInMillis, externalTotal, externalTotalTimeInMillis, listeners);
    }

    protected MergeStats parseMergeStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long total = 0L;
        long totalTimeInMillis = 0L;
        long totalNumDocs = 0L;
        long totalSizeInBytes = 0L;
        long current = 0L;
        long currentNumDocs = 0L;
        long currentSizeInBytes = 0L;
        long totalStoppedTimeInMillis = 0L;
        long totalThrottledTimeInMillis = 0L;
        long totalBytesPerSecAutoThrottle = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total".equals(fieldName)) {
                    total = parser.longValue();
                } else if ("total_time_in_millis".equals(fieldName)) {
                    totalTimeInMillis = parser.longValue();
                } else if ("total_docs".equals(fieldName)) {
                    totalNumDocs = parser.intValue();
                } else if ("total_size_in_bytes".equals(fieldName)) {
                    totalSizeInBytes = parser.intValue();
                } else if ("current".equals(fieldName)) {
                    current = parser.intValue();
                } else if ("current_docs".equals(fieldName)) {
                    currentNumDocs = parser.intValue();
                } else if ("current_size_in_bytes".equals(fieldName)) {
                    currentSizeInBytes = parser.intValue();
                } else if ("total_stopped_time_in_millis".equals(fieldName)) {
                    totalStoppedTimeInMillis = parser.intValue();
                } else if ("total_throttled_time_in_millis".equals(fieldName)) {
                    totalThrottledTimeInMillis = parser.intValue();
                } else if ("total_auto_throttle_in_bytes".equals(fieldName)) {
                    totalBytesPerSecAutoThrottle = parser.intValue();
                }
            }
            parser.nextToken();
        }
        try (ByteArrayStreamOutput out = new ByteArrayStreamOutput();){
            MergeStats mergeStats;
            out.writeVLong(total);
            out.writeVLong(totalTimeInMillis);
            out.writeVLong(totalNumDocs);
            out.writeVLong(totalSizeInBytes);
            out.writeVLong(current);
            out.writeVLong(currentNumDocs);
            out.writeVLong(currentSizeInBytes);
            out.writeVLong(totalStoppedTimeInMillis);
            out.writeVLong(totalThrottledTimeInMillis);
            out.writeVLong(totalBytesPerSecAutoThrottle);
            try (InputStreamStreamInput in = new InputStreamStreamInput((InputStream)new ByteArrayInputStream(out.toByteArray()));){
                mergeStats = new MergeStats((StreamInput)in);
            }
            return mergeStats;
        }
    }

    protected SearchStats parseSearchStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long queryCount = 0L;
        long queryTimeInMillis = 0L;
        long queryCurrent = 0L;
        long concurrentQueryCount = 0L;
        long concurrentQueryTimeInMillis = 0L;
        long concurrentQueryCurrent = 0L;
        double concurrentAvgAliceCount = 0.0;
        long fetchCount = 0L;
        long fetchTimeInMillis = 0L;
        long fetchCurrent = 0L;
        long scrollCount = 0L;
        long scrollTimeInMillis = 0L;
        long scrollCurrent = 0L;
        long pitCount = 0L;
        long pitTimeInMillis = 0L;
        long pitCurrent = 0L;
        long suggestCount = 0L;
        long suggestTimeInMillis = 0L;
        long suggestCurrent = 0L;
        long openContexts = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("query_total".equals(fieldName)) {
                    queryCount = parser.longValue();
                } else if ("query_time_in_millis".equals(fieldName)) {
                    queryTimeInMillis = parser.longValue();
                } else if ("query_current".equals(fieldName)) {
                    queryCurrent = parser.longValue();
                } else if ("concurrent_query_total".equals(fieldName)) {
                    concurrentQueryCount = parser.longValue();
                } else if ("concurrent_query_time_in_millis".equals(fieldName)) {
                    concurrentQueryTimeInMillis = parser.longValue();
                } else if ("concurrent_query_current".equals(fieldName)) {
                    concurrentQueryCurrent = parser.longValue();
                } else if ("concurrent_avg_slice_count".equals(fieldName)) {
                    concurrentAvgAliceCount = parser.doubleValue();
                } else if ("fetch_total".equals(fieldName)) {
                    fetchCount = parser.longValue();
                } else if ("fetch_time_in_millis".equals(fieldName)) {
                    fetchTimeInMillis = parser.longValue();
                } else if ("fetch_current".equals(fieldName)) {
                    fetchCurrent = parser.longValue();
                } else if ("scroll_total".equals(fieldName)) {
                    scrollCount = parser.longValue();
                } else if ("scroll_time_in_millis".equals(fieldName)) {
                    scrollTimeInMillis = parser.longValue();
                } else if ("scroll_current".equals(fieldName)) {
                    scrollCurrent = parser.longValue();
                } else if ("point_in_time_total".equals(fieldName)) {
                    pitCount = parser.longValue();
                } else if ("point_in_time_time_in_millis".equals(fieldName)) {
                    pitTimeInMillis = parser.longValue();
                } else if ("point_in_time_current".equals(fieldName)) {
                    pitCurrent = parser.longValue();
                } else if ("suggest_total".equals(fieldName)) {
                    suggestCount = parser.longValue();
                } else if ("suggest_time_in_millis".equals(fieldName)) {
                    suggestTimeInMillis = parser.longValue();
                } else if ("suggest_current".equals(fieldName)) {
                    suggestCurrent = parser.longValue();
                } else if ("open_contexts".equals(fieldName)) {
                    openContexts = parser.longValue();
                }
            }
            parser.nextToken();
        }
        long queryConcurrency = 0L;
        if (concurrentQueryCount != 0L) {
            queryConcurrency = (long)((double)concurrentQueryCount * concurrentAvgAliceCount);
        }
        return new SearchStats(new SearchStats.Stats(queryCount, queryTimeInMillis, queryCurrent, concurrentQueryCount, concurrentQueryTimeInMillis, concurrentQueryCurrent, queryConcurrency, fetchCount, fetchTimeInMillis, fetchCurrent, scrollCount, scrollTimeInMillis, scrollCurrent, pitCount, pitTimeInMillis, pitCurrent, suggestCount, suggestTimeInMillis, suggestCurrent), openContexts, null);
    }

    protected GetStats parseGetStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long existsCount = 0L;
        long existsTimeInMillis = 0L;
        long missingCount = 0L;
        long missingTimeInMillis = 0L;
        long current = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("exists_total".equals(fieldName)) {
                    existsCount = parser.longValue();
                } else if ("exists_time_in_millis".equals(fieldName)) {
                    existsTimeInMillis = parser.longValue();
                } else if ("missing_total".equals(fieldName)) {
                    missingCount = parser.longValue();
                } else if ("missing_time_in_millis".equals(fieldName)) {
                    missingTimeInMillis = parser.longValue();
                } else if ("current".equals(fieldName)) {
                    current = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new GetStats(existsCount, existsTimeInMillis, missingCount, missingTimeInMillis, current);
    }

    protected IndexingStats parseIndexingStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long indexCount = 0L;
        long indexTimeInMillis = 0L;
        long indexCurrent = 0L;
        long indexFailedCount = 0L;
        long deleteCount = 0L;
        long deleteTimeInMillis = 0L;
        long deleteCurrent = 0L;
        long noopUpdateCount = 0L;
        boolean isThrottled = false;
        long throttleTimeInMillis = 0L;
        IndexingStats.Stats.DocStatusStats docStatusStats = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("is_throttled".equals(fieldName)) {
                    isThrottled = parser.booleanValue();
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("index_total".equals(fieldName)) {
                    indexCount = parser.longValue();
                } else if ("index_time_in_millis".equals(fieldName)) {
                    indexTimeInMillis = parser.longValue();
                } else if ("index_current".equals(fieldName)) {
                    indexCurrent = parser.longValue();
                } else if ("index_failed".equals(fieldName)) {
                    indexFailedCount = parser.longValue();
                } else if ("delete_total".equals(fieldName)) {
                    deleteCount = parser.longValue();
                } else if ("delete_time_in_millis".equals(fieldName)) {
                    deleteTimeInMillis = parser.longValue();
                } else if ("delete_current".equals(fieldName)) {
                    deleteCurrent = parser.longValue();
                } else if ("noop_update_total".equals(fieldName)) {
                    noopUpdateCount = parser.longValue();
                } else if ("throttle_time_in_millis".equals(fieldName)) {
                    throttleTimeInMillis = parser.longValue();
                }
            } else if ("doc_status".equals(fieldName)) {
                this.consumeObject(parser);
            }
            parser.nextToken();
        }
        return new IndexingStats(new IndexingStats.Stats(indexCount, indexTimeInMillis, indexCurrent, indexFailedCount, deleteCount, deleteTimeInMillis, deleteCurrent, noopUpdateCount, isThrottled, throttleTimeInMillis, docStatusStats));
    }

    protected StoreStats parseStoreStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long sizeInBytes = 0L;
        long reservedSize = -1L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("size_in_bytes".equals(fieldName)) {
                    sizeInBytes = parser.longValue();
                } else if ("reserved_in_bytes".equals(fieldName)) {
                    reservedSize = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new StoreStats(sizeInBytes, reservedSize);
    }

    protected DocsStats parseDocsStats(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        long count = 0L;
        long deleted = 0L;
        long totalSizeInBytes = 0L;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("count".equals(fieldName)) {
                    count = parser.longValue();
                } else if ("deleted".equals(fieldName)) {
                    deleted = parser.longValue();
                } else if ("total_size_in_bytes".equals(fieldName)) {
                    totalSizeInBytes = parser.longValue();
                }
            }
            parser.nextToken();
        }
        return new DocsStats(count, deleted, totalSizeInBytes);
    }

    protected int[] parseNodeResults(XContentParser parser) throws IOException {
        XContentParser.Token token;
        int[] results = new int[3];
        String fieldName = null;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("total".equals(fieldName)) {
                    results[0] = parser.intValue();
                } else if ("successful".equals(fieldName)) {
                    results[1] = parser.intValue();
                } else if ("failed".equals(fieldName)) {
                    results[2] = parser.intValue();
                }
            }
            parser.nextToken();
        }
        return results;
    }

    protected void consumeObject(XContentParser parser) throws IOException {
        XContentParser.Token token;
        while ((token = parser.currentToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
                this.consumeObject(parser);
            }
            parser.nextToken();
        }
    }

    protected String getMetric(NodesStatsRequest request) {
        Set metrics = request.requestedMetrics();
        if (request.indices().anySet() && CommonStatsFlags.ALL.getFlags().length != request.indices().getFlags().length) {
            return metrics.stream().collect(Collectors.joining(",")) + "/" + Arrays.stream(request.indices().getFlags()).map(CommonStatsFlags.Flag::getRestName).collect(Collectors.joining(","));
        }
        return metrics.stream().collect(Collectors.joining(","));
    }

    protected CurlRequest getCurlRequest(NodesStatsRequest request) {
        StringBuilder buf = new StringBuilder();
        buf.append("/_nodes");
        if (request.nodesIds() != null && request.nodesIds().length > 0) {
            buf.append('/').append(String.join((CharSequence)",", request.nodesIds()));
        }
        buf.append("/stats");
        String metric = this.getMetric(request);
        if (metric.length() > 0) {
            buf.append('/').append(metric);
        }
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, buf.toString(), new String[0]);
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        return curlRequest;
    }
}

