/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.io.stream.ByteArrayStreamOutput;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksAction;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import org.opensearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.opensearch.cluster.service.PendingClusterTask;
import org.opensearch.common.Priority;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.XContentParser;

public class HttpPendingClusterTasksAction
extends HttpAction {
    protected final PendingClusterTasksAction action;

    public HttpPendingClusterTasksAction(HttpClient client, PendingClusterTasksAction action) {
        super(client);
        this.action = action;
    }

    public void execute(PendingClusterTasksRequest request, ActionListener<PendingClusterTasksResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                PendingClusterTasksResponse pendingClusterTasksResponse = this.getPendingClusterTasksResponse(parser);
                listener.onResponse((Object)pendingClusterTasksResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(PendingClusterTasksRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_cluster/pending_tasks", new String[0]);
        curlRequest.param("local", Boolean.toString(request.local()));
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }

    protected PendingClusterTasksResponse getPendingClusterTasksResponse(XContentParser parser) {
        ConstructingObjectParser objectParser = new ConstructingObjectParser("pending_cluster_tasks", true, a -> {
            PendingClusterTasksResponse pendingClusterTasksResponse;
            ByteArrayStreamOutput out = new ByteArrayStreamOutput();
            try {
                List pendingClusterTasks = a[0] != null ? (List)a[0] : null;
                out.writeVInt(pendingClusterTasks.size());
                for (PendingClusterTask task : pendingClusterTasks) {
                    task.writeTo((StreamOutput)out);
                }
                pendingClusterTasksResponse = (PendingClusterTasksResponse)this.action.getResponseReader().read(out.toStreamInput());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            out.close();
            return pendingClusterTasksResponse;
        });
        objectParser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), this.getPendingClusterTaskParser(), TASKS_FIELD);
        return (PendingClusterTasksResponse)objectParser.apply(parser, null);
    }

    protected ConstructingObjectParser<PendingClusterTask, Void> getPendingClusterTaskParser() {
        ConstructingObjectParser objectParser = new ConstructingObjectParser("tasks", true, a -> new PendingClusterTask(((Long)a[0]).longValue(), Priority.valueOf((String)((String)a[1])), new Text((String)a[2]), ((Long)a[3]).longValue(), a[4] != null ? (Boolean)a[4] : false));
        objectParser.declareLong(ConstructingObjectParser.constructorArg(), INSERT_ORDER_FIELD);
        objectParser.declareString(ConstructingObjectParser.constructorArg(), PRIORITY_FIELD);
        objectParser.declareString(ConstructingObjectParser.constructorArg(), SOURCE_FIELD);
        objectParser.declareLong(ConstructingObjectParser.constructorArg(), TIME_IN_QUEUE_MILLIS_FIELD);
        objectParser.declareBoolean(ConstructingObjectParser.constructorArg(), EXECUTING_FIELD);
        return objectParser;
    }
}

