/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.rollover.Condition;
import org.opensearch.action.admin.indices.rollover.RolloverAction;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class HttpRolloverAction
extends HttpAction {
    protected final RolloverAction action;
    private static final ParseField CONDITIONS = new ParseField("conditions", new String[0]);

    public HttpRolloverAction(HttpClient client, RolloverAction action) {
        super(client);
        this.action = action;
    }

    public void execute(RolloverRequest request, ActionListener<RolloverResponse> listener) {
        String source = null;
        try (XContentBuilder builder = this.toXContent(request, JsonXContent.contentBuilder(), ToXContent.EMPTY_PARAMS);){
            builder.flush();
            source = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                RolloverResponse rolloverResponse = RolloverResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)rolloverResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(RolloverRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)POST, "/_rollover" + (String)(request.getNewIndexName() != null ? "/" + UrlUtils.encode(request.getNewIndexName()) : ""), request.getRolloverTarget());
        if (request.isDryRun()) {
            curlRequest.param("dry_run", "");
        }
        if (request.timeout() != null) {
            curlRequest.param("timeout", request.timeout().toString());
        }
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        if (!ActiveShardCount.DEFAULT.equals((Object)request.getCreateIndexRequest().waitForActiveShards())) {
            curlRequest.param("wait_for_active_shards", String.valueOf(this.getActiveShardsCountValue(request.getCreateIndexRequest().waitForActiveShards())));
        }
        return curlRequest;
    }

    protected XContentBuilder toXContent(RolloverRequest request, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        CreateIndexRequest createIndexRequest = request.getCreateIndexRequest();
        this.innerToXContent(createIndexRequest, builder, params);
        builder.startObject(CONDITIONS.getPreferredName());
        for (Condition condition : request.getConditions().values()) {
            condition.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    protected XContentBuilder innerToXContent(CreateIndexRequest createIndexRequest, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(CreateIndexRequest.SETTINGS.getPreferredName());
        createIndexRequest.settings().toXContent(builder, params);
        builder.endObject();
        try (StreamInput stream = new BytesArray(createIndexRequest.mappings()).streamInput();){
            builder.rawField(CreateIndexRequest.MAPPINGS.getPreferredName(), (InputStream)stream, (MediaType)XContentType.JSON);
        }
        builder.startObject(CreateIndexRequest.ALIASES.getPreferredName());
        for (Alias alias : createIndexRequest.aliases()) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

