/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.codelibs.fesen.client.util.UrlUtils;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusAction;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;

public class HttpSnapshotsStatusAction
extends HttpAction {
    protected final SnapshotsStatusAction action;

    public HttpSnapshotsStatusAction(HttpClient client, SnapshotsStatusAction action) {
        super(client);
        this.action = action;
    }

    public void execute(SnapshotsStatusRequest request, ActionListener<SnapshotsStatusResponse> listener) {
        this.getCurlRequest(request).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                SnapshotsStatusResponse cancelTasksResponse = SnapshotsStatusResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)cancelTasksResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(SnapshotsStatusRequest request) {
        StringBuilder pathBuf = new StringBuilder(100).append("/_snapshot");
        if (request.repository() != null) {
            pathBuf.append('/').append(UrlUtils.encode(request.repository()));
        }
        if (request.snapshots() != null && request.snapshots().length > 0) {
            pathBuf.append('/').append(UrlUtils.joinAndEncode(",", request.snapshots()));
        }
        pathBuf.append("/_status");
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, pathBuf.toString(), new String[0]);
        curlRequest.param("ignore_unavailable", String.valueOf(request.ignoreUnavailable()));
        if (request.masterNodeTimeout() != null) {
            curlRequest.param("master_timeout", request.masterNodeTimeout().toString());
        }
        return curlRequest;
    }
}

