/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.action;

import java.io.IOException;
import java.util.function.Function;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.action.HttpAction;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryAction;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class HttpValidateQueryAction
extends HttpAction {
    protected final ValidateQueryAction action;

    public HttpValidateQueryAction(HttpClient client, ValidateQueryAction action) {
        super(client);
        this.action = action;
    }

    public void execute(ValidateQueryRequest request, ActionListener<ValidateQueryResponse> listener) {
        String source = null;
        try (XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field(QUERY_FIELD.getPreferredName(), (ToXContent)request.query()).endObject();){
            builder.flush();
            source = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
        }
        catch (IOException e2) {
            throw new OpenSearchException("Failed to parse a request.", (Throwable)e2, new Object[0]);
        }
        this.getCurlRequest(request).body(source).execute(response -> {
            try (XContentParser parser = this.createParser((CurlResponse)response);){
                ValidateQueryResponse validateQueryResponse = ValidateQueryResponse.fromXContent((XContentParser)parser);
                listener.onResponse((Object)validateQueryResponse);
            }
            catch (Exception e) {
                listener.onFailure((Exception)this.toOpenSearchException((CurlResponse)response, e));
            }
        }, e -> this.unwrapOpenSearchException(listener, (Exception)e));
    }

    protected CurlRequest getCurlRequest(ValidateQueryRequest request) {
        CurlRequest curlRequest = this.client.getCurlRequest((Function<String, CurlRequest>)GET, "/_validate/query", request.indices());
        curlRequest.param("explain", Boolean.toString(request.explain()));
        curlRequest.param("rewrite", Boolean.toString(request.rewrite()));
        curlRequest.param("all_shards", Boolean.toString(request.allShards()));
        return curlRequest;
    }
}

