/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.curl;

import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.node.Node;
import org.codelibs.fesen.client.node.NodeIterator;
import org.codelibs.fesen.client.node.NodeManager;
import org.codelibs.fesen.client.node.NodeUnavailableException;
import org.opensearch.index.IndexNotFoundException;

public class FesenRequest
extends CurlRequest {
    private static final Logger logger = LogManager.getLogger(FesenRequest.class);
    protected final NodeManager nodeManager;
    protected final String path;
    protected final NodeIterator nodeIter;

    public FesenRequest(CurlRequest request, NodeManager nodeManager, String path) {
        super(request.method(), null);
        this.nodeManager = nodeManager;
        this.path = path;
        this.nodeIter = nodeManager.getNodeIterator();
    }

    public void execute(Consumer<CurlResponse> actionListener, Consumer<Exception> exceptionListener) {
        this.execute(actionListener, exceptionListener, null);
    }

    protected void execute(Consumer<CurlResponse> actionListener, Consumer<Exception> exceptionListener, Exception previous) {
        this.getNode().ifPresentOrElse(node -> {
            this.url = node.getUrl(this.path);
            super.execute(actionListener, e -> {
                if (!this.isTargetException((Exception)e)) {
                    exceptionListener.accept((Exception)e);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to access {}.", (Object)this.url, e);
                }
                node.setAvailable(false);
                this.execute(actionListener, exceptionListener, (Exception)e);
            });
        }, () -> {
            if (previous != null) {
                exceptionListener.accept(previous);
            } else {
                exceptionListener.accept((Exception)((Object)new NodeUnavailableException("All nodes are unavailable: " + this.nodeManager.toNodeString())));
            }
        });
    }

    public CurlResponse execute() {
        return this.execute(null);
    }

    protected CurlResponse execute(RuntimeException previous) {
        return this.getNode().map(node -> {
            this.url = node.getUrl(this.path);
            try {
                return super.execute();
            }
            catch (RuntimeException e) {
                if (!this.isTargetException(e)) {
                    throw e;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to access {}.", (Object)this.url, (Object)e);
                }
                node.setAvailable(false);
                return this.execute(e);
            }
        }).orElseThrow(() -> {
            if (previous != null) {
                return previous;
            }
            return new NodeUnavailableException("All nodes are unavailable: " + this.nodeManager.toNodeString());
        });
    }

    protected boolean isTargetException(Exception e) {
        int count = 0;
        for (Throwable t = e; t != null && count < 10; t = t.getCause(), ++count) {
            if (!(t instanceof IndexNotFoundException)) continue;
            return false;
        }
        return true;
    }

    protected Optional<Node> getNode() {
        if (this.nodeIter.hasNext()) {
            Node node = this.nodeIter.next();
            if (node.isAvailable()) {
                return Optional.of(node);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{} is not available.", (Object)node);
            }
            return this.getNode();
        }
        return Optional.empty();
    }
}

