/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.node;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.codelibs.fesen.client.node.Node;

public class NodeIterator
implements Iterator<Node> {
    protected static AtomicInteger positionCounter = new AtomicInteger();
    protected final Node[] nodes;
    protected int position;
    protected int count = 0;

    public NodeIterator(Node[] nodes) {
        this.nodes = nodes;
        this.position = positionCounter.incrementAndGet() % nodes.length;
        if (this.position < 0) {
            this.position *= -1;
        }
    }

    @Override
    public boolean hasNext() {
        return this.count < this.nodes.length;
    }

    @Override
    public Node next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No node in this iterator.");
        }
        Node node = this.nodes[this.position];
        ++this.position;
        if (this.position >= this.nodes.length) {
            this.position = 0;
        }
        ++this.count;
        return node;
    }
}

