/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.node;

import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.curl.Curl;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlRequest;
import org.codelibs.curl.CurlResponse;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fesen.client.node.Node;
import org.codelibs.fesen.client.node.NodeIterator;
import org.codelibs.fesen.client.util.MaxMapCountCheck;

public class NodeManager {
    private static final Logger logger = LogManager.getLogger(NodeManager.class);
    private static final AtomicInteger nextSerialNumber = new AtomicInteger();
    protected final Node[] nodes;
    protected Function<Node, CurlRequest> requestCreator;
    protected long heartbeatInterval = 10000L;
    protected Timer timer;
    protected AtomicBoolean isRunning = new AtomicBoolean(true);

    public NodeManager(String[] hosts, Function<Node, CurlRequest> requestCreator) {
        this(hosts);
        this.requestCreator = requestCreator;
        if (requestCreator != null) {
            this.timer = new Timer("FesenNodeManager-" + nextSerialNumber.incrementAndGet(), true);
            this.scheduleNodeChecker();
        }
    }

    public NodeManager(String[] hosts, HttpClient client) {
        this(hosts, (Node node) -> client.getPlainCurlRequest(s -> Curl.get((String)node.getUrl((String)s)), HttpClient.ContentType.JSON, "/", new String[0]));
    }

    NodeManager(String[] hosts) {
        this.nodes = new Node[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            this.nodes[i] = new Node(hosts[i]);
        }
    }

    protected void scheduleNodeChecker() {
        if (this.isRunning.get()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} scheduling a node checker.", (Object)this.toNodeString());
            }
            this.timer.schedule((TimerTask)new NodeChecker(), this.heartbeatInterval);
        }
    }

    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("{} closing node manager.", (Object)this.toNodeString());
        }
        this.isRunning.set(false);
        this.timer.cancel();
    }

    public NodeIterator getNodeIterator() {
        if (!this.hasAliveNode()) {
            if (logger.isDebugEnabled()) {
                logger.debug("No available ndoes. Setting \"available\" to true.");
            }
            for (Node node : this.nodes) {
                node.setAvailable(true);
            }
        }
        return new NodeIterator(this.nodes);
    }

    public String toNodeString() {
        return Arrays.stream(this.nodes).map(Node::toString).collect(Collectors.joining(","));
    }

    public void setHeartbeatInterval(long interval) {
        this.heartbeatInterval = interval;
    }

    protected boolean hasAliveNode() {
        for (Node node : this.nodes) {
            if (!node.isAvailable()) continue;
            return true;
        }
        return false;
    }

    protected Throwable getCause(Throwable t) {
        if (!(t instanceof CurlException)) {
            return t;
        }
        Throwable current = t;
        for (int depth = 0; depth < 10; ++depth) {
            Throwable cause = current.getCause();
            if (!(cause instanceof CurlException)) {
                return cause != null ? cause : current;
            }
            CurlException curlException = (CurlException)cause;
            current = curlException;
        }
        return current;
    }

    class NodeChecker
    extends TimerTask {
        NodeChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Node node : NodeManager.this.nodes) {
                    if (!node.isAvailable()) {
                        try (CurlResponse response = NodeManager.this.requestCreator.apply(node).execute();){
                            if (response.getHttpStatusCode() == 200) {
                                node.setAvailable(true);
                                if (logger.isInfoEnabled()) {
                                    logger.info("{} node status is back to green.", (Object)node);
                                }
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("{} node is still unavailable.", (Object)node);
                        }
                        catch (Exception e) {
                            Throwable cause = NodeManager.this.getCause(e);
                            if (this.isNetworkException(cause)) {
                                if (logger.isDebugEnabled()) {
                                    logger.warn("{} node is not available. {}", (Object)node, (Object)this.getValidationMessage(node), (Object)e);
                                    continue;
                                }
                                logger.warn("{} node is not available. {}({}: {})", (Object)node, (Object)this.getValidationMessage(node), (Object)cause.getClass().getSimpleName(), (Object)cause.getMessage());
                                continue;
                            }
                            logger.warn("{} Failed to access status.", (Object)node, (Object)e);
                        }
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("{} node status is green.", (Object)node);
                }
            }
            finally {
                NodeManager.this.scheduleNodeChecker();
            }
        }

        private boolean isNetworkException(Throwable cause) {
            return cause instanceof UnknownHostException || cause instanceof ConnectException || cause instanceof NoRouteToHostException;
        }

        private String getValidationMessage(Node node) {
            if (MaxMapCountCheck.validate()) {
                return "";
            }
            return String.format(Locale.ROOT, "max virtual memory areas vm.max_map_count for [%s] might be too low, increase to at least [%d]. ", node.host, 262144L);
        }
    }
}

