/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.io.PathUtils;

public class MaxMapCountCheck {
    public static final long LIMIT = 262144L;
    private static final Logger logger = LogManager.getLogger(MaxMapCountCheck.class);

    public static boolean validate() {
        long maxMapCount = MaxMapCountCheck.getMaxMapCount();
        return maxMapCount == -1L || maxMapCount >= 262144L;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static long getMaxMapCount() {
        block11: {
            Path path = PathUtils.get((String)"/proc/sys/vm/max_map_count", (String[])new String[0]);
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                String rawProcSysVmMaxMapCount = bufferedReader.readLine();
                if (rawProcSysVmMaxMapCount == null) break block11;
                try {
                    long l = Long.parseLong(rawProcSysVmMaxMapCount);
                    return l;
                }
                catch (NumberFormatException e) {
                    logger.debug(() -> new ParameterizedMessage("unable to parse vm.max_map_count [{}]", (Object)rawProcSysVmMaxMapCount), (Throwable)e);
                }
            }
            catch (IOException e) {
                logger.debug(() -> new ParameterizedMessage("I/O exception while trying to read [{}]", (Object)path), (Throwable)e);
            }
        }
        return -1L;
    }
}

