/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fesen.client.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UrlUtils {
    private static final Logger logger = LogManager.getLogger(UrlUtils.class);

    private UrlUtils() {
    }

    public static String joinAndEncode(CharSequence delimiter, CharSequence ... elements) {
        if (elements == null) {
            return null;
        }
        return Arrays.stream(elements).map(UrlUtils::encode).collect(Collectors.joining(delimiter));
    }

    public static String encode(CharSequence element) {
        if (element == null) {
            return null;
        }
        try {
            return URLEncoder.encode(element.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalid encoding.", (Throwable)e);
            }
            return element.toString();
        }
    }
}

