/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.EsAccessException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.exists.ExistsRequest;
import org.elasticsearch.action.exists.ExistsRequestBuilder;
import org.elasticsearch.action.exists.ExistsResponse;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainRequestBuilder;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.fieldstats.FieldStatsRequest;
import org.elasticsearch.action.fieldstats.FieldStatsRequestBuilder;
import org.elasticsearch.action.fieldstats.FieldStatsResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptRequestBuilder;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptResponse;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptRequestBuilder;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptResponse;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptRequestBuilder;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptResponse;
import org.elasticsearch.action.percolate.MultiPercolateRequest;
import org.elasticsearch.action.percolate.MultiPercolateRequestBuilder;
import org.elasticsearch.action.percolate.MultiPercolateResponse;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateRequestBuilder;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollRequestBuilder;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.suggest.SuggestRequest;
import org.elasticsearch.action.suggest.SuggestRequestBuilder;
import org.elasticsearch.action.suggest.SuggestResponse;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequestBuilder;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequestBuilder;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.support.Headers;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.threadpool.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsClient
implements Client {
    public static final String TRANSPORT_ADDRESSES = "crawler.es.transport_addresses";
    public static final String CLUSTER_NAME = "crawler.es.cluster_name";
    public static final String TARGET_INDICES = "crawler.es.target_indices";
    private static final Logger logger = LoggerFactory.getLogger(EsClient.class);
    protected TransportClient client;
    protected String clusterName;
    protected String[] addresses;
    protected List<OnConnectListener> onConnectListenerList = new ArrayList<OnConnectListener>();
    private volatile boolean connected;
    protected Scroll scrollForDelete = new Scroll(TimeValue.timeValueMinutes((long)1L));
    protected int sizeForDelete = 10;
    protected long retryInterval = 60000L;
    protected int maxRetryCount = 10;
    protected long connTimeout = 180000L;
    protected String searchPreference;
    protected String[] targetIndices;

    public EsClient() {
        this.clusterName = System.getProperty(CLUSTER_NAME, "elasticsearch");
        this.addresses = (String[])Arrays.stream(System.getProperty(TRANSPORT_ADDRESSES, "localhost:9300").split(",")).map(v -> v.trim()).toArray(String[]::new);
        String targets = System.getProperty(TARGET_INDICES);
        if (StringUtil.isNotBlank((String)targets)) {
            this.targetIndices = (String[])Arrays.stream(targets.split(",")).map(v -> v.trim()).toArray(String[]::new);
        }
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public void addOnConnectListener(OnConnectListener listener) {
        this.onConnectListenerList.add(listener);
    }

    public boolean connected() {
        return this.connected;
    }

    public void connect() {
        this.destroy();
        Settings settings = Settings.settingsBuilder().put("cluster.name", StringUtil.isBlank((String)this.clusterName) ? "elasticsearch" : this.clusterName).build();
        this.client = TransportClient.builder().settings(settings).build();
        Arrays.stream(this.addresses).forEach(address -> {
            String hostname;
            String[] values = address.split(":");
            int port = 9300;
            if (values.length == 1) {
                hostname = values[0];
            } else if (values.length == 2) {
                hostname = values[0];
                port = Integer.parseInt(values[1]);
            } else {
                throw new CrawlerSystemException("Invalid address: " + address);
            }
            try {
                this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(hostname), port));
            }
            catch (Exception e) {
                throw new CrawlerSystemException("Unknown host: " + address);
            }
            logger.info("Connected to " + hostname + ":" + port);
        });
        ClusterHealthResponse healthResponse = (ClusterHealthResponse)this.get((EsClient c) -> c.admin().cluster().prepareHealth(this.targetIndices).setWaitForYellowStatus().execute());
        if (!healthResponse.isTimedOut()) {
            this.onConnectListenerList.forEach(l -> {
                try {
                    l.onConnect();
                }
                catch (Exception e) {
                    logger.warn("Failed to invoke " + l, (Throwable)e);
                }
            });
            this.connected = true;
        } else {
            logger.warn("Could not connect to " + this.clusterName + ":" + String.join((CharSequence)",", this.addresses));
        }
    }

    public <T> T get(Function<EsClient, ListenableActionFuture<T>> func) {
        int retryCount = 0;
        while (true) {
            try {
                return (T)func.apply(this).actionGet(this.connTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (e instanceof IndexNotFoundException) {
                    logger.debug("IndexNotFoundException.");
                    throw e;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to actionGet. count:" + retryCount, (Throwable)e);
                }
                if (retryCount > this.maxRetryCount) {
                    logger.info("Failed to actionGet. All retry failure.", (Throwable)e);
                    throw e;
                }
                ++retryCount;
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException ie) {
                    throw e;
                }
            }
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (ElasticsearchException e) {
                logger.warn("Failed to close client.", (Throwable)e);
            }
            logger.info("Disconnected to " + this.clusterName + ":" + String.join((CharSequence)",", this.addresses));
        }
        this.connected = false;
    }

    public ThreadPool threadPool() {
        return this.client.threadPool();
    }

    public AdminClient admin() {
        return this.client.admin();
    }

    public ActionFuture<IndexResponse> index(IndexRequest request) {
        return this.client.index(request);
    }

    public void index(IndexRequest request, ActionListener<IndexResponse> listener) {
        this.client.index(request, listener);
    }

    public IndexRequestBuilder prepareIndex() {
        return this.client.prepareIndex();
    }

    public ActionFuture<UpdateResponse> update(UpdateRequest request) {
        return this.client.update(request);
    }

    public void update(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.client.update(request, listener);
    }

    public UpdateRequestBuilder prepareUpdate() {
        return this.client.prepareUpdate();
    }

    public UpdateRequestBuilder prepareUpdate(String index, String type, String id) {
        return this.client.prepareUpdate(index, type, id);
    }

    public IndexRequestBuilder prepareIndex(String index, String type) {
        return this.client.prepareIndex(index, type);
    }

    public IndexRequestBuilder prepareIndex(String index, String type, String id) {
        return this.client.prepareIndex(index, type, id);
    }

    public ActionFuture<DeleteResponse> delete(DeleteRequest request) {
        return this.client.delete(request);
    }

    public void delete(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        this.client.delete(request, listener);
    }

    public DeleteRequestBuilder prepareDelete() {
        return this.client.prepareDelete();
    }

    public DeleteRequestBuilder prepareDelete(String index, String type, String id) {
        return this.client.prepareDelete(index, type, id);
    }

    public ActionFuture<BulkResponse> bulk(BulkRequest request) {
        return this.client.bulk(request);
    }

    public void bulk(BulkRequest request, ActionListener<BulkResponse> listener) {
        this.client.bulk(request, listener);
    }

    public BulkRequestBuilder prepareBulk() {
        return this.client.prepareBulk();
    }

    public ActionFuture<GetResponse> get(GetRequest request) {
        return this.client.get(request);
    }

    public void get(GetRequest request, ActionListener<GetResponse> listener) {
        this.client.get(request, listener);
    }

    public GetRequestBuilder prepareGet() {
        return this.client.prepareGet();
    }

    public GetRequestBuilder prepareGet(String index, String type, String id) {
        return this.client.prepareGet(index, type, id);
    }

    public PutIndexedScriptRequestBuilder preparePutIndexedScript() {
        return this.client.preparePutIndexedScript();
    }

    public PutIndexedScriptRequestBuilder preparePutIndexedScript(String scriptLang, String id, String source) {
        return this.client.preparePutIndexedScript(scriptLang, id, source);
    }

    public void deleteIndexedScript(DeleteIndexedScriptRequest request, ActionListener<DeleteIndexedScriptResponse> listener) {
        this.client.deleteIndexedScript(request, listener);
    }

    public ActionFuture<DeleteIndexedScriptResponse> deleteIndexedScript(DeleteIndexedScriptRequest request) {
        return this.client.deleteIndexedScript(request);
    }

    public DeleteIndexedScriptRequestBuilder prepareDeleteIndexedScript() {
        return this.client.prepareDeleteIndexedScript();
    }

    public DeleteIndexedScriptRequestBuilder prepareDeleteIndexedScript(String scriptLang, String id) {
        return this.client.prepareDeleteIndexedScript(scriptLang, id);
    }

    public void putIndexedScript(PutIndexedScriptRequest request, ActionListener<PutIndexedScriptResponse> listener) {
        this.client.putIndexedScript(request, listener);
    }

    public ActionFuture<PutIndexedScriptResponse> putIndexedScript(PutIndexedScriptRequest request) {
        return this.client.putIndexedScript(request);
    }

    public GetIndexedScriptRequestBuilder prepareGetIndexedScript() {
        return this.client.prepareGetIndexedScript();
    }

    public GetIndexedScriptRequestBuilder prepareGetIndexedScript(String scriptLang, String id) {
        return this.client.prepareGetIndexedScript(scriptLang, id);
    }

    public void getIndexedScript(GetIndexedScriptRequest request, ActionListener<GetIndexedScriptResponse> listener) {
        this.client.getIndexedScript(request, listener);
    }

    public ActionFuture<GetIndexedScriptResponse> getIndexedScript(GetIndexedScriptRequest request) {
        return this.client.getIndexedScript(request);
    }

    public ActionFuture<MultiGetResponse> multiGet(MultiGetRequest request) {
        return this.client.multiGet(request);
    }

    public void multiGet(MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        this.client.multiGet(request, listener);
    }

    public MultiGetRequestBuilder prepareMultiGet() {
        return this.client.prepareMultiGet();
    }

    public ActionFuture<CountResponse> count(CountRequest request) {
        return this.client.count(request);
    }

    public void count(CountRequest request, ActionListener<CountResponse> listener) {
        this.client.count(request, listener);
    }

    public CountRequestBuilder prepareCount(String ... indices) {
        return this.client.prepareCount(indices);
    }

    public ActionFuture<ExistsResponse> exists(ExistsRequest request) {
        return this.client.exists(request);
    }

    public void exists(ExistsRequest request, ActionListener<ExistsResponse> listener) {
        this.client.exists(request, listener);
    }

    public ExistsRequestBuilder prepareExists(String ... indices) {
        return this.client.prepareExists(indices);
    }

    public ActionFuture<SuggestResponse> suggest(SuggestRequest request) {
        return this.client.suggest(request);
    }

    public void suggest(SuggestRequest request, ActionListener<SuggestResponse> listener) {
        this.client.suggest(request, listener);
    }

    public SuggestRequestBuilder prepareSuggest(String ... indices) {
        return this.client.prepareSuggest(indices);
    }

    public ActionFuture<SearchResponse> search(SearchRequest request) {
        return this.client.search(request);
    }

    public void search(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.client.search(request, listener);
    }

    public SearchRequestBuilder prepareSearch(String ... indices) {
        SearchRequestBuilder builder = this.client.prepareSearch(indices);
        if (this.searchPreference != null) {
            builder.setPreference(this.searchPreference);
        }
        return builder;
    }

    public ActionFuture<SearchResponse> searchScroll(SearchScrollRequest request) {
        return this.client.searchScroll(request);
    }

    public void searchScroll(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        this.client.searchScroll(request, listener);
    }

    public SearchScrollRequestBuilder prepareSearchScroll(String scrollId) {
        return this.client.prepareSearchScroll(scrollId);
    }

    public ActionFuture<MultiSearchResponse> multiSearch(MultiSearchRequest request) {
        return this.client.multiSearch(request);
    }

    public void multiSearch(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        this.client.multiSearch(request, listener);
    }

    public MultiSearchRequestBuilder prepareMultiSearch() {
        return this.client.prepareMultiSearch();
    }

    public ActionFuture<PercolateResponse> percolate(PercolateRequest request) {
        return this.client.percolate(request);
    }

    public void percolate(PercolateRequest request, ActionListener<PercolateResponse> listener) {
        this.client.percolate(request, listener);
    }

    public PercolateRequestBuilder preparePercolate() {
        return this.client.preparePercolate();
    }

    public ActionFuture<MultiPercolateResponse> multiPercolate(MultiPercolateRequest request) {
        return this.client.multiPercolate(request);
    }

    public void multiPercolate(MultiPercolateRequest request, ActionListener<MultiPercolateResponse> listener) {
        this.client.multiPercolate(request, listener);
    }

    public MultiPercolateRequestBuilder prepareMultiPercolate() {
        return this.client.prepareMultiPercolate();
    }

    public ExplainRequestBuilder prepareExplain(String index, String type, String id) {
        return this.client.prepareExplain(index, type, id);
    }

    public ActionFuture<ExplainResponse> explain(ExplainRequest request) {
        return this.client.explain(request);
    }

    public void explain(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        this.client.explain(request, listener);
    }

    public ClearScrollRequestBuilder prepareClearScroll() {
        return this.client.prepareClearScroll();
    }

    public ActionFuture<ClearScrollResponse> clearScroll(ClearScrollRequest request) {
        return this.client.clearScroll(request);
    }

    public void clearScroll(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        this.client.clearScroll(request, listener);
    }

    public Settings settings() {
        return this.client.settings();
    }

    public FieldStatsRequestBuilder prepareFieldStats() {
        return this.client.prepareFieldStats();
    }

    public ActionFuture<FieldStatsResponse> fieldStats(FieldStatsRequest request) {
        return this.client.fieldStats(request);
    }

    public void fieldStats(FieldStatsRequest request, ActionListener<FieldStatsResponse> listener) {
        this.client.fieldStats(request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder> action, Request request) {
        return this.client.execute(action, request);
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void execute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.client.execute(action, request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> RequestBuilder prepareExecute(Action<Request, Response, RequestBuilder> action) {
        return (RequestBuilder)this.client.prepareExecute(action);
    }

    public void close() {
        this.client.close();
    }

    public ActionFuture<TermVectorsResponse> termVectors(TermVectorsRequest request) {
        return this.client.termVectors(request);
    }

    public void termVectors(TermVectorsRequest request, ActionListener<TermVectorsResponse> listener) {
        this.client.termVectors(request, listener);
    }

    public TermVectorsRequestBuilder prepareTermVectors() {
        return this.client.prepareTermVectors();
    }

    public TermVectorsRequestBuilder prepareTermVectors(String index, String type, String id) {
        return this.client.prepareTermVectors(index, type, id);
    }

    @Deprecated
    public ActionFuture<TermVectorsResponse> termVector(TermVectorsRequest request) {
        return this.client.termVector(request);
    }

    @Deprecated
    public void termVector(TermVectorsRequest request, ActionListener<TermVectorsResponse> listener) {
        this.client.termVector(request, listener);
    }

    @Deprecated
    public TermVectorsRequestBuilder prepareTermVector() {
        return this.client.prepareTermVector();
    }

    public TermVectorsRequestBuilder prepareTermVector(String index, String type, String id) {
        return this.client.prepareTermVectors(index, type, id);
    }

    public ActionFuture<MultiTermVectorsResponse> multiTermVectors(MultiTermVectorsRequest request) {
        return this.client.multiTermVectors(request);
    }

    public void multiTermVectors(MultiTermVectorsRequest request, ActionListener<MultiTermVectorsResponse> listener) {
        this.client.multiTermVectors(request, listener);
    }

    public MultiTermVectorsRequestBuilder prepareMultiTermVectors() {
        return this.client.prepareMultiTermVectors();
    }

    public Headers headers() {
        return this.client.headers();
    }

    public int deleteByQuery(String index, String type, QueryBuilder queryBuilder) {
        int count;
        block3: {
            SearchHit[] hits;
            BulkResponse bulkResponse;
            count = 0;
            String scrollId = null;
            do {
                SearchResponse scrollResponse;
                if (scrollId == null) {
                    scrollResponse = (SearchResponse)this.get((EsClient c) -> c.prepareSearch(index).setTypes(new String[]{type}).setScroll(this.scrollForDelete).setSize(this.sizeForDelete).setQuery(queryBuilder).execute());
                } else {
                    String sid = scrollId;
                    scrollResponse = (SearchResponse)this.get((EsClient c) -> c.prepareSearchScroll(sid).setScroll(this.scrollForDelete).execute());
                }
                hits = scrollResponse.getHits().getHits();
                if (hits.length == 0) break block3;
                scrollId = scrollResponse.getScrollId();
                count += hits.length;
            } while (!(bulkResponse = (BulkResponse)this.get((EsClient c) -> {
                BulkRequestBuilder bulkRequest = this.client.prepareBulk();
                for (SearchHit hit : hits) {
                    bulkRequest.add(this.client.prepareDelete(hit.getIndex(), hit.getType(), hit.getId()));
                }
                return bulkRequest.execute();
            })).hasFailures());
            throw new EsAccessException(bulkResponse.buildFailureMessage());
        }
        return count;
    }

    public void setScrollForDelete(Scroll scrollForDelete) {
        this.scrollForDelete = scrollForDelete;
    }

    public void setSizeForDelete(int sizeForDelete) {
        this.sizeForDelete = sizeForDelete;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public void setConnTimeout(long connTimeout) {
        this.connTimeout = connTimeout;
    }

    public void setSearchPreference(String searchPreference) {
        this.searchPreference = searchPreference;
    }

    public static interface OnConnectListener {
        public void onConnect();
    }
}

