/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.Converter;
import org.codelibs.core.beans.PropertyDesc;
import org.codelibs.core.beans.factory.BeanDescFactory;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.client.EsClient;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.EsAccessResult;
import org.codelibs.fess.crawler.entity.EsAccessResultData;
import org.codelibs.fess.crawler.exception.EsAccessException;
import org.codelibs.fess.crawler.util.EsResultList;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCrawlerService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCrawlerService.class);
    private static final String ID_SEPARATOR = ".";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected static final String ID = "id";
    protected static final String SESSION_ID = "sessionId";
    protected static final String URL = "url";
    protected static final String LAST_MODIFIED = "lastModified";
    protected static final String CREATE_TIME = "createTime";
    protected static final String[] timestampFields = new String[]{"lastModified", "createTime"};
    protected static final HashFunction murmur3Hash = Hashing.murmur3_128((int)0);
    protected String index;
    protected String type;
    protected int scrollTimeout = 60000;
    protected int scrollSize = 100;
    protected int bulkBufferSize = 10;
    @Resource
    protected volatile EsClient esClient;
    protected WriteConsistencyLevel writeConsistencyLevel = WriteConsistencyLevel.DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EsClient getClient() {
        if (!this.esClient.connected()) {
            EsClient esClient = this.esClient;
            synchronized (esClient) {
                if (!this.esClient.connected()) {
                    this.esClient.connect();
                }
            }
        }
        return this.esClient;
    }

    protected void createMapping(String mappingName) {
        GetMappingsResponse getMappingsResponse;
        ImmutableOpenMap indexMappings;
        boolean exists = false;
        try {
            this.esClient.get(c -> c.prepareExists(this.index).execute());
            exists = true;
        }
        catch (IndexNotFoundException indexNotFoundException) {
            // empty catch block
        }
        if (!exists) {
            try {
                CreateIndexResponse indexResponse = (CreateIndexResponse)this.esClient.get(c -> c.admin().indices().prepareCreate(this.index).execute());
                if (indexResponse.isAcknowledged()) {
                    logger.info("Created " + this.index + " index.");
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Failed to create " + this.index + " index.");
                }
            }
            catch (IndexAlreadyExistsException indexResponse) {
                // empty catch block
            }
        }
        if ((indexMappings = (ImmutableOpenMap)(getMappingsResponse = (GetMappingsResponse)this.esClient.get(c -> ((GetMappingsRequestBuilder)c.admin().indices().prepareGetMappings(new String[]{this.index}).setTypes(new String[]{this.type})).execute())).mappings().get((Object)this.index)) == null || !indexMappings.containsKey((Object)this.type)) {
            PutMappingResponse putMappingResponse = (PutMappingResponse)this.esClient.get(c -> c.admin().indices().preparePutMapping(new String[]{this.index}).setType(this.type).setSource(FileUtil.readText((String)("mapping/" + mappingName + ".json"))).execute());
            if (putMappingResponse.isAcknowledged()) {
                logger.info("Created " + this.index + "/" + this.type + " mapping.");
            } else {
                logger.warn("Failed to create " + this.index + "/" + this.type + " mapping.");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug(this.index + "/" + this.type + " mapping exists.");
        }
    }

    protected Date getDateFromSource(Map<String, Object> sourceMap, String name) {
        block5: {
            Object obj = sourceMap.get(name);
            if (obj instanceof Date) {
                return (Date)obj;
            }
            if (obj instanceof Number) {
                return new Date(((Number)obj).longValue());
            }
            if (obj instanceof String) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    return sdf.parse(obj.toString());
                }
                catch (ParseException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("Failed to parse " + obj, (Throwable)e);
                }
            }
        }
        return null;
    }

    protected XContentBuilder getXContentBuilder(Object target) {
        try {
            return XContentFactory.jsonBuilder().value(target);
        }
        catch (IOException e) {
            throw new EsAccessException("Failed to convert " + target + " to JSON.", e);
        }
    }

    protected RefreshResponse refresh() {
        try {
            return (RefreshResponse)this.getClient().get(c -> c.admin().indices().prepareRefresh(new String[]{this.index}).execute());
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to refresh.", e);
        }
    }

    protected IndexResponse insert(Object target, IndexRequest.OpType opType) {
        String id = this.getId(this.getSessionId(target), this.getUrl(target));
        XContentBuilder source = this.getXContentBuilder(target);
        try {
            IndexResponse response = (IndexResponse)this.getClient().get(c -> ((IndexRequestBuilder)c.prepareIndex(this.index, this.type, id).setSource(source).setOpType(opType).setConsistencyLevel(this.writeConsistencyLevel)).setRefresh(true).execute());
            this.setId(target, id);
            return response;
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to insert " + id, e);
        }
    }

    protected <T> void insertAll(List<T> list, IndexRequest.OpType opType) {
        this.insertAll(list, opType, false);
    }

    protected <T> void insertAll(List<T> list, IndexRequest.OpType opType, boolean ignoreAlreadyExists) {
        String failureMessage;
        BulkResponse response;
        ArrayList bufferedList = new ArrayList(this.bulkBufferSize);
        StringBuilder failureBuf = new StringBuilder(100);
        list.stream().forEach(target -> {
            bufferedList.add(target);
            if (bufferedList.size() >= this.bulkBufferSize) {
                String failureMessage;
                BulkResponse response = this.doInsertAll(bufferedList, opType);
                if (response.hasFailures() && (failureMessage = this.buildFailureMessage(response, ignoreAlreadyExists)).length() > 0) {
                    failureBuf.append(response.buildFailureMessage()).append('\n');
                }
                bufferedList.clear();
            }
        });
        if (!bufferedList.isEmpty() && (response = this.doInsertAll(bufferedList, opType)).hasFailures() && (failureMessage = this.buildFailureMessage(response, ignoreAlreadyExists)).length() > 0) {
            failureBuf.append(response.buildFailureMessage()).append('\n');
        }
        if (failureBuf.length() > 0) {
            throw new EsAccessException(failureBuf.toString());
        }
    }

    protected String buildFailureMessage(BulkResponse bulkResponse, boolean ignoreAlreadyExists) {
        StringBuilder sb = new StringBuilder(100);
        BulkItemResponse[] responses = bulkResponse.getItems();
        for (int i = 0; i < responses.length; ++i) {
            BulkItemResponse response = responses[i];
            if (!response.isFailed() || ignoreAlreadyExists && response.getFailure().getCause() instanceof DocumentAlreadyExistsException) continue;
            sb.append("\n[").append(i).append("]: index [").append(response.getIndex()).append("], type [").append(response.getType()).append("], id [").append(response.getId()).append("], message [").append(response.getFailureMessage()).append("]");
        }
        if (sb.length() > 0) {
            return "failure in bulk execution:" + sb.toString();
        }
        return "";
    }

    protected <T> BulkResponse doInsertAll(List<T> list, IndexRequest.OpType opType) {
        try {
            return (BulkResponse)this.getClient().get(c -> {
                BulkRequestBuilder bulkRequest = c.prepareBulk();
                for (Object target : list) {
                    String id = this.getId(this.getSessionId(target), this.getUrl(target));
                    XContentBuilder source = this.getXContentBuilder(target);
                    bulkRequest.add((IndexRequestBuilder)c.prepareIndex(this.index, this.type, id).setSource(source).setOpType(opType).setConsistencyLevel(this.writeConsistencyLevel));
                    this.setId(target, id);
                }
                return bulkRequest.setConsistencyLevel(this.writeConsistencyLevel).setRefresh(true).execute();
            });
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to insert " + list, e);
        }
    }

    protected boolean exists(String sessionId, String url) {
        String id = this.getId(sessionId, url);
        try {
            SearchResponse response = (SearchResponse)this.getClient().get(c -> c.prepareSearch(this.index).setQuery((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{this.type}).ids(new String[]{id})).setSize(0).setTerminateAfter(1).execute());
            return response.getHits().getTotalHits() > 0L;
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to check if " + sessionId + ":" + url + " exists.", e);
        }
    }

    public int getCount(Consumer<SearchRequestBuilder> callback) {
        return (int)((SearchResponse)this.getClient().get(c -> {
            SearchRequestBuilder builder = c.prepareSearch(this.index).setTypes(new String[]{this.type}).setSize(0);
            callback.accept(builder);
            return builder.execute();
        })).getHits().getTotalHits();
    }

    protected <T> T get(Class<T> clazz, String sessionId, String url) {
        String id = this.getId(sessionId, url);
        GetResponse response = (GetResponse)this.getClient().get(c -> c.prepareGet(this.index, this.type, id).execute());
        if (response.isExists()) {
            Map source = response.getSource();
            Object bean = BeanUtil.copyMapToNewBean((Map)source, clazz, option -> {
                option.converter((Converter)new EsTimestampConverter(), (CharSequence[])timestampFields).excludeWhitespace();
                option.exclude(new CharSequence[]{"accessResultData"});
            });
            Map data = (Map)source.get("accessResultData");
            if (data != null) {
                ((EsAccessResult)((Object)bean)).setAccessResultData((AccessResultData<String>)new EsAccessResultData(data));
            }
            this.setId(bean, id);
            return (T)bean;
        }
        return null;
    }

    protected <T> List<T> getList(Class<T> clazz, String sessionId, QueryBuilder queryBuilder, Integer from, Integer size, SortBuilder sortBuilder) {
        return this.getList(clazz, builder -> {
            if (StringUtil.isNotBlank((String)sessionId)) {
                if (queryBuilder instanceof BoolQueryBuilder) {
                    ((BoolQueryBuilder)queryBuilder).filter((QueryBuilder)QueryBuilders.termQuery((String)SESSION_ID, (String)sessionId));
                } else {
                    BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)SESSION_ID, (String)sessionId));
                    if (queryBuilder != null) {
                        boolQuery.must(queryBuilder);
                    }
                    builder.setQuery((QueryBuilder)boolQuery);
                }
            } else if (queryBuilder != null) {
                builder.setQuery(queryBuilder);
            } else {
                builder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
            }
            if (sortBuilder != null) {
                builder.addSort(sortBuilder);
            }
            if (from != null) {
                builder.setFrom(from.intValue());
            }
            if (size != null) {
                builder.setSize(size.intValue());
            }
        });
    }

    protected <T> List<T> getList(Class<T> clazz, Consumer<SearchRequestBuilder> callback) {
        SearchResponse response = (SearchResponse)this.getClient().get(c -> {
            SearchRequestBuilder builder = c.prepareSearch(this.index).setTypes(new String[]{this.type});
            callback.accept(builder);
            return builder.execute();
        });
        EsResultList<Object> targetList = new EsResultList<Object>();
        SearchHits hits = response.getHits();
        targetList.setTotalHits(hits.getTotalHits());
        targetList.setTookInMillis(response.getTookInMillis());
        if (hits.getTotalHits() != 0L) {
            try {
                for (SearchHit searchHit : hits.getHits()) {
                    Map source = searchHit.getSource();
                    Object target = BeanUtil.copyMapToNewBean((Map)source, clazz, option -> {
                        option.converter((Converter)new EsTimestampConverter(), (CharSequence[])timestampFields).excludeWhitespace();
                        option.exclude(new CharSequence[]{"accessResultData"});
                    });
                    Map data = (Map)source.get("accessResultData");
                    if (data != null) {
                        ((EsAccessResult)((Object)target)).setAccessResultData((AccessResultData<String>)new EsAccessResultData(data));
                    }
                    this.setId(target, searchHit.getId());
                    targetList.add(target);
                }
            }
            catch (Exception e) {
                throw new EsAccessException("response: " + response, e);
            }
        }
        return targetList;
    }

    protected boolean delete(String sessionId, String url) {
        String id = this.getId(sessionId, url);
        try {
            DeleteResponse response = (DeleteResponse)this.getClient().get(c -> ((DeleteRequestBuilder)c.prepareDelete(this.index, this.type, id).setConsistencyLevel(this.writeConsistencyLevel)).setRefresh(true).execute());
            return response.isFound();
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to delete " + sessionId + ":" + url, e);
        }
    }

    protected void deleteBySessionId(String sessionId) {
        this.delete(builder -> builder.setQuery((QueryBuilder)QueryBuilders.termQuery((String)SESSION_ID, (String)sessionId)));
    }

    public void deleteAll() {
        this.delete(builder -> builder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery()));
    }

    public void delete(Consumer<SearchRequestBuilder> callback) {
        block3: {
            SearchHits searchHits;
            BulkResponse bulkResponse;
            SearchResponse response = null;
            do {
                if (response == null) {
                    response = (SearchResponse)this.getClient().get(c -> {
                        SearchRequestBuilder builder = c.prepareSearch(this.index).setTypes(new String[]{this.type}).setScroll(new TimeValue((long)this.scrollTimeout)).setSize(this.scrollSize);
                        callback.accept(builder);
                        return builder.execute();
                    });
                } else {
                    String scrollId = response.getScrollId();
                    response = (SearchResponse)this.getClient().get(c -> c.prepareSearchScroll(scrollId).setScroll(new TimeValue((long)this.scrollTimeout)).execute());
                }
                searchHits = response.getHits();
                if (searchHits.hits().length == 0) break block3;
            } while (!(bulkResponse = (BulkResponse)this.getClient().get(c -> {
                BulkRequestBuilder bulkBuilder = c.prepareBulk();
                for (SearchHit searchHit : searchHits) {
                    bulkBuilder.add(c.prepareDelete(this.index, this.type, searchHit.getId()));
                }
                return bulkBuilder.execute();
            })).hasFailures());
            throw new EsAccessException(bulkResponse.buildFailureMessage());
        }
        this.refresh();
    }

    private String getId(String sessionId, String url) {
        return sessionId + ID_SEPARATOR + new String(Base64.getUrlEncoder().withoutPadding().encode(url.getBytes(UTF_8)), UTF_8);
    }

    private String getUrl(Object target) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        PropertyDesc sessionIdProp = beanDesc.getPropertyDesc(URL);
        Object sessionId = sessionIdProp.getValue(target);
        return sessionId == null ? null : sessionId.toString();
    }

    private String getSessionId(Object target) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        PropertyDesc sessionIdProp = beanDesc.getPropertyDesc(SESSION_ID);
        Object sessionId = sessionIdProp.getValue(target);
        return sessionId == null ? null : sessionId.toString();
    }

    protected void setId(Object target, String id) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        PropertyDesc idProp = beanDesc.getPropertyDesc(ID);
        idProp.setValue(target, (Object)id);
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getScrollTimeout() {
        return this.scrollTimeout;
    }

    public void setScrollTimeout(int scrollTimeout) {
        this.scrollTimeout = scrollTimeout;
    }

    public int getScrollSize() {
        return this.scrollSize;
    }

    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    public int getBulkBufferSize() {
        return this.bulkBufferSize;
    }

    public void setBulkBufferSize(int bulkBufferSize) {
        this.bulkBufferSize = bulkBufferSize;
    }

    public WriteConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(WriteConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    protected static class EsTimestampConverter
    implements Converter {
        protected EsTimestampConverter() {
        }

        public String getAsString(Object value) {
            if (value instanceof Date) {
                return XContentBuilder.defaultDatePrinter.print(((Date)value).getTime());
            }
            return null;
        }

        public Object getAsObject(String value) {
            if (StringUtil.isEmpty((String)value)) {
                return null;
            }
            return new Timestamp(XContentBuilder.defaultDatePrinter.parseMillis(value));
        }

        public boolean isTarget(Class clazz) {
            return clazz == Date.class;
        }
    }
}

