/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.codelibs.core.beans.Converter;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.fess.crawler.entity.AccessResult;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.EsAccessResult;
import org.codelibs.fess.crawler.entity.EsAccessResultData;
import org.codelibs.fess.crawler.exception.EsAccessException;
import org.codelibs.fess.crawler.service.DataService;
import org.codelibs.fess.crawler.service.impl.AbstractCrawlerService;
import org.codelibs.fess.crawler.util.AccessResultCallback;
import org.codelibs.fess.crawler.util.EsResultList;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;

public class EsDataService
extends AbstractCrawlerService
implements DataService<EsAccessResult> {
    @PostConstruct
    public void init() {
        this.esClient.addOnConnectListener(() -> this.createMapping("data"));
    }

    public void store(EsAccessResult accessResult) {
        super.insert((Object)accessResult, accessResult.getId() == null ? IndexRequest.OpType.CREATE : IndexRequest.OpType.INDEX);
    }

    public void update(EsAccessResult accessResult) {
        super.insert((Object)accessResult, IndexRequest.OpType.INDEX);
    }

    public void update(List<EsAccessResult> accessResultList) {
        this.insertAll(accessResultList, IndexRequest.OpType.INDEX);
    }

    public int getCount(String sessionId) {
        return this.getCount((SearchRequestBuilder builder) -> builder.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"sessionId", (String)sessionId)));
    }

    public void delete(String sessionId) {
        this.deleteBySessionId(sessionId);
    }

    public EsAccessResult getAccessResult(String sessionId, String url) {
        return this.get(EsAccessResult.class, sessionId, url);
    }

    public List<EsAccessResult> getAccessResultList(String url, boolean hasData) {
        return this.getList(EsAccessResult.class, builder -> builder.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"url", (String)url)));
    }

    public List<EsAccessResult> getAccessResultList(Consumer<SearchRequestBuilder> callback) {
        SearchResponse response = (SearchResponse)this.getClient().get(c -> {
            SearchRequestBuilder builder = c.prepareSearch(this.index).setTypes(new String[]{this.type});
            callback.accept(builder);
            builder.addFields(new String[]{"parentUrl", "method", "mimeType", "sessionId", "url", "executionTime", "createTime", "contentLength", "lastModified", "ruleId", "httpStatusCode", "status"});
            return builder.execute();
        });
        EsResultList<EsAccessResult> targetList = new EsResultList<EsAccessResult>();
        SearchHits hits = response.getHits();
        targetList.setTotalHits(hits.getTotalHits());
        targetList.setTookInMillis(response.getTookInMillis());
        if (hits.getTotalHits() != 0L) {
            try {
                for (SearchHit searchHit : hits.getHits()) {
                    EsAccessResult target = new EsAccessResult();
                    Map fields = searchHit.getFields();
                    target.setParentUrl(this.getFieldValue((SearchHitField)fields.get("parentUrl"), String.class));
                    target.setMethod(this.getFieldValue((SearchHitField)fields.get("method"), String.class));
                    target.setMimeType(this.getFieldValue((SearchHitField)fields.get("mimeType"), String.class));
                    target.setSessionId(this.getFieldValue((SearchHitField)fields.get("sessionId"), String.class));
                    target.setUrl(this.getFieldValue((SearchHitField)fields.get("url"), String.class));
                    target.setExecutionTime(this.getFieldValue((SearchHitField)fields.get("executionTime"), Integer.class));
                    target.setContentLength(this.getFieldValue((SearchHitField)fields.get("contentLength"), Long.class));
                    target.setRuleId(this.getFieldValue((SearchHitField)fields.get("ruleId"), String.class));
                    target.setHttpStatusCode(this.getFieldValue((SearchHitField)fields.get("httpStatusCode"), Integer.class));
                    target.setStatus(this.getFieldValue((SearchHitField)fields.get("status"), Integer.class));
                    target.setCreateTime(this.getFieldValue((SearchHitField)fields.get("createTime"), Long.class));
                    target.setLastModified(this.getFieldValue((SearchHitField)fields.get("lastModified"), Long.class));
                    this.setId((Object)target, searchHit.getId());
                    targetList.add(target);
                }
            }
            catch (Exception e) {
                throw new EsAccessException("response: " + response, e);
            }
        }
        return targetList;
    }

    private <T> T getFieldValue(SearchHitField field, Class<T> clazz) {
        if (field == null) {
            return null;
        }
        if (clazz.equals(Integer.class)) {
            Number value = (Number)field.getValue();
            if (value == null) {
                return null;
            }
            Integer v = value.intValue();
            return (T)v;
        }
        if (clazz.equals(Long.class)) {
            Number value = (Number)field.getValue();
            if (value == null) {
                return null;
            }
            Long v = value.longValue();
            return (T)v;
        }
        return (T)field.getValue();
    }

    public void iterate(String sessionId, AccessResultCallback<EsAccessResult> callback) {
        SearchResponse response = null;
        block0: while (true) {
            if (response == null) {
                response = (SearchResponse)this.getClient().get(c -> c.prepareSearch(this.index).setTypes(new String[]{this.type}).setScroll(new TimeValue((long)this.scrollTimeout)).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"sessionId", (String)sessionId))).setSize(this.scrollSize).execute());
            } else {
                String scrollId = response.getScrollId();
                response = (SearchResponse)this.getClient().get(c -> c.prepareSearchScroll(scrollId).setScroll(new TimeValue((long)this.scrollTimeout)).execute());
            }
            SearchHits searchHits = response.getHits();
            if (searchHits.hits().length == 0) break;
            Iterator iterator = searchHits.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SearchHit searchHit = (SearchHit)iterator.next();
                Map source = searchHit.getSource();
                EsAccessResult accessResult = (EsAccessResult)((Object)BeanUtil.copyMapToNewBean((Map)source, EsAccessResult.class, option -> {
                    option.converter((Converter)new AbstractCrawlerService.EsTimestampConverter(), (CharSequence[])timestampFields).excludeWhitespace();
                    option.exclude(new CharSequence[]{"accessResultData"});
                }));
                Map data = (Map)source.get("accessResultData");
                if (data != null) {
                    accessResult.setAccessResultData((AccessResultData<String>)new EsAccessResultData(data));
                }
                callback.iterate((AccessResult)accessResult);
            }
            break;
        }
    }
}

