/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.codelibs.fess.crawler.entity.EsUrlFilter;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.service.UrlFilterService;
import org.codelibs.fess.crawler.service.impl.AbstractCrawlerService;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class EsUrlFilterService
extends AbstractCrawlerService
implements UrlFilterService {
    private static final String FILTER_TYPE = "filterType";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    protected LoadingCache<String, List<Pattern>> includeFilterCache;
    protected LoadingCache<String, List<Pattern>> excludeFilterCache;
    protected int filterCacheExpireAfterWrite = 10;
    protected int maxLoadSize = 10000;

    @PostConstruct
    public void init() {
        this.esClient.addOnConnectListener(() -> this.createMapping("filter"));
        this.includeFilterCache = this.createFilterCache(INCLUDE);
        this.excludeFilterCache = this.createFilterCache(EXCLUDE);
    }

    protected LoadingCache<String, List<Pattern>> createFilterCache(final String type) {
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.filterCacheExpireAfterWrite, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, List<Pattern>>(){

            public List<Pattern> load(String key) {
                return EsUrlFilterService.this.getList(EsUrlFilter.class, key, (QueryBuilder)QueryBuilders.termQuery((String)EsUrlFilterService.FILTER_TYPE, (String)type), null, EsUrlFilterService.this.maxLoadSize, null).stream().map(f -> Pattern.compile(f.getUrl())).collect(Collectors.toList());
            }
        });
    }

    public void addIncludeUrlFilter(String sessionId, String url) {
        EsUrlFilter esUrlFilter = new EsUrlFilter();
        esUrlFilter.setSessionId(sessionId);
        esUrlFilter.setFilterType(INCLUDE);
        esUrlFilter.setUrl(url);
        this.insert(esUrlFilter, IndexRequest.OpType.CREATE);
        this.includeFilterCache.invalidate((Object)sessionId);
    }

    public void addIncludeUrlFilter(String sessionId, List<String> urlList) {
        HashSet<String> invalidateSet = new HashSet<String>();
        ArrayList<EsUrlFilter> urlFilterList = new ArrayList<EsUrlFilter>(urlList.size());
        for (String url : urlList) {
            EsUrlFilter esUrlFilter = new EsUrlFilter();
            esUrlFilter.setSessionId(sessionId);
            esUrlFilter.setFilterType(INCLUDE);
            esUrlFilter.setUrl(url);
            urlFilterList.add(esUrlFilter);
            invalidateSet.add(sessionId);
        }
        this.insertAll(urlFilterList, IndexRequest.OpType.CREATE);
        invalidateSet.forEach(s -> this.includeFilterCache.invalidate(s));
    }

    public void addExcludeUrlFilter(String sessionId, String url) {
        EsUrlFilter esUrlFilter = new EsUrlFilter();
        esUrlFilter.setSessionId(sessionId);
        esUrlFilter.setFilterType(EXCLUDE);
        esUrlFilter.setUrl(url);
        this.insert(esUrlFilter, IndexRequest.OpType.CREATE);
        this.excludeFilterCache.invalidate((Object)sessionId);
    }

    public void addExcludeUrlFilter(String sessionId, List<String> urlList) {
        HashSet invalidateSet = new HashSet();
        ArrayList<EsUrlFilter> urlFilterList = new ArrayList<EsUrlFilter>(urlList.size());
        for (String url : urlList) {
            EsUrlFilter esUrlFilter = new EsUrlFilter();
            esUrlFilter.setSessionId(sessionId);
            esUrlFilter.setFilterType(EXCLUDE);
            esUrlFilter.setUrl(url);
            urlFilterList.add(esUrlFilter);
        }
        this.insertAll(urlFilterList, IndexRequest.OpType.CREATE);
        invalidateSet.forEach(s -> this.excludeFilterCache.invalidate(s));
    }

    public void delete(String sessionId) {
        this.deleteBySessionId(sessionId);
        this.includeFilterCache.invalidate((Object)sessionId);
        this.excludeFilterCache.invalidate((Object)sessionId);
    }

    public List<Pattern> getIncludeUrlPatternList(String sessionId) {
        try {
            return (List)this.includeFilterCache.get((Object)sessionId);
        }
        catch (ExecutionException e) {
            throw new CrawlerSystemException((Throwable)e);
        }
    }

    public List<Pattern> getExcludeUrlPatternList(String sessionId) {
        try {
            return (List)this.excludeFilterCache.get((Object)sessionId);
        }
        catch (ExecutionException e) {
            throw new CrawlerSystemException((Throwable)e);
        }
    }

    public void setFilterCacheExpireAfterWrite(int filterCacheExpireAfterWrite) {
        this.filterCacheExpireAfterWrite = filterCacheExpireAfterWrite;
    }

    public void setMaxLoadSize(int maxLoadSize) {
        this.maxLoadSize = maxLoadSize;
    }
}

