/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.entity.EsAccessResult;
import org.codelibs.fess.crawler.entity.EsUrlQueue;
import org.codelibs.fess.crawler.entity.UrlQueue;
import org.codelibs.fess.crawler.exception.EsAccessException;
import org.codelibs.fess.crawler.service.UrlQueueService;
import org.codelibs.fess.crawler.service.impl.AbstractCrawlerService;
import org.codelibs.fess.crawler.service.impl.EsDataService;
import org.codelibs.fess.crawler.util.AccessResultCallback;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsUrlQueueService
extends AbstractCrawlerService
implements UrlQueueService<EsUrlQueue> {
    private static final Logger logger = LoggerFactory.getLogger(EsUrlQueueService.class);
    @Resource
    protected EsDataService dataService;
    protected Map<String, QueueHolder> sessionCache = new ConcurrentHashMap<String, QueueHolder>();
    protected int pollingFetchSize = 1000;
    protected int maxCrawlingQueueSize = 100;

    @PostConstruct
    public void init() {
        this.esClient.addOnConnectListener(() -> this.createMapping("queue"));
    }

    @PreDestroy
    public void destroy() {
        this.sessionCache.entrySet().stream().map(e -> ((QueueHolder)e.getValue()).waitingQueue).forEach(q -> q.forEach(urlQueue -> {
            try {
                this.insert((EsUrlQueue)((Object)((Object)urlQueue)));
            }
            catch (Exception e) {
                logger.warn("Failed to restore " + (Object)urlQueue, (Throwable)e);
            }
        }));
    }

    public void clearCache() {
        this.sessionCache.clear();
    }

    public void updateSessionId(String oldSessionId, String newSessionId) {
        block3: {
            SearchHits searchHits;
            BulkResponse bulkResponse;
            SearchResponse response = null;
            do {
                if (response == null) {
                    response = (SearchResponse)this.getClient().get(c -> c.prepareSearch(this.index).setTypes(new String[]{this.type}).setScroll(new TimeValue((long)this.scrollTimeout)).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"sessionId", (String)oldSessionId))).setSize(this.scrollSize).execute());
                } else {
                    String scrollId = response.getScrollId();
                    response = (SearchResponse)this.getClient().get(c -> c.prepareSearchScroll(scrollId).setScroll(new TimeValue((long)this.scrollTimeout)).execute());
                }
                searchHits = response.getHits();
                if (searchHits.hits().length == 0) break block3;
            } while (!(bulkResponse = (BulkResponse)this.getClient().get(c -> {
                BulkRequestBuilder builder = c.prepareBulk();
                for (SearchHit searchHit : searchHits) {
                    UpdateRequestBuilder updateRequest = c.prepareUpdate(this.index, this.type, searchHit.getId()).setDoc("sessionId", (Object)newSessionId);
                    builder.add(updateRequest);
                }
                return builder.execute();
            })).hasFailures());
            throw new EsAccessException(bulkResponse.buildFailureMessage());
        }
    }

    public void add(String sessionId, String url) {
        EsUrlQueue urlQueue = new EsUrlQueue();
        urlQueue.setSessionId(sessionId);
        urlQueue.setUrl(url);
        urlQueue.setCreateTime(System.currentTimeMillis());
        urlQueue.setLastModified(0L);
        urlQueue.setDepth(0);
        urlQueue.setMethod("GET");
        this.insert(urlQueue);
    }

    public void insert(EsUrlQueue urlQueue) {
        super.insert((Object)urlQueue, urlQueue.getId() == null ? IndexRequest.OpType.CREATE : IndexRequest.OpType.INDEX);
    }

    public void delete(String sessionId) {
        this.deleteBySessionId(sessionId);
    }

    public void offerAll(String sessionId, List<EsUrlQueue> urlQueueList) {
        if (logger.isDebugEnabled()) {
            logger.debug("Offering URL: Session ID: {}, UrlQueue: {}", (Object)sessionId, urlQueueList);
        }
        ArrayList<UrlQueue> targetList = new ArrayList<UrlQueue>(urlQueueList.size());
        for (UrlQueue urlQueue2 : urlQueueList) {
            if (!this.exists(sessionId, urlQueue2.getUrl()) && !this.dataService.exists(sessionId, urlQueue2.getUrl())) {
                urlQueue2.setSessionId(sessionId);
                targetList.add(urlQueue2);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Existed URL: Session ID: {}, UrlQueue: {}", (Object)sessionId, (Object)urlQueue2);
        }
        if (!targetList.isEmpty()) {
            this.insertAll(targetList.stream().filter(urlQueue -> StringUtil.isNotBlank((String)urlQueue.getSessionId()) && StringUtil.isNotBlank((String)urlQueue.getUrl())).collect(Collectors.toList()), IndexRequest.OpType.CREATE, true);
            if (logger.isDebugEnabled()) {
                logger.debug("Offered URL: Session ID: {}, UrlQueue: {}", (Object)sessionId, targetList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsUrlQueue poll(String sessionId) {
        QueueHolder queueHolder = this.getQueueHolder(sessionId);
        Queue<EsUrlQueue> waitingQueue = queueHolder.waitingQueue;
        Queue<EsUrlQueue> crawlingQueue = queueHolder.crawlingQueue;
        EsUrlQueue urlQueue = waitingQueue.poll();
        if (urlQueue != null) {
            if (crawlingQueue.size() > this.maxCrawlingQueueSize) {
                crawlingQueue.poll();
            }
            crawlingQueue.add(urlQueue);
            return urlQueue;
        }
        QueueHolder queueHolder2 = queueHolder;
        synchronized (queueHolder2) {
            urlQueue = waitingQueue.poll();
            if (urlQueue == null) {
                List<EsUrlQueue> urlQueueList = this.getList(EsUrlQueue.class, sessionId, null, 0, this.pollingFetchSize, (SortBuilder)SortBuilders.fieldSort((String)"createTime").order(SortOrder.ASC));
                if (urlQueueList.isEmpty()) {
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Queued URL: {}", urlQueueList);
                }
                waitingQueue.addAll(urlQueueList);
                if (!urlQueueList.isEmpty()) {
                    try {
                        BulkResponse response = (BulkResponse)this.getClient().get(c -> {
                            BulkRequestBuilder bulkBuilder = c.prepareBulk();
                            for (EsUrlQueue uq : urlQueueList) {
                                bulkBuilder.add(c.prepareDelete(this.index, this.type, (String)uq.getId()));
                            }
                            return bulkBuilder.setRefresh(true).execute();
                        });
                        if (response.hasFailures()) {
                            logger.warn(response.buildFailureMessage());
                        }
                    }
                    catch (Exception e) {
                        throw new EsAccessException("Failed to delete " + urlQueueList, e);
                    }
                }
                if ((urlQueue = waitingQueue.poll()) == null) {
                    return null;
                }
            }
        }
        if (crawlingQueue.size() > this.maxCrawlingQueueSize) {
            crawlingQueue.poll();
        }
        crawlingQueue.add(urlQueue);
        return urlQueue;
    }

    public void saveSession(String sessionId) {
    }

    public boolean visited(EsUrlQueue urlQueue) {
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url)) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL is a blank: " + url);
            }
            return false;
        }
        String sessionId = urlQueue.getSessionId();
        if (super.exists(sessionId, url)) {
            return true;
        }
        EsAccessResult accessResult = this.dataService.getAccessResult(sessionId, url);
        return accessResult != null;
    }

    @Override
    protected boolean exists(String sessionId, String url) {
        boolean ret = super.exists(sessionId, url);
        if (!ret) {
            QueueHolder queueHolder = this.getQueueHolder(sessionId);
            Queue<EsUrlQueue> waitingQueue = queueHolder.waitingQueue;
            Queue<EsUrlQueue> crawlingQueue = queueHolder.crawlingQueue;
            for (UrlQueue urlQueue : crawlingQueue) {
                if (!sessionId.equals(urlQueue.getSessionId()) || !url.equals(urlQueue.getUrl())) continue;
                return true;
            }
            for (UrlQueue urlQueue : waitingQueue) {
                if (!sessionId.equals(urlQueue.getSessionId()) || !url.equals(urlQueue.getUrl())) continue;
                return true;
            }
        }
        return ret;
    }

    public void generateUrlQueues(String previousSessionId, String sessionId) {
        this.dataService.iterate(previousSessionId, (AccessResultCallback<EsAccessResult>)((AccessResultCallback)accessResult -> {
            EsUrlQueue urlQueue = new EsUrlQueue();
            urlQueue.setSessionId(sessionId);
            urlQueue.setMethod(accessResult.getMethod());
            urlQueue.setUrl(accessResult.getUrl());
            urlQueue.setParentUrl(accessResult.getParentUrl());
            urlQueue.setDepth(0);
            urlQueue.setLastModified(accessResult.getLastModified());
            urlQueue.setCreateTime(System.currentTimeMillis());
            this.insert(urlQueue);
        }));
    }

    protected QueueHolder getQueueHolder(String sessionId) {
        QueueHolder queueHolder = this.sessionCache.get(sessionId);
        if (queueHolder == null) {
            queueHolder = new QueueHolder();
            QueueHolder prevQueueHolder = this.sessionCache.putIfAbsent(sessionId, queueHolder);
            return prevQueueHolder == null ? queueHolder : prevQueueHolder;
        }
        return queueHolder;
    }

    public void setPollingFetchSize(int pollingFetchSize) {
        this.pollingFetchSize = pollingFetchSize;
    }

    public void setMaxCrawlingQueueSize(int maxCrawlingQueueSize) {
        this.maxCrawlingQueueSize = maxCrawlingQueueSize;
    }

    protected static class QueueHolder {
        protected Queue<EsUrlQueue> waitingQueue = new ConcurrentLinkedQueue<EsUrlQueue>();
        protected Queue<EsUrlQueue> crawlingQueue = new ConcurrentLinkedQueue<EsUrlQueue>();

        protected QueueHolder() {
        }
    }
}

