/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.entity;

import java.io.IOException;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.AccessResultImpl;
import org.codelibs.fess.crawler.entity.EsAccessResultData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.ResultData;
import org.codelibs.fess.crawler.service.impl.EsDataService;
import org.lastaflute.di.core.SingletonLaContainer;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class EsAccessResult
extends AccessResultImpl<String>
implements ToXContent {
    public static final String ID = "id";
    public static final String SESSION_ID = "sessionId";
    public static final String RULE_ID = "ruleId";
    public static final String URL = "url";
    public static final String PARENT_URL = "parentUrl";
    public static final String STATUS = "status";
    public static final String HTTP_STATUS_CODE = "httpStatusCode";
    public static final String METHOD = "method";
    public static final String MIME_TYPE = "mimeType";
    public static final String CREATE_TIME = "createTime";
    public static final String EXECUTION_TIME = "executionTime";
    public static final String CONTENT_LENGTH = "contentLength";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String ACCESS_RESULT_DATA = "accessResultData";
    private boolean initializedData = false;

    public void init(ResponseData responseData, ResultData resultData) {
        this.setCreateTime(System.currentTimeMillis());
        if (responseData != null) {
            BeanUtil.copyBeanToBean((Object)responseData, (Object)((Object)this));
        }
        EsAccessResultData accessResultData = new EsAccessResultData();
        if (resultData != null) {
            BeanUtil.copyBeanToBean((Object)resultData, (Object)((Object)accessResultData));
        }
        this.setAccessResultData((AccessResultData<String>)accessResultData);
    }

    public AccessResultData<String> getAccessResultData() {
        if (!this.initializedData) {
            EsDataService dataService = (EsDataService)SingletonLaContainer.getComponent(EsDataService.class);
            EsAccessResult accessResult = dataService.getAccessResult(this.getSessionId(), this.getUrl());
            if (accessResult != null && accessResult.accessResultData != null) {
                this.setAccessResultData((AccessResultData<String>)accessResult.accessResultData);
            } else {
                this.setAccessResultData(null);
            }
        }
        return this.accessResultData;
    }

    public void setAccessResultData(AccessResultData<String> accessResultDataAsOne) {
        this.accessResultData = accessResultDataAsOne;
        this.initializedData = true;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.sessionId != null) {
            builder.field(SESSION_ID, this.sessionId);
        }
        if (this.ruleId != null) {
            builder.field(RULE_ID, this.ruleId);
        }
        if (this.url != null) {
            builder.field(URL, this.url);
        }
        if (this.parentUrl != null) {
            builder.field(PARENT_URL, this.parentUrl);
        }
        if (this.status != null) {
            builder.field(STATUS, this.status);
        }
        if (this.httpStatusCode != null) {
            builder.field(HTTP_STATUS_CODE, this.httpStatusCode);
        }
        if (this.method != null) {
            builder.field(METHOD, this.method);
        }
        if (this.mimeType != null) {
            builder.field(MIME_TYPE, this.mimeType);
        }
        if (this.createTime != null) {
            builder.field(CREATE_TIME, this.createTime);
        }
        if (this.executionTime != null) {
            builder.field(EXECUTION_TIME, this.executionTime);
        }
        if (this.contentLength != null) {
            builder.field(CONTENT_LENGTH, this.contentLength);
        }
        if (this.lastModified != null) {
            builder.field(LAST_MODIFIED, this.lastModified);
        }
        if (this.accessResultData instanceof ToXContent) {
            builder.field(ACCESS_RESULT_DATA);
            ((ToXContent)this.accessResultData).toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

