/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.entity.EsAccessResult;
import org.codelibs.fess.crawler.entity.EsUrlQueue;
import org.codelibs.fess.crawler.entity.UrlQueue;
import org.codelibs.fess.crawler.exception.EsAccessException;
import org.codelibs.fess.crawler.service.UrlQueueService;
import org.codelibs.fess.crawler.service.impl.AbstractCrawlerService;
import org.codelibs.fess.crawler.service.impl.EsDataService;
import org.codelibs.fess.crawler.util.AccessResultCallback;
import org.codelibs.fess.crawler.util.EsCrawlerConfig;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequestBuilder;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsUrlQueueService
extends AbstractCrawlerService
implements UrlQueueService<EsUrlQueue> {
    private static final Logger logger = LoggerFactory.getLogger(EsUrlQueueService.class);
    @Resource
    protected EsDataService dataService;
    protected Map<String, QueueHolder> sessionCache = new ConcurrentHashMap<String, QueueHolder>();
    protected int pollingFetchSize = 1000;
    protected int maxCrawlingQueueSize = 100;

    public EsUrlQueueService(EsCrawlerConfig crawlerConfig) {
        this.index = crawlerConfig.getQueueIndex();
        this.setNumberOfShards(crawlerConfig.getQueueShards());
        this.setNumberOfReplicas(crawlerConfig.getQueueReplicas());
    }

    public EsUrlQueueService(String name, String type) {
        this.index = name + "." + type;
    }

    @PostConstruct
    public void init() {
        this.fesenClient.addOnConnectListener(() -> this.createMapping("queue"));
    }

    @PreDestroy
    public void destroy() {
        this.sessionCache.entrySet().stream().map(e -> ((QueueHolder)e.getValue()).waitingQueue).forEach(q -> q.forEach(urlQueue -> {
            try {
                this.insert((EsUrlQueue)((Object)((Object)urlQueue)));
            }
            catch (Exception e) {
                logger.warn("Failed to restore " + urlQueue, (Throwable)e);
            }
        }));
    }

    public void clearCache() {
        this.sessionCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSessionId(String oldSessionId, String newSessionId) {
        SearchResponse response = (SearchResponse)this.getClient().get(c -> c.prepareSearch(this.index).setScroll(new TimeValue((long)this.scrollTimeout)).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"sessionId", (String)oldSessionId))).setSize(this.scrollSize).execute());
        String scrollId = response.getScrollId();
        try {
            while (scrollId != null) {
                SearchHits searchHits = response.getHits();
                if (searchHits.getHits().length == 0) {
                    break;
                }
                BulkResponse bulkResponse = (BulkResponse)this.getClient().get(c -> {
                    BulkRequestBuilder builder = c.prepareBulk();
                    for (SearchHit searchHit : searchHits) {
                        UpdateRequestBuilder updateRequest = ((UpdateRequestBuilder)c.prepareUpdate().setIndex(this.index)).setId(searchHit.getId()).setDoc(new Object[]{"sessionId", newSessionId});
                        builder.add(updateRequest);
                    }
                    return builder.execute();
                });
                if (bulkResponse.hasFailures()) {
                    throw new EsAccessException(bulkResponse.buildFailureMessage());
                }
                String sid = scrollId;
                response = (SearchResponse)this.getClient().get(c -> c.prepareSearchScroll(sid).setScroll(new TimeValue((long)this.scrollTimeout)).execute());
                if (!scrollId.equals(response.getScrollId())) {
                    this.getClient().clearScroll(scrollId);
                }
                scrollId = response.getScrollId();
            }
        }
        finally {
            this.getClient().clearScroll(scrollId);
        }
    }

    public void add(String sessionId, String url) {
        if (this.exists(sessionId, url)) {
            return;
        }
        EsUrlQueue urlQueue = new EsUrlQueue();
        urlQueue.setSessionId(sessionId);
        urlQueue.setUrl(url);
        urlQueue.setCreateTime(System.currentTimeMillis());
        urlQueue.setLastModified(0L);
        urlQueue.setDepth(0);
        urlQueue.setMethod("GET");
        this.insert(urlQueue);
    }

    public void insert(EsUrlQueue urlQueue) {
        try {
            super.insert((Object)urlQueue, urlQueue.getId() == null ? DocWriteRequest.OpType.CREATE : DocWriteRequest.OpType.INDEX);
        }
        catch (EsAccessException e) {
            Throwable cause = e.getCause();
            if (cause != null && "VersionConflictEngineException".equals(cause.getClass().getSimpleName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to insert {}", (Object)urlQueue, (Object)e);
                }
                return;
            }
            throw e;
        }
    }

    public void delete(String sessionId) {
        this.deleteBySessionId(sessionId);
    }

    public void offerAll(String sessionId, List<EsUrlQueue> urlQueueList) {
        if (logger.isDebugEnabled()) {
            logger.debug("Offering URL: Session ID: {}, UrlQueue: {}", (Object)sessionId, urlQueueList);
        }
        ArrayList<UrlQueue> targetList = new ArrayList<UrlQueue>(urlQueueList.size());
        for (UrlQueue urlQueue2 : urlQueueList) {
            if (!this.exists(sessionId, urlQueue2.getUrl()) && !this.dataService.exists(sessionId, urlQueue2.getUrl())) {
                urlQueue2.setSessionId(sessionId);
                targetList.add(urlQueue2);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Existed URL: Session ID: {}, UrlQueue: {}", (Object)sessionId, (Object)urlQueue2);
        }
        if (!targetList.isEmpty()) {
            this.insertAll(targetList.stream().filter(urlQueue -> StringUtil.isNotBlank((String)urlQueue.getSessionId()) && StringUtil.isNotBlank((String)urlQueue.getUrl())).collect(Collectors.toList()), DocWriteRequest.OpType.CREATE, true);
            if (logger.isDebugEnabled()) {
                logger.debug("Offered URL: Session ID: {}, UrlQueue: {}", (Object)sessionId, targetList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsUrlQueue poll(String sessionId) {
        QueueHolder queueHolder = this.getQueueHolder(sessionId);
        Queue<EsUrlQueue> waitingQueue = queueHolder.waitingQueue;
        Queue<EsUrlQueue> crawlingQueue = queueHolder.crawlingQueue;
        EsUrlQueue urlQueue = waitingQueue.poll();
        if (urlQueue != null) {
            if (crawlingQueue.size() > this.maxCrawlingQueueSize) {
                crawlingQueue.poll();
            }
            crawlingQueue.add(urlQueue);
            return urlQueue;
        }
        QueueHolder queueHolder2 = queueHolder;
        synchronized (queueHolder2) {
            urlQueue = waitingQueue.poll();
            if (urlQueue == null) {
                List<EsUrlQueue> urlQueueList = this.getList(EsUrlQueue.class, sessionId, null, 0, this.pollingFetchSize, SortBuilders.fieldSort((String)"createTime").order(SortOrder.ASC));
                if (urlQueueList.isEmpty()) {
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Queued URL: {}", urlQueueList);
                }
                if (!urlQueueList.isEmpty()) {
                    try {
                        BulkResponse response = (BulkResponse)this.getClient().get(c -> {
                            BulkRequestBuilder bulkBuilder = c.prepareBulk();
                            for (EsUrlQueue uq : urlQueueList) {
                                bulkBuilder.add(((DeleteRequestBuilder)c.prepareDelete().setIndex(this.index)).setId((String)uq.getId()));
                            }
                            return ((BulkRequestBuilder)bulkBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute();
                        });
                        if (response.hasFailures()) {
                            logger.warn(response.buildFailureMessage());
                        }
                    }
                    catch (Exception e) {
                        throw new EsAccessException("Failed to delete " + urlQueueList, e);
                    }
                }
                waitingQueue.addAll(urlQueueList);
                urlQueue = waitingQueue.poll();
                if (urlQueue == null) {
                    return null;
                }
            }
        }
        if (crawlingQueue.size() > this.maxCrawlingQueueSize) {
            crawlingQueue.poll();
        }
        crawlingQueue.add(urlQueue);
        return urlQueue;
    }

    public void saveSession(String sessionId) {
    }

    public boolean visited(EsUrlQueue urlQueue) {
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url)) {
            if (logger.isDebugEnabled()) {
                logger.debug("URL is a blank: {}", (Object)url);
            }
            return false;
        }
        String sessionId = urlQueue.getSessionId();
        if (super.exists(sessionId, url)) {
            return true;
        }
        EsAccessResult accessResult = this.dataService.getAccessResult(sessionId, url);
        return accessResult != null;
    }

    @Override
    protected boolean exists(String sessionId, String url) {
        boolean ret = super.exists(sessionId, url);
        if (!ret) {
            QueueHolder queueHolder = this.getQueueHolder(sessionId);
            Queue<EsUrlQueue> waitingQueue = queueHolder.waitingQueue;
            Queue<EsUrlQueue> crawlingQueue = queueHolder.crawlingQueue;
            for (UrlQueue urlQueue : crawlingQueue) {
                if (!sessionId.equals(urlQueue.getSessionId()) || !url.equals(urlQueue.getUrl())) continue;
                return true;
            }
            for (UrlQueue urlQueue : waitingQueue) {
                if (!sessionId.equals(urlQueue.getSessionId()) || !url.equals(urlQueue.getUrl())) continue;
                return true;
            }
        }
        return ret;
    }

    public void generateUrlQueues(String previousSessionId, String sessionId) {
        this.dataService.iterate(previousSessionId, (AccessResultCallback<EsAccessResult>)((AccessResultCallback)accessResult -> {
            EsUrlQueue urlQueue = new EsUrlQueue();
            urlQueue.setSessionId(sessionId);
            urlQueue.setMethod(accessResult.getMethod());
            urlQueue.setUrl(accessResult.getUrl());
            urlQueue.setParentUrl(accessResult.getParentUrl());
            urlQueue.setDepth(0);
            urlQueue.setLastModified(accessResult.getLastModified());
            urlQueue.setCreateTime(System.currentTimeMillis());
            this.insert(urlQueue);
        }));
    }

    protected QueueHolder getQueueHolder(String sessionId) {
        QueueHolder queueHolder = this.sessionCache.get(sessionId);
        if (queueHolder == null) {
            queueHolder = new QueueHolder();
            QueueHolder prevQueueHolder = this.sessionCache.putIfAbsent(sessionId, queueHolder);
            return prevQueueHolder == null ? queueHolder : prevQueueHolder;
        }
        return queueHolder;
    }

    public void setPollingFetchSize(int pollingFetchSize) {
        this.pollingFetchSize = pollingFetchSize;
    }

    public void setMaxCrawlingQueueSize(int maxCrawlingQueueSize) {
        this.maxCrawlingQueueSize = maxCrawlingQueueSize;
    }

    protected static class QueueHolder {
        protected Queue<EsUrlQueue> waitingQueue = new ConcurrentLinkedQueue<EsUrlQueue>();
        protected Queue<EsUrlQueue> crawlingQueue = new ConcurrentLinkedQueue<EsUrlQueue>();

        protected QueueHolder() {
        }
    }
}

