/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.RandomUtils;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.lang.ThreadUtil;
import org.codelibs.core.stream.StreamUtil;
import org.codelibs.fesen.client.HttpClient;
import org.codelibs.fess.crawler.exception.EsAccessException;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.opensearch.action.admin.indices.segments.PitSegmentsRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.explain.ExplainRequest;
import org.opensearch.action.explain.ExplainRequestBuilder;
import org.opensearch.action.explain.ExplainResponse;
import org.opensearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.opensearch.action.fieldcaps.FieldCapabilitiesRequestBuilder;
import org.opensearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetRequestBuilder;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetRequestBuilder;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollRequestBuilder;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.CreatePitResponse;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.action.search.GetAllPitNodesRequest;
import org.opensearch.action.search.GetAllPitNodesResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchRequestBuilder;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.search.SearchScrollRequestBuilder;
import org.opensearch.action.termvectors.MultiTermVectorsRequest;
import org.opensearch.action.termvectors.MultiTermVectorsRequestBuilder;
import org.opensearch.action.termvectors.MultiTermVectorsResponse;
import org.opensearch.action.termvectors.TermVectorsRequest;
import org.opensearch.action.termvectors.TermVectorsRequestBuilder;
import org.opensearch.action.termvectors.TermVectorsResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateRequestBuilder;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.AdminClient;
import org.opensearch.client.Client;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.Scroll;
import org.opensearch.search.SearchHit;
import org.opensearch.threadpool.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FesenClient
implements Client {
    public static final String HTTP_ADDRESS = "crawler.es.http_address";
    public static final String TARGET_INDICES = "crawler.es.target_indices";
    private static final Logger logger = LoggerFactory.getLogger(FesenClient.class);
    protected Client client;
    protected String address;
    protected List<OnConnectListener> onConnectListenerList = new ArrayList<OnConnectListener>();
    private volatile boolean connected;
    protected Scroll scrollForDelete = new Scroll(TimeValue.timeValueMinutes((long)1L));
    protected int sizeForDelete = 10;
    protected long retryInterval = 3000L;
    protected int maxRetryCount = 5;
    protected long connTimeout = 180000L;
    protected String searchPreference;
    protected String[] targetIndices;

    public FesenClient() {
        this.address = System.getProperty(HTTP_ADDRESS, "localhost:9200").trim();
        String targets = System.getProperty(TARGET_INDICES);
        if (StringUtil.isNotBlank((String)targets)) {
            this.targetIndices = (String[])Arrays.stream(targets.split(",")).map(String::trim).toArray(String[]::new);
        }
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void addOnConnectListener(OnConnectListener listener) {
        this.onConnectListenerList.add(listener);
    }

    public boolean connected() {
        return this.connected;
    }

    public void connect() {
        this.destroy();
        this.client = this.createClient();
        ClusterHealthResponse healthResponse = (ClusterHealthResponse)this.get((FesenClient c) -> c.admin().cluster().prepareHealth(this.targetIndices).setWaitForYellowStatus().execute());
        if (!healthResponse.isTimedOut()) {
            this.onConnectListenerList.forEach(l -> {
                try {
                    l.onConnect();
                }
                catch (Exception e) {
                    logger.warn("Failed to invoke " + l, (Throwable)e);
                }
            });
            this.connected = true;
        } else {
            logger.warn("Could not connect to {}", (Object)this.address);
        }
    }

    protected Client createClient() {
        String[] hosts = (String[])StreamUtil.split((String)this.address, (String)",").get(stream -> (String[])stream.map(String::trim).filter(StringUtil::isNotEmpty).toArray(String[]::new));
        Settings settings = Settings.builder().putList("http.hosts", hosts).build();
        return new HttpClient(settings, null);
    }

    public <T> T get(Function<FesenClient, ActionFuture<T>> func) {
        int retryCount = 0;
        while (true) {
            try {
                return (T)func.apply(this).actionGet(this.connTimeout, TimeUnit.MILLISECONDS);
            }
            catch (IndexNotFoundException | VersionConflictEngineException e) {
                logger.debug("{} occurs.", (Object)e.getClass().getName(), (Object)e);
                throw e;
            }
            catch (Exception e) {
                if (retryCount > this.maxRetryCount) {
                    throw e;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to invoke actionGet. count:{}", (Object)retryCount, (Object)e);
                }
                ThreadUtil.sleep((long)RandomUtils.nextLong((long)(this.retryInterval + (long)retryCount * 1000L), (long)(this.retryInterval + (long)retryCount * 1000L * 2L)));
                ++retryCount;
                continue;
            }
            break;
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (OpenSearchException e) {
                logger.warn("Failed to close client.", (Throwable)e);
            }
            logger.info("Disconnected to {}", (Object)this.address);
        }
        this.connected = false;
    }

    public ThreadPool threadPool() {
        return this.client.threadPool();
    }

    public AdminClient admin() {
        return this.client.admin();
    }

    public ActionFuture<IndexResponse> index(IndexRequest request) {
        return this.client.index(request);
    }

    public void index(IndexRequest request, ActionListener<IndexResponse> listener) {
        this.client.index(request, listener);
    }

    public IndexRequestBuilder prepareIndex() {
        return this.client.prepareIndex();
    }

    public ActionFuture<UpdateResponse> update(UpdateRequest request) {
        return this.client.update(request);
    }

    public void update(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.client.update(request, listener);
    }

    public UpdateRequestBuilder prepareUpdate() {
        return this.client.prepareUpdate();
    }

    public UpdateRequestBuilder prepareUpdate(String index, String id) {
        return this.client.prepareUpdate(index, id);
    }

    public IndexRequestBuilder prepareIndex(String index) {
        return this.client.prepareIndex(index);
    }

    public ActionFuture<DeleteResponse> delete(DeleteRequest request) {
        return this.client.delete(request);
    }

    public void delete(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        this.client.delete(request, listener);
    }

    public DeleteRequestBuilder prepareDelete() {
        return this.client.prepareDelete();
    }

    public DeleteRequestBuilder prepareDelete(String index, String id) {
        return this.client.prepareDelete(index, id);
    }

    public ActionFuture<BulkResponse> bulk(BulkRequest request) {
        return this.client.bulk(request);
    }

    public void bulk(BulkRequest request, ActionListener<BulkResponse> listener) {
        this.client.bulk(request, listener);
    }

    public BulkRequestBuilder prepareBulk() {
        return this.client.prepareBulk();
    }

    public ActionFuture<GetResponse> get(GetRequest request) {
        return this.client.get(request);
    }

    public void get(GetRequest request, ActionListener<GetResponse> listener) {
        this.client.get(request, listener);
    }

    public GetRequestBuilder prepareGet() {
        return this.client.prepareGet();
    }

    public GetRequestBuilder prepareGet(String index, String id) {
        return this.client.prepareGet(index, id);
    }

    public ActionFuture<MultiGetResponse> multiGet(MultiGetRequest request) {
        return this.client.multiGet(request);
    }

    public void multiGet(MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        this.client.multiGet(request, listener);
    }

    public MultiGetRequestBuilder prepareMultiGet() {
        return this.client.prepareMultiGet();
    }

    public ActionFuture<SearchResponse> search(SearchRequest request) {
        return this.client.search(request);
    }

    public void search(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.client.search(request, listener);
    }

    public SearchRequestBuilder prepareSearch(String ... indices) {
        SearchRequestBuilder builder = this.client.prepareSearch(indices);
        if (this.searchPreference != null) {
            builder.setPreference(this.searchPreference);
        }
        return builder;
    }

    public ActionFuture<SearchResponse> searchScroll(SearchScrollRequest request) {
        return this.client.searchScroll(request);
    }

    public void searchScroll(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        this.client.searchScroll(request, listener);
    }

    public SearchScrollRequestBuilder prepareSearchScroll(String scrollId) {
        return this.client.prepareSearchScroll(scrollId);
    }

    public ActionFuture<MultiSearchResponse> multiSearch(MultiSearchRequest request) {
        return this.client.multiSearch(request);
    }

    public void multiSearch(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        this.client.multiSearch(request, listener);
    }

    public MultiSearchRequestBuilder prepareMultiSearch() {
        return this.client.prepareMultiSearch();
    }

    public ExplainRequestBuilder prepareExplain(String index, String id) {
        return this.client.prepareExplain(index, id);
    }

    public ActionFuture<ExplainResponse> explain(ExplainRequest request) {
        return this.client.explain(request);
    }

    public void explain(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        this.client.explain(request, listener);
    }

    public ClearScrollRequestBuilder prepareClearScroll() {
        return this.client.prepareClearScroll();
    }

    public ActionFuture<ClearScrollResponse> clearScroll(ClearScrollRequest request) {
        return this.client.clearScroll(request);
    }

    public void clearScroll(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        this.client.clearScroll(request, listener);
    }

    public Settings settings() {
        return this.client.settings();
    }

    public void close() {
        this.client.close();
    }

    public ActionFuture<TermVectorsResponse> termVectors(TermVectorsRequest request) {
        return this.client.termVectors(request);
    }

    public void termVectors(TermVectorsRequest request, ActionListener<TermVectorsResponse> listener) {
        this.client.termVectors(request, listener);
    }

    public TermVectorsRequestBuilder prepareTermVectors() {
        return this.client.prepareTermVectors();
    }

    public TermVectorsRequestBuilder prepareTermVectors(String index, String id) {
        return this.client.prepareTermVectors(index, id);
    }

    public ActionFuture<MultiTermVectorsResponse> multiTermVectors(MultiTermVectorsRequest request) {
        return this.client.multiTermVectors(request);
    }

    public void multiTermVectors(MultiTermVectorsRequest request, ActionListener<MultiTermVectorsResponse> listener) {
        this.client.multiTermVectors(request, listener);
    }

    public MultiTermVectorsRequestBuilder prepareMultiTermVectors() {
        return this.client.prepareMultiTermVectors();
    }

    public <Request extends ActionRequest, Response extends ActionResponse> ActionFuture<Response> execute(ActionType<Response> action, Request request) {
        return this.client.execute(action, request);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.client.execute(action, request, listener);
    }

    public Client filterWithHeader(Map<String, String> headers) {
        this.client.filterWithHeader(headers);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByQuery(String index, String type, QueryBuilder queryBuilder) {
        SearchResponse response = (SearchResponse)this.get((FesenClient c) -> c.prepareSearch(index).setScroll(this.scrollForDelete).setSize(this.sizeForDelete).setQuery(queryBuilder).execute());
        String scrollId = response.getScrollId();
        int count = 0;
        try {
            while (scrollId != null) {
                SearchHit[] hits = response.getHits().getHits();
                if (hits.length == 0) {
                    break;
                }
                count += hits.length;
                BulkResponse bulkResponse = (BulkResponse)this.get((FesenClient c) -> {
                    BulkRequestBuilder bulkRequest = this.client.prepareBulk();
                    for (SearchHit hit : hits) {
                        bulkRequest.add(((DeleteRequestBuilder)this.client.prepareDelete().setIndex(hit.getIndex())).setId(hit.getId()));
                    }
                    return bulkRequest.execute();
                });
                if (bulkResponse.hasFailures()) {
                    throw new EsAccessException(bulkResponse.buildFailureMessage());
                }
                String sid = scrollId;
                response = (SearchResponse)this.get((FesenClient c) -> c.prepareSearchScroll(sid).setScroll(this.scrollForDelete).execute());
                if (!scrollId.equals(response.getScrollId())) {
                    this.clearScroll(scrollId);
                }
                scrollId = response.getScrollId();
            }
        }
        finally {
            this.clearScroll(scrollId);
        }
        return count;
    }

    public void clearScroll(String scrollId) {
        if (scrollId != null) {
            this.prepareClearScroll().addScrollId(scrollId).execute(ActionListener.wrap(res -> {}, e -> logger.warn("Failed to clear " + scrollId, (Throwable)e)));
        }
    }

    public void setScrollForDelete(Scroll scrollForDelete) {
        this.scrollForDelete = scrollForDelete;
    }

    public void setSizeForDelete(int sizeForDelete) {
        this.sizeForDelete = sizeForDelete;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public void setConnTimeout(long connTimeout) {
        this.connTimeout = connTimeout;
    }

    public void setSearchPreference(String searchPreference) {
        this.searchPreference = searchPreference;
    }

    public FieldCapabilitiesRequestBuilder prepareFieldCaps(String ... indices) {
        return this.client.prepareFieldCaps(indices);
    }

    public ActionFuture<FieldCapabilitiesResponse> fieldCaps(FieldCapabilitiesRequest request) {
        return this.client.fieldCaps(request);
    }

    public void fieldCaps(FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        this.client.fieldCaps(request, listener);
    }

    public BulkRequestBuilder prepareBulk(String globalIndex) {
        return this.client.prepareBulk(globalIndex);
    }

    public void createPit(CreatePitRequest createPITRequest, ActionListener<CreatePitResponse> listener) {
        this.client.createPit(createPITRequest, listener);
    }

    public void deletePits(DeletePitRequest deletePITRequest, ActionListener<DeletePitResponse> listener) {
        this.client.deletePits(deletePITRequest, listener);
    }

    public void getAllPits(GetAllPitNodesRequest getAllPitNodesRequest, ActionListener<GetAllPitNodesResponse> listener) {
        this.client.getAllPits(getAllPitNodesRequest, listener);
    }

    public void pitSegments(PitSegmentsRequest pitSegmentsRequest, ActionListener<IndicesSegmentResponse> listener) {
        this.client.pitSegments(pitSegmentsRequest, listener);
    }

    public static interface OnConnectListener {
        public void onConnect();
    }
}

