/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.lucene.search.TotalHits;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.Converter;
import org.codelibs.core.beans.PropertyDesc;
import org.codelibs.core.beans.factory.BeanDescFactory;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.security.MessageDigestUtil;
import org.codelibs.fess.crawler.client.FesenClient;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.EsAccessResult;
import org.codelibs.fess.crawler.entity.EsAccessResultData;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.EsAccessException;
import org.codelibs.fess.crawler.util.EsResultList;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequestBuilder;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.sort.SortBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCrawlerService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCrawlerService.class);
    private static final String ID_SEPARATOR = ".";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected static final String ID = "id";
    protected static final String SESSION_ID = "sessionId";
    protected static final String URL = "url";
    protected static final String LAST_MODIFIED = "lastModified";
    protected static final String CREATE_TIME = "createTime";
    protected static final String _DOC = "_doc";
    protected static final String[] timestampFields = new String[]{"lastModified", "createTime"};
    protected static final HashFunction murmur3Hash = Hashing.murmur3_128((int)0);
    @Resource
    protected volatile FesenClient fesenClient;
    protected String index;
    protected int scrollTimeout = 60000;
    protected int scrollSize = 100;
    protected int bulkBufferSize = 10;
    protected int numberOfShards = 5;
    protected int numberOfReplicas = 1;
    protected int idPrefixLength = 445;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FesenClient getClient() {
        if (!this.fesenClient.connected()) {
            FesenClient fesenClient = this.fesenClient;
            synchronized (fesenClient) {
                if (!this.fesenClient.connected()) {
                    this.fesenClient.connect();
                }
            }
        }
        return this.fesenClient;
    }

    protected void createMapping(String mappingName) {
        GetMappingsResponse getMappingsResponse;
        Map indexMappings;
        boolean exists = false;
        try {
            IndicesExistsResponse response = (IndicesExistsResponse)this.fesenClient.get(c -> c.admin().indices().prepareExists(new String[]{this.index}).execute());
            exists = response.isExists();
        }
        catch (IndexNotFoundException response) {
            // empty catch block
        }
        if (!exists) {
            CreateIndexResponse indexResponse = (CreateIndexResponse)this.fesenClient.get(c -> {
                String source = this.numberOfReplicas > 0 ? "{\"settings\":{\"index\":{\"number_of_shards\":" + this.numberOfShards + ",\"number_of_replicas\":0,\"auto_expand_replicas\":\"0-" + this.numberOfReplicas + "\"}}}" : "{\"settings\":{\"index\":{\"number_of_shards\":" + this.numberOfShards + ",\"number_of_replicas\":" + this.numberOfReplicas + "}}}";
                return c.admin().indices().prepareCreate(this.index).setSource(source, (MediaType)XContentType.JSON).execute();
            });
            if (indexResponse.isAcknowledged()) {
                logger.info("Created {} index.", (Object)this.index);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Failed to create {} index.", (Object)this.index);
            }
        }
        if ((indexMappings = (getMappingsResponse = (GetMappingsResponse)this.fesenClient.get(c -> c.admin().indices().prepareGetMappings(new String[]{this.index}).execute())).mappings()) == null || !indexMappings.containsKey("properties")) {
            AcknowledgedResponse putMappingResponse = (AcknowledgedResponse)this.fesenClient.get(c -> {
                String source = FileUtil.readText((String)("mapping/" + mappingName + ".json"));
                return c.admin().indices().preparePutMapping(new String[]{this.index}).setSource(source, (MediaType)XContentType.JSON).execute();
            });
            if (putMappingResponse.isAcknowledged()) {
                logger.info("Created {} mapping.", (Object)this.index);
            } else {
                logger.warn("Failed to create {} mapping.", (Object)this.index);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{} mapping exists.", (Object)this.index);
        }
    }

    protected Date getDateFromSource(Map<String, Object> sourceMap, String name) {
        block5: {
            Object obj = sourceMap.get(name);
            if (obj instanceof Date) {
                return (Date)obj;
            }
            if (obj instanceof Number) {
                return new Date(((Number)obj).longValue());
            }
            if (obj instanceof String) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    return sdf.parse(obj.toString());
                }
                catch (ParseException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("Failed to parse {}", obj, (Object)e);
                }
            }
        }
        return null;
    }

    protected XContentBuilder getXContentBuilder(Object target) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().value(target);
            builder.flush();
            return builder;
        }
        catch (IOException e) {
            throw new EsAccessException("Failed to convert " + target + " to JSON.", e);
        }
    }

    protected RefreshResponse refresh() {
        try {
            return (RefreshResponse)this.getClient().get(c -> c.admin().indices().prepareRefresh(new String[]{this.index}).execute());
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to refresh.", e);
        }
    }

    protected IndexResponse insert(Object target, DocWriteRequest.OpType opType) {
        IndexResponse indexResponse;
        block11: {
            String url = this.getUrl(target);
            if (url == null) {
                throw new EsAccessException("url is null.");
            }
            String id = this.getId(this.getSessionId(target), url);
            XContentBuilder source = this.getXContentBuilder(target);
            try {
                IndexResponse response = (IndexResponse)this.getClient().get(c -> ((IndexRequestBuilder)((IndexRequestBuilder)c.prepareIndex().setIndex(this.index)).setId(id).setSource(source).setOpType(opType).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute());
                this.setId(target, id);
                indexResponse = response;
                if (source == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OpenSearchStatusException e) {
                    if (e.status() == RestStatus.CONFLICT) {
                        throw new CrawlingAccessException("[" + e.status() + "] Failed to insert " + id, (Throwable)e);
                    }
                    throw new EsAccessException("[" + e.status() + "] Failed to insert " + id, e);
                }
                catch (Exception e) {
                    throw new EsAccessException("Failed to insert " + id, e);
                }
            }
            source.close();
        }
        return indexResponse;
    }

    protected <T> void insertAll(List<T> list, DocWriteRequest.OpType opType) {
        this.insertAll(list, opType, false);
    }

    protected <T> void insertAll(List<T> list, DocWriteRequest.OpType opType, boolean ignoreAlreadyExists) {
        String failureMessage;
        BulkResponse response;
        ArrayList bufferedList = new ArrayList(this.bulkBufferSize);
        StringBuilder failureBuf = new StringBuilder(100);
        list.stream().forEach(target -> {
            bufferedList.add(target);
            if (bufferedList.size() >= this.bulkBufferSize) {
                String failureMessage;
                BulkResponse response = this.doInsertAll(bufferedList, opType);
                if (response.hasFailures() && (failureMessage = this.buildFailureMessage(response, ignoreAlreadyExists)).length() > 0) {
                    failureBuf.append(response.buildFailureMessage()).append('\n');
                }
                bufferedList.clear();
            }
        });
        if (!bufferedList.isEmpty() && (response = this.doInsertAll(bufferedList, opType)).hasFailures() && (failureMessage = this.buildFailureMessage(response, ignoreAlreadyExists)).length() > 0) {
            failureBuf.append(response.buildFailureMessage()).append('\n');
        }
        if (failureBuf.length() > 0) {
            throw new EsAccessException(failureBuf.toString());
        }
    }

    protected String buildFailureMessage(BulkResponse bulkResponse, boolean ignoreAlreadyExists) {
        StringBuilder sb = new StringBuilder(100);
        BulkItemResponse[] responses = bulkResponse.getItems();
        for (int i = 0; i < responses.length; ++i) {
            BulkItemResponse response = responses[i];
            if (!response.isFailed() || ignoreAlreadyExists) continue;
            sb.append("\n[").append(i).append("]: index [").append(response.getIndex()).append("], id [").append(response.getId()).append("], message [").append(response.getFailureMessage()).append("]");
        }
        if (sb.length() > 0) {
            return "failure in bulk execution:" + sb.toString();
        }
        return "";
    }

    protected <T> BulkResponse doInsertAll(List<T> list, DocWriteRequest.OpType opType) {
        try {
            return (BulkResponse)this.getClient().get(c -> {
                BulkRequestBuilder bulkRequest = c.prepareBulk();
                for (Object target : list) {
                    String id = this.getId(this.getSessionId(target), this.getUrl(target));
                    try (XContentBuilder source = this.getXContentBuilder(target);){
                        bulkRequest.add(((IndexRequestBuilder)c.prepareIndex().setIndex(this.index)).setId(id).setSource(source).setOpType(opType));
                    }
                    this.setId(target, id);
                }
                return ((BulkRequestBuilder)bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute();
            });
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to insert " + list, e);
        }
    }

    protected boolean exists(String sessionId, String url) {
        String id = this.getId(sessionId, url);
        try {
            GetResponse response = (GetResponse)this.getClient().get(c -> c.prepareGet(this.index, id).execute());
            return response.isExists();
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to check if " + sessionId + ":" + url + " exists.", e);
        }
    }

    public int getCount(Consumer<SearchRequestBuilder> callback) {
        TotalHits totalHits = ((SearchResponse)this.getClient().get(c -> {
            SearchRequestBuilder builder = c.prepareSearch(this.index).setSize(0).setTrackTotalHits(true);
            callback.accept(builder);
            return builder.execute();
        })).getHits().getTotalHits();
        return totalHits != null ? (int)totalHits.value : 0;
    }

    protected <T> T get(Class<T> clazz, String sessionId, String url) {
        String id = this.getId(sessionId, url);
        GetResponse response = (GetResponse)this.getClient().get(c -> ((GetRequestBuilder)c.prepareGet().setIndex(this.index)).setId(id).execute());
        if (response.isExists()) {
            Map source = response.getSource();
            Object bean = BeanUtil.copyMapToNewBean((Map)source, clazz, option -> {
                option.converter((Converter)new EsTimestampConverter(), (CharSequence[])timestampFields).excludeWhitespace();
                option.exclude(new CharSequence[]{"accessResultData"});
            });
            Map data = (Map)source.get("accessResultData");
            if (data != null) {
                ((EsAccessResult)((Object)bean)).setAccessResultData((AccessResultData<String>)new EsAccessResultData(data));
            }
            this.setId(bean, id);
            return (T)bean;
        }
        return null;
    }

    protected <T> List<T> getList(Class<T> clazz, String sessionId, QueryBuilder queryBuilder, Integer from, Integer size, SortBuilder<?> sortBuilder) {
        return this.getList(clazz, builder -> {
            if (StringUtil.isNotBlank((String)sessionId)) {
                if (queryBuilder instanceof BoolQueryBuilder) {
                    ((BoolQueryBuilder)queryBuilder).filter((QueryBuilder)QueryBuilders.termQuery((String)SESSION_ID, (String)sessionId));
                } else {
                    BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)SESSION_ID, (String)sessionId));
                    if (queryBuilder != null) {
                        boolQuery.must(queryBuilder);
                    }
                    builder.setQuery((QueryBuilder)boolQuery);
                }
            } else if (queryBuilder != null) {
                builder.setQuery(queryBuilder);
            } else {
                builder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
            }
            if (sortBuilder != null) {
                builder.addSort(sortBuilder);
            }
            if (from != null) {
                builder.setFrom(from.intValue());
            }
            if (size != null) {
                builder.setSize(size.intValue());
            }
        });
    }

    protected <T> List<T> getList(Class<T> clazz, Consumer<SearchRequestBuilder> callback) {
        SearchResponse response = (SearchResponse)this.getClient().get(c -> {
            SearchRequestBuilder builder = c.prepareSearch(this.index);
            callback.accept(builder);
            return builder.execute();
        });
        EsResultList<Object> targetList = new EsResultList<Object>();
        SearchHits hits = response.getHits();
        TotalHits totalHits = hits.getTotalHits();
        long totalHitsValue = totalHits != null ? totalHits.value : 0L;
        targetList.setTotalHits(totalHitsValue);
        targetList.setTookInMillis(response.getTook().getMillis());
        if (totalHitsValue != 0L) {
            try {
                for (SearchHit searchHit : hits.getHits()) {
                    Map source = searchHit.getSourceAsMap();
                    Object target = BeanUtil.copyMapToNewBean((Map)source, clazz, option -> {
                        option.converter((Converter)new EsTimestampConverter(), (CharSequence[])timestampFields).excludeWhitespace();
                        option.exclude(new CharSequence[]{"accessResultData"});
                    });
                    Map data = (Map)source.get("accessResultData");
                    if (data != null) {
                        ((EsAccessResult)((Object)target)).setAccessResultData((AccessResultData<String>)new EsAccessResultData(data));
                    }
                    this.setId(target, searchHit.getId());
                    targetList.add(target);
                }
            }
            catch (Exception e) {
                throw new EsAccessException("response: " + response, e);
            }
        }
        return targetList;
    }

    protected boolean delete(String sessionId, String url) {
        String id = this.getId(sessionId, url);
        try {
            DeleteResponse response = (DeleteResponse)this.getClient().get(c -> ((DeleteRequestBuilder)((DeleteRequestBuilder)c.prepareDelete().setIndex(this.index)).setId(id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute());
            return response.getResult() == DocWriteResponse.Result.DELETED;
        }
        catch (Exception e) {
            throw new EsAccessException("Failed to delete " + sessionId + ":" + url, e);
        }
    }

    protected void deleteBySessionId(String sessionId) {
        this.delete(builder -> builder.setQuery((QueryBuilder)QueryBuilders.termQuery((String)SESSION_ID, (String)sessionId)));
    }

    public void deleteAll() {
        this.delete(builder -> builder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Consumer<SearchRequestBuilder> callback) {
        SearchResponse response = (SearchResponse)this.getClient().get(c -> {
            SearchRequestBuilder builder = c.prepareSearch(this.index).setScroll(new TimeValue((long)this.scrollTimeout)).setSize(this.scrollSize);
            callback.accept(builder);
            return builder.execute();
        });
        String scrollId = response.getScrollId();
        try {
            while (scrollId != null) {
                SearchHits searchHits = response.getHits();
                if (searchHits.getHits().length == 0) {
                    break;
                }
                BulkResponse bulkResponse = (BulkResponse)this.getClient().get(c -> {
                    BulkRequestBuilder bulkBuilder = c.prepareBulk();
                    for (SearchHit searchHit : searchHits) {
                        bulkBuilder.add(((DeleteRequestBuilder)c.prepareDelete().setIndex(this.index)).setId(searchHit.getId()));
                    }
                    return bulkBuilder.execute();
                });
                if (bulkResponse.hasFailures()) {
                    throw new EsAccessException(bulkResponse.buildFailureMessage());
                }
                String sid = scrollId;
                response = (SearchResponse)this.getClient().get(c -> c.prepareSearchScroll(sid).setScroll(new TimeValue((long)this.scrollTimeout)).execute());
                if (!scrollId.equals(response.getScrollId())) {
                    this.getClient().clearScroll(scrollId);
                }
                scrollId = response.getScrollId();
            }
        }
        finally {
            this.getClient().clearScroll(scrollId);
        }
        this.refresh();
    }

    private String getId(String sessionId, String url) {
        String id = sessionId + ID_SEPARATOR + new String(Base64.getUrlEncoder().withoutPadding().encode(url.getBytes(UTF_8)), UTF_8);
        if (id.length() <= this.idPrefixLength) {
            return id;
        }
        return id.substring(0, this.idPrefixLength) + MessageDigestUtil.digest((String)"SHA-256", (String)id.substring(this.idPrefixLength));
    }

    private String getUrl(Object target) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        PropertyDesc sessionIdProp = beanDesc.getPropertyDesc(URL);
        Object sessionId = sessionIdProp.getValue(target);
        return sessionId == null ? null : sessionId.toString();
    }

    private String getSessionId(Object target) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        PropertyDesc sessionIdProp = beanDesc.getPropertyDesc(SESSION_ID);
        Object sessionId = sessionIdProp.getValue(target);
        return sessionId == null ? null : sessionId.toString();
    }

    protected void setId(Object target, String id) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
        PropertyDesc idProp = beanDesc.getPropertyDesc(ID);
        idProp.setValue(target, (Object)id);
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public int getScrollTimeout() {
        return this.scrollTimeout;
    }

    public void setScrollTimeout(int scrollTimeout) {
        this.scrollTimeout = scrollTimeout;
    }

    public int getScrollSize() {
        return this.scrollSize;
    }

    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    public int getBulkBufferSize() {
        return this.bulkBufferSize;
    }

    public void setBulkBufferSize(int bulkBufferSize) {
        this.bulkBufferSize = bulkBufferSize;
    }

    public void setNumberOfShards(int numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public void setNumberOfReplicas(int numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    public void setIdPrefixLength(int idPrefixLength) {
        this.idPrefixLength = idPrefixLength;
    }

    protected static class EsTimestampConverter
    implements Converter {
        public static final DateTimeFormatter DEFAULT_DATE_PRINTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);

        protected EsTimestampConverter() {
        }

        public String getAsString(Object value) {
            if (value instanceof Date) {
                return DEFAULT_DATE_PRINTER.print(((Date)value).getTime());
            }
            return null;
        }

        public Object getAsObject(String value) {
            if (StringUtil.isEmpty((String)value)) {
                return null;
            }
            return new Timestamp(DEFAULT_DATE_PRINTER.parseMillis(value));
        }

        public boolean isTarget(Class clazz) {
            return clazz == Date.class;
        }
    }
}

