/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.apache.lucene.search.TotalHits;
import org.codelibs.core.beans.Converter;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.fess.crawler.entity.AccessResult;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.EsAccessResult;
import org.codelibs.fess.crawler.entity.EsAccessResultData;
import org.codelibs.fess.crawler.exception.EsAccessException;
import org.codelibs.fess.crawler.service.DataService;
import org.codelibs.fess.crawler.service.impl.AbstractCrawlerService;
import org.codelibs.fess.crawler.util.AccessResultCallback;
import org.codelibs.fess.crawler.util.EsCrawlerConfig;
import org.codelibs.fess.crawler.util.EsResultList;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;

public class EsDataService
extends AbstractCrawlerService
implements DataService<EsAccessResult> {
    public EsDataService(EsCrawlerConfig crawlerConfig) {
        this.index = crawlerConfig.getDataIndex();
        this.setNumberOfShards(crawlerConfig.getDataShards());
        this.setNumberOfReplicas(crawlerConfig.getDataReplicas());
    }

    public EsDataService(String name, String type) {
        this.index = name + "." + type;
    }

    @PostConstruct
    public void init() {
        this.fesenClient.addOnConnectListener(() -> this.createMapping("data"));
    }

    public void store(EsAccessResult accessResult) {
        super.insert((Object)accessResult, accessResult.getId() == null ? DocWriteRequest.OpType.CREATE : DocWriteRequest.OpType.INDEX);
    }

    public void update(EsAccessResult accessResult) {
        super.insert((Object)accessResult, DocWriteRequest.OpType.INDEX);
    }

    public void update(List<EsAccessResult> accessResultList) {
        this.insertAll(accessResultList, DocWriteRequest.OpType.INDEX);
    }

    public int getCount(String sessionId) {
        return this.getCount((SearchRequestBuilder builder) -> builder.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"sessionId", (String)sessionId)));
    }

    public void delete(String sessionId) {
        this.deleteBySessionId(sessionId);
    }

    public EsAccessResult getAccessResult(String sessionId, String url) {
        return this.get(EsAccessResult.class, sessionId, url);
    }

    public List<EsAccessResult> getAccessResultList(String url, boolean hasData) {
        return this.getList(EsAccessResult.class, builder -> builder.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"url", (String)url)));
    }

    public List<EsAccessResult> getAccessResultList(Consumer<SearchRequestBuilder> callback) {
        SearchResponse response = (SearchResponse)this.getClient().get(c -> {
            SearchRequestBuilder builder = c.prepareSearch(this.index);
            callback.accept(builder);
            builder.setFetchSource(new String[]{"parentUrl", "method", "mimeType", "sessionId", "url", "executionTime", "createTime", "contentLength", "lastModified", "ruleId", "httpStatusCode", "status"}, null);
            return builder.execute();
        });
        EsResultList<EsAccessResult> targetList = new EsResultList<EsAccessResult>();
        SearchHits hits = response.getHits();
        TotalHits totalHits = hits.getTotalHits();
        long totalHitsValue = totalHits != null ? totalHits.value : 0L;
        targetList.setTotalHits(totalHitsValue);
        targetList.setTookInMillis(response.getTook().getMillis());
        if (totalHitsValue != 0L) {
            try {
                for (SearchHit searchHit : hits.getHits()) {
                    EsAccessResult target = new EsAccessResult();
                    Map fields = searchHit.getSourceAsMap();
                    target.setParentUrl(this.getFieldValue(fields.get("parentUrl"), String.class));
                    target.setMethod(this.getFieldValue(fields.get("method"), String.class));
                    target.setMimeType(this.getFieldValue(fields.get("mimeType"), String.class));
                    target.setSessionId(this.getFieldValue(fields.get("sessionId"), String.class));
                    target.setUrl(this.getFieldValue(fields.get("url"), String.class));
                    target.setExecutionTime(this.getFieldValue(fields.get("executionTime"), Integer.class));
                    target.setContentLength(this.getFieldValue(fields.get("contentLength"), Long.class));
                    target.setRuleId(this.getFieldValue(fields.get("ruleId"), String.class));
                    target.setHttpStatusCode(this.getFieldValue(fields.get("httpStatusCode"), Integer.class));
                    target.setStatus(this.getFieldValue(fields.get("status"), Integer.class));
                    target.setCreateTime(this.getFieldValue(fields.get("createTime"), Long.class));
                    target.setLastModified(this.getFieldValue(fields.get("lastModified"), Long.class));
                    this.setId((Object)target, searchHit.getId());
                    targetList.add(target);
                }
            }
            catch (Exception e) {
                throw new EsAccessException("response: " + response, e);
            }
        }
        return targetList;
    }

    private <T> T getFieldValue(Object field, Class<T> clazz) {
        if (field == null) {
            return null;
        }
        if (clazz.equals(Integer.class)) {
            Number value = (Number)field;
            return (T)Integer.valueOf(value.intValue());
        }
        if (clazz.equals(Long.class)) {
            Number value = (Number)field;
            return (T)Long.valueOf(value.longValue());
        }
        return (T)field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(String sessionId, AccessResultCallback<EsAccessResult> callback) {
        SearchResponse response = (SearchResponse)this.getClient().get(c -> c.prepareSearch(this.index).setScroll(new TimeValue((long)this.scrollTimeout)).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"sessionId", (String)sessionId))).setSize(this.scrollSize).execute());
        String scrollId = response.getScrollId();
        try {
            while (scrollId != null) {
                SearchHits searchHits = response.getHits();
                if (searchHits.getHits().length == 0) {
                    break;
                }
                for (SearchHit searchHit : searchHits) {
                    Map source = searchHit.getSourceAsMap();
                    EsAccessResult accessResult = (EsAccessResult)((Object)BeanUtil.copyMapToNewBean((Map)source, EsAccessResult.class, option -> {
                        option.converter((Converter)new AbstractCrawlerService.EsTimestampConverter(), (CharSequence[])timestampFields).excludeWhitespace();
                        option.exclude(new CharSequence[]{"accessResultData"});
                    }));
                    Map data = (Map)source.get("accessResultData");
                    if (data != null) {
                        accessResult.setAccessResultData((AccessResultData<String>)new EsAccessResultData(data));
                    }
                    callback.iterate((AccessResult)accessResult);
                }
                String sid = scrollId;
                response = (SearchResponse)this.getClient().get(c -> c.prepareSearchScroll(sid).setScroll(new TimeValue((long)this.scrollTimeout)).execute());
                if (!scrollId.equals(response.getScrollId())) {
                    this.getClient().clearScroll(scrollId);
                }
                scrollId = response.getScrollId();
            }
        }
        finally {
            this.getClient().clearScroll(scrollId);
        }
    }
}

