/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.http;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Download;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.Response;
import com.microsoft.playwright.options.Cookie;
import com.microsoft.playwright.options.LoadState;
import com.microsoft.playwright.options.Proxy;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.Tuple4;
import org.codelibs.core.stream.StreamUtil;
import org.codelibs.fess.crawler.CrawlerContext;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.http.Authentication;
import org.codelibs.fess.crawler.client.http.HcHttpClient;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.filter.UrlFilter;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.codelibs.fess.crawler.util.CrawlingParameterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaywrightClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(PlaywrightClient.class);
    protected static final String RENDERED_STATE = "renderedState";
    protected static final String IGNORE_HTTPS_ERRORS_PROPERTY = "ignoreHttpsErrors";
    protected static final String PROXY_BYPASS_PROPERTY = "proxyBypass";
    protected static final String LAST_MODIFIED_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    protected Map<String, String> options = new HashMap<String, String>();
    protected String browserName = "chromium";
    protected BrowserType.LaunchOptions launchOptions;
    protected Browser.NewContextOptions newContextOptions = new Browser.NewContextOptions();
    protected int downloadTimeout = 15;
    protected int closeTimeout = 15;
    protected LoadState renderedState = LoadState.NETWORKIDLE;
    protected Tuple4<Playwright, Browser, BrowserContext, Page> worker;
    @Resource
    protected CrawlerContainer crawlerContainer;

    public synchronized void init() {
        if (this.worker != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initiaizing Playwright...");
        }
        super.init();
        this.initNewContextOptions();
        String renderedStateParam = (String)this.getInitParameter(RENDERED_STATE, this.renderedState.name(), String.class);
        if (renderedStateParam != null) {
            this.renderedState = LoadState.valueOf((String)renderedStateParam);
        }
        Playwright playwright = null;
        Browser browser = null;
        BrowserContext browserContext = null;
        Page page = null;
        try {
            playwright = Playwright.create((Playwright.CreateOptions)new Playwright.CreateOptions().setEnv(this.options));
            browser = this.getBrowserType(playwright).launch(this.launchOptions);
            browserContext = this.createAuthenticatedContext(browser);
            page = browserContext.newPage();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to create Playwright instance.", (Throwable)e);
            }
            this.close(playwright, browser, browserContext, page);
            throw new CrawlerSystemException("Failed to create PlaywrightClient.", (Throwable)e);
        }
        this.worker = new Tuple4((Object)playwright, (Object)browser, (Object)browserContext, (Object)page);
    }

    public void close() {
        if (this.worker == null) {
            return;
        }
        try {
            this.close((Playwright)this.worker.getValue1(), (Browser)this.worker.getValue2(), (BrowserContext)this.worker.getValue3(), (Page)this.worker.getValue4());
        }
        finally {
            this.worker = null;
        }
    }

    protected void closeInBackground(Runnable closer) {
        CountDownLatch latch = new CountDownLatch(1);
        try {
            Thread thread = new Thread(() -> {
                try {
                    closer.run();
                }
                catch (Exception e) {
                    logger.warn("Failed to close the playwright instance.", (Throwable)e);
                }
                latch.countDown();
            }, "Playwright-Closer");
            thread.setDaemon(true);
            thread.start();
            if (!latch.await(this.closeTimeout, TimeUnit.SECONDS)) {
                logger.warn("The close process is timed out.");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted to wait a process.", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Failed to close the playwright instance.", (Throwable)e);
        }
    }

    protected void close(Playwright playwright, Browser browser, BrowserContext context, Page page) {
        this.closeInBackground(() -> {
            if (page != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Closing Page...");
                }
                page.close();
            }
        });
        this.closeInBackground(() -> {
            if (context != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Closing BrowserContext...");
                }
                context.close();
            }
        });
        this.closeInBackground(() -> {
            if (browser != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Closing Browser...");
                }
                browser.close();
            }
        });
        this.closeInBackground(() -> {
            if (playwright != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Closing Playwright...");
                }
                playwright.close();
            }
        });
    }

    protected BrowserType getBrowserType(Playwright playwright) {
        if (logger.isDebugEnabled()) {
            logger.debug("Create {}...", (Object)this.browserName);
        }
        return switch (this.browserName) {
            case "firefox" -> playwright.firefox();
            case "webkit" -> playwright.webkit();
            case "chromium" -> playwright.chromium();
            default -> throw new CrawlerSystemException("Unknown browser name: " + this.browserName);
        };
    }

    public void addOption(String key, String value) {
        this.options.put(key, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseData execute(RequestData request) {
        if (this.worker == null) {
            this.init();
        }
        String url = request.getUrl();
        Page page = (Page)this.worker.getValue4();
        AtomicReference responseRef = new AtomicReference();
        AtomicReference downloadRef = new AtomicReference();
        Page page2 = page;
        synchronized (page2) {
            try {
                page.onResponse(response -> {
                    if (responseRef.get() == null) {
                        responseRef.set(response);
                    }
                });
                page.onDownload(downloadRef::set);
                if (logger.isDebugEnabled()) {
                    logger.debug("Accessing {}", (Object)url);
                }
                Response response2 = page.navigate(url);
                page.waitForLoadState(this.renderedState);
                if (logger.isDebugEnabled()) {
                    logger.debug("Loaded: Base URL: {}, Response URL: {}", (Object)url, (Object)response2.url());
                }
                ResponseData responseData = this.createResponseData(page, request, response2, null);
                return responseData;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting for downloaded file: {}", (Object)e.getMessage());
                }
                for (int i = 0; i < this.downloadTimeout * 10 && (downloadRef.get() == null || responseRef.get() == null); ++i) {
                    page.waitForTimeout(100.0);
                }
                Response response3 = (Response)responseRef.get();
                Download download = (Download)downloadRef.get();
                if (response3 != null && download != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Downloaded:  URL: {}", (Object)response3.url());
                    }
                    ResponseData responseData2 = this.createResponseData(page, request, response3, download);
                    return responseData2;
                }
                throw new CrawlerSystemException("Failed to access " + request.getUrl(), (Throwable)e);
            }
            finally {
                this.resetPage(page);
            }
        }
    }

    protected void resetPage(Page page) {
        try {
            page.navigate("about:blank");
            page.waitForLoadState(LoadState.LOAD);
        }
        catch (Exception e) {
            logger.warn("Could not reset a page.", (Throwable)e);
        }
    }

    protected ResponseData createResponseData(Page page, RequestData request, Response response, Download download) {
        String url;
        ResponseData responseData = new ResponseData();
        String originalUrl = request.getUrl();
        if (!originalUrl.equals(url = response.url())) {
            UrlFilter urlFilter;
            CrawlerContext context = CrawlingParameterUtil.getCrawlerContext();
            if (context != null && (urlFilter = context.getUrlFilter()) != null && !urlFilter.match(url)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} is not a target url:", (Object)url);
                }
                throw new ChildUrlsException(Collections.emptySet(), "#crawledUrlNotTarget");
            }
            logger.info("Crawled URL: {} -> {}", (Object)originalUrl, (Object)url);
        }
        responseData.setUrl(url);
        responseData.setMethod(request.getMethod().name());
        String charSet = this.getCharSet(response);
        responseData.setCharSet(charSet);
        int statusCode = this.getStatusCode(response);
        responseData.setHttpStatusCode(statusCode);
        responseData.setLastModified(this.getLastModified(response));
        response.allHeaders().entrySet().forEach(e -> responseData.addMetaData((String)e.getKey(), e.getValue()));
        if (statusCode > 400) {
            responseData.setContentLength(0L);
            responseData.setResponseBody(new byte[0]);
            responseData.setMimeType(this.getContentType(response));
        } else if (download == null) {
            byte[] body = response.body();
            byte[] responseBody = this.getMimeTypeHelper().map(mimeTypeHelper -> {
                block13: {
                    String filename = this.getFilename(url);
                    try (ByteArrayInputStream in = new ByteArrayInputStream(body);){
                        String contentType = mimeTypeHelper.getContentType((InputStream)in, filename);
                        responseData.setMimeType(contentType);
                        if (logger.isDebugEnabled()) {
                            logger.debug("filename:{} content-type:{}", (Object)filename, (Object)contentType);
                        }
                        if (!"text/html".equals(contentType)) break block13;
                        try {
                            String content = page.content();
                            if (logger.isDebugEnabled()) {
                                logger.debug("html content: {}", (Object)content);
                            }
                            byte[] byArray = content.getBytes(charSet);
                            return byArray;
                        }
                        catch (Exception e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Could not get a content from page.", (Throwable)e);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Could not read from {}", (Object)url, (Object)e);
                    }
                }
                return body;
            }).orElse(body);
            responseData.setContentLength((long)responseBody.length);
            if (RequestData.Method.HEAD != request.getMethod()) {
                responseData.setResponseBody(responseBody);
            }
        } else {
            try {
                File tempFile = File.createTempFile("fess-crawler-playwright-", ".tmp");
                download.saveAs(tempFile.toPath());
                responseData.setContentLength(tempFile.length());
                this.getMimeTypeHelper().ifPresent(mimeTypeHelper -> {
                    String filename = this.getFilename(url);
                    try (FileInputStream in = new FileInputStream(tempFile);){
                        String contentType = mimeTypeHelper.getContentType((InputStream)in, filename);
                        responseData.setMimeType(contentType);
                        if (logger.isDebugEnabled()) {
                            logger.debug("filename:{} content-type:{}", (Object)filename, (Object)contentType);
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Could not read {}", (Object)tempFile.getAbsolutePath(), (Object)e);
                    }
                });
                responseData.setResponseBody(tempFile, true);
            }
            catch (IOException e2) {
                throw new IORuntimeException(e2);
            }
            finally {
                download.delete();
            }
        }
        return responseData;
    }

    protected String getFilename(String url) {
        if (StringUtil.isBlank((String)url)) {
            return null;
        }
        String[] values = StringUtils.splitPreserveAllTokens((String)url, (char)'/');
        String value = values[values.length - 1].split("#")[0].split("\\?")[0];
        if (StringUtil.isBlank((String)value)) {
            return "index.html";
        }
        return value;
    }

    protected Optional<MimeTypeHelper> getMimeTypeHelper() {
        return Optional.ofNullable((MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper"));
    }

    protected String getContentType(Response response) {
        String contentType = response.headerValue("content-type");
        if (StringUtil.isNotBlank((String)contentType)) {
            return contentType.split(";")[0].trim();
        }
        return "text/html";
    }

    protected Date getLastModified(Response response) {
        return this.parseDate(response.headerValue("last-modified"));
    }

    protected Date parseDate(String value) {
        if (StringUtil.isNotBlank((String)value)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(LAST_MODIFIED_FORMAT, Locale.ENGLISH);
                return dateFormat.parse(value);
            }
            catch (ParseException e) {
                logger.warn("Invalid format: " + value, (Throwable)e);
            }
        }
        return null;
    }

    protected int getStatusCode(Response response) {
        return response.status();
    }

    protected String getCharSet(Response response) {
        String[] result;
        String contentType = response.headerValue("content-type");
        if (StringUtil.isNotBlank((String)contentType) && (result = (String[])StreamUtil.split((String)contentType, (String)";").get(stream -> (String[])stream.map(s -> {
            String[] values = s.split("=");
            if (values.length == 2 && "charset".equalsIgnoreCase(values[0].trim())) {
                return values[1].trim();
            }
            return null;
        }).filter(StringUtil::isNotBlank).toArray(String[]::new))).length > 0) {
            return result[0];
        }
        return "UTF-8";
    }

    protected void initNewContextOptions() {
        if (this.newContextOptions == null) {
            this.newContextOptions = new Browser.NewContextOptions();
        }
        boolean ignoreHttpsErrors = (Boolean)this.getInitParameter(IGNORE_HTTPS_ERRORS_PROPERTY, false, Boolean.class);
        boolean ignoreSslCertificate = (Boolean)this.getInitParameter("ignoreSslCertificate", false, Boolean.class);
        if (ignoreHttpsErrors || ignoreSslCertificate) {
            this.newContextOptions.ignoreHTTPSErrors = true;
        }
        String proxyHost = (String)this.getInitParameter("proxyHost", null, String.class);
        Integer proxyPort = (Integer)this.getInitParameter("proxyPort", null, Integer.class);
        UsernamePasswordCredentials proxyCredentials = (UsernamePasswordCredentials)this.getInitParameter("proxyCredentials", null, UsernamePasswordCredentials.class);
        String proxyBypass = (String)this.getInitParameter(PROXY_BYPASS_PROPERTY, null, String.class);
        if (!StringUtils.isBlank((CharSequence)proxyHost)) {
            String proxyAddress = proxyPort == null ? proxyHost : proxyHost + ":" + proxyPort;
            Proxy proxy = new Proxy(proxyAddress);
            if (proxyCredentials != null) {
                proxy.setUsername(proxyCredentials.getUserName());
                proxy.setPassword(proxyCredentials.getPassword());
            }
            proxy.setBypass(proxyBypass);
            this.newContextOptions.setProxy(proxy);
        }
    }

    protected BrowserContext createAuthenticatedContext(Browser browser) {
        Authentication[] authentications = (Authentication[])this.getInitParameter("basicAuthentications", new Authentication[0], Authentication[].class);
        if (authentications.length == 0) {
            return browser.newContext(this.newContextOptions);
        }
        for (Authentication authentication : authentications) {
            if (StringUtils.equals((CharSequence)authentication.getAuthScheme().getSchemeName(), (CharSequence)"form")) continue;
            String username = authentication.getCredentials().getUserPrincipal().getName();
            String password = authentication.getCredentials().getPassword();
            this.newContextOptions.setHttpCredentials(username, password);
            break;
        }
        BrowserContext playwrightContext = browser.newContext(this.newContextOptions);
        try (HcHttpClient fessHttpClient = new HcHttpClient();){
            fessHttpClient.setInitParameterMap(this.initParamMap);
            fessHttpClient.init();
            List fessCookies = fessHttpClient.cookieStore.getCookies();
            List<Cookie> playwrightCookies = fessCookies.stream().map(apacheCookie -> {
                Cookie playwrightCookie = new Cookie(apacheCookie.getName(), apacheCookie.getValue());
                playwrightCookie.setDomain(apacheCookie.getDomain());
                playwrightCookie.setPath(apacheCookie.getPath());
                playwrightCookie.setSecure(apacheCookie.isSecure());
                Date cookieExpiryDate = apacheCookie.getExpiryDate();
                if (cookieExpiryDate != null) {
                    playwrightCookie.setExpires((double)cookieExpiryDate.getTime() / 1000.0);
                }
                return playwrightCookie;
            }).toList();
            playwrightContext.addCookies(playwrightCookies);
            BrowserContext browserContext = playwrightContext;
            return browserContext;
        }
    }

    public void setLaunchOptions(BrowserType.LaunchOptions launchOptions) {
        this.launchOptions = launchOptions;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public void setDownloadTimeout(int downloadTimeout) {
        this.downloadTimeout = downloadTimeout;
    }

    public void setRenderedState(LoadState loadState) {
        this.renderedState = loadState;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void setNewContextOptions(Browser.NewContextOptions newContextOptions) {
        this.newContextOptions = newContextOptions;
    }
}

