/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.http;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.pool2.ObjectPool;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.http.action.UrlAction;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverClient.class);
    @Resource
    protected ObjectPool<WebDriver> webDriverPool;
    protected Map<String, UrlAction> urlActionMap = new LinkedHashMap<String, UrlAction>();

    public void addUrlAction(UrlAction urlAction) {
        this.urlActionMap.put(urlAction.getName(), urlAction);
    }

    public ResponseData execute(RequestData request) {
        WebDriver webDriver = null;
        try {
            webDriver = (WebDriver)this.webDriverPool.borrowObject();
            Map<String, String> paramMap = null;
            String url = request.getUrl();
            String metaData = request.getMetaData();
            if (StringUtil.isNotBlank((String)metaData)) {
                paramMap = this.parseParamMap(metaData);
            }
            if (!url.equals(webDriver.getCurrentUrl())) {
                webDriver.get(url);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Base URL: " + url + "\nContent: " + webDriver.getPageSource());
            }
            if (paramMap != null) {
                String processorName = paramMap.get("urlaction");
                UrlAction urlAction = this.urlActionMap.get(processorName);
                if (urlAction == null) {
                    throw new CrawlerSystemException("Unknown processor: " + processorName);
                }
                urlAction.navigate(webDriver, paramMap);
            }
            String source = webDriver.getPageSource();
            ResponseData responseData = new ResponseData();
            responseData.setUrl(webDriver.getCurrentUrl());
            responseData.setMethod(request.getMethod().name());
            responseData.setContentLength((long)source.length());
            String charSet = this.getCharSet(webDriver);
            responseData.setCharSet(charSet);
            responseData.setHttpStatusCode(this.getStatusCode(webDriver));
            responseData.setLastModified(this.getLastModified(webDriver));
            responseData.setMimeType(this.getContentType(webDriver));
            responseData.setResponseBody(source.getBytes(charSet));
            for (UrlAction urlAction : this.urlActionMap.values()) {
                urlAction.collect(url, webDriver, responseData);
            }
            ResponseData responseData2 = responseData;
            return responseData2;
        }
        catch (Exception e) {
            throw new CrawlerSystemException("Failed to access " + request.getUrl(), (Throwable)e);
        }
        finally {
            if (webDriver != null) {
                try {
                    this.webDriverPool.returnObject((Object)webDriver);
                }
                catch (Exception e) {
                    logger.warn("Failed to return a returned object.", (Throwable)e);
                }
            }
        }
    }

    protected Map<String, String> parseParamMap(String paramStr) {
        String[] pairs;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String pair : pairs = paramStr.split("&")) {
            String[] values = pair.split("=");
            if (values.length <= 1) continue;
            paramMap.put(values[0], values[1]);
        }
        return paramMap;
    }

    private String getContentType(WebDriver wd) {
        JavascriptExecutor jsExecutor;
        Object ret;
        if (wd instanceof JavascriptExecutor && (ret = (jsExecutor = (JavascriptExecutor)wd).executeScript("return document.contentType;", new Object[0])) != null) {
            return ret.toString();
        }
        return "text/html";
    }

    private Date getLastModified(WebDriver wd) {
        JavascriptExecutor jsExecutor;
        Object ret;
        if (wd instanceof JavascriptExecutor && (ret = (jsExecutor = (JavascriptExecutor)wd).executeScript("return new Date(document.lastModified).getTime();", new Object[0])) != null) {
            try {
                return new Date(Long.parseLong(ret.toString()));
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid format: " + ret, (Throwable)e);
            }
        }
        return null;
    }

    private int getStatusCode(WebDriver wd) {
        return 200;
    }

    private String getCharSet(WebDriver wd) {
        JavascriptExecutor jsExecutor;
        Object ret;
        if (wd instanceof JavascriptExecutor && (ret = (jsExecutor = (JavascriptExecutor)wd).executeScript("return document.characterSet;", new Object[0])) != null) {
            return ret.toString();
        }
        return "UTF-8";
    }

    public ObjectPool<WebDriver> getWebDriverPool() {
        return this.webDriverPool;
    }

    public void setWebDriverPool(ObjectPool<WebDriver> webDriverPool) {
        this.webDriverPool = webDriverPool;
    }
}

