/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.http.webdriver;

import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.pool2.PooledObject;
import org.codelibs.fess.crawler.pool.CrawlerPooledObjectFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class CrawlerWebDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath,
HasInputDevices,
HasCapabilities,
TakesScreenshot {
    public Capabilities capabilities;
    protected WebDriver webDriver;
    public String phantomjsBinaryPath;
    public String phantomjsGhostdriverPath;
    public String[] phantomjsCliArgs;
    public String[] phantomjsGhostdriverCliArgs;
    public String webdriverChromeDriver;
    public URL remoteAddress;

    @PostConstruct
    public void phantomjs() {
        if (this.capabilities == null) {
            this.capabilities = DesiredCapabilities.phantomjs();
        }
        if (this.capabilities instanceof DesiredCapabilities) {
            String value;
            if (this.phantomjsBinaryPath == null) {
                this.phantomjsBinaryPath = System.getProperty("phantomjs.binary.path");
            }
            if (this.phantomjsBinaryPath != null) {
                ((DesiredCapabilities)this.capabilities).setCapability("phantomjs.binary.path", this.phantomjsBinaryPath);
            }
            if (this.phantomjsGhostdriverPath == null) {
                this.phantomjsGhostdriverPath = System.getProperty("phantomjs.ghostdriver.path");
            }
            if (this.phantomjsGhostdriverPath != null) {
                ((DesiredCapabilities)this.capabilities).setCapability("phantomjs.ghostdriver.path", this.phantomjsGhostdriverPath);
            }
            if (this.phantomjsCliArgs == null && (value = System.getProperty("phantomjs.cli.args")) != null) {
                this.phantomjsCliArgs = value.split(" ");
            }
            if (this.phantomjsCliArgs != null) {
                ((DesiredCapabilities)this.capabilities).setCapability("phantomjs.cli.args", (Object)this.phantomjsCliArgs);
            }
            if (this.phantomjsGhostdriverCliArgs == null && (value = System.getProperty("phantomjs.ghostdriver.cli.args")) != null) {
                this.phantomjsGhostdriverCliArgs = value.split(" ");
            }
            if (this.phantomjsGhostdriverCliArgs != null) {
                ((DesiredCapabilities)this.capabilities).setCapability("phantomjs.ghostdriver.cli.args", (Object)this.phantomjsGhostdriverCliArgs);
            }
        }
        this.webDriver = new PhantomJSDriver(this.capabilities);
    }

    public void chrome() {
        if (this.capabilities == null) {
            this.capabilities = DesiredCapabilities.chrome();
        }
        if (this.capabilities instanceof DesiredCapabilities && this.webdriverChromeDriver != null) {
            ((DesiredCapabilities)this.capabilities).setCapability("webdriver.chrome.driver", this.webdriverChromeDriver);
        }
        this.webDriver = new RemoteWebDriver(this.remoteAddress, (Capabilities)DesiredCapabilities.chrome());
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)((TakesScreenshot)this.webDriver).getScreenshotAs(target);
    }

    public Capabilities getCapabilities() {
        return ((HasCapabilities)this.webDriver).getCapabilities();
    }

    public Keyboard getKeyboard() {
        return ((HasInputDevices)this.webDriver).getKeyboard();
    }

    public Mouse getMouse() {
        return ((HasInputDevices)this.webDriver).getMouse();
    }

    public WebElement findElementByXPath(String using) {
        return ((FindsByXPath)this.webDriver).findElementByXPath(using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return ((FindsByXPath)this.webDriver).findElementsByXPath(using);
    }

    public WebElement findElementByTagName(String using) {
        return ((FindsByTagName)this.webDriver).findElementByTagName(using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return ((FindsByTagName)this.webDriver).findElementsByTagName(using);
    }

    public WebElement findElementByCssSelector(String using) {
        return ((FindsByCssSelector)this.webDriver).findElementByCssSelector(using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return ((FindsByCssSelector)this.webDriver).findElementsByCssSelector(using);
    }

    public WebElement findElementByName(String using) {
        return ((FindsByName)this.webDriver).findElementByName(using);
    }

    public List<WebElement> findElementsByName(String using) {
        return ((FindsByName)this.webDriver).findElementsByName(using);
    }

    public WebElement findElementByLinkText(String using) {
        return ((FindsByLinkText)this.webDriver).findElementByLinkText(using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return ((FindsByLinkText)this.webDriver).findElementsByLinkText(using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return ((FindsByLinkText)this.webDriver).findElementByPartialLinkText(using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return ((FindsByLinkText)this.webDriver).findElementsByPartialLinkText(using);
    }

    public WebElement findElementByClassName(String using) {
        return ((FindsByClassName)this.webDriver).findElementByClassName(using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return ((FindsByClassName)this.webDriver).findElementsByClassName(using);
    }

    public WebElement findElementById(String using) {
        return ((FindsById)this.webDriver).findElementById(using);
    }

    public List<WebElement> findElementsById(String using) {
        return ((FindsById)this.webDriver).findElementsById(using);
    }

    public Object executeScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.webDriver).executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.webDriver).executeAsyncScript(script, args);
    }

    public void get(String url) {
        this.webDriver.get(url);
    }

    public String getCurrentUrl() {
        return this.webDriver.getCurrentUrl();
    }

    public String getTitle() {
        return this.webDriver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.webDriver.findElements(by);
    }

    public WebElement findElement(By by) {
        return this.webDriver.findElement(by);
    }

    public String getPageSource() {
        return this.webDriver.getPageSource();
    }

    public void close() {
        this.webDriver.close();
    }

    public void quit() {
        this.webDriver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.webDriver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.webDriver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.webDriver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.webDriver.navigate();
    }

    public WebDriver.Options manage() {
        return this.webDriver.manage();
    }

    public static class OnDestroyListener
    implements CrawlerPooledObjectFactory.OnDestroyListener<CrawlerWebDriver> {
        public void onDestroy(PooledObject<CrawlerWebDriver> p) {
            CrawlerWebDriver driver = (CrawlerWebDriver)p.getObject();
            driver.quit();
        }
    }
}

