/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client;

import java.util.concurrent.atomic.AtomicBoolean;
import org.codelibs.core.timer.TimeoutTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTimeoutTarget
implements TimeoutTarget {
    private static final Logger logger = LoggerFactory.getLogger(AccessTimeoutTarget.class);
    private static final int MAX_LOOP_COUNT = 10;
    protected Thread runningThread;
    protected AtomicBoolean running = new AtomicBoolean();

    public AccessTimeoutTarget(Thread thread) {
        this.runningThread = thread;
        this.running.set(true);
    }

    public void expired() {
        for (int count = 0; this.running.get() && count < 10; ++count) {
            if (logger.isDebugEnabled()) {
                logger.debug("Interrupt " + this.runningThread);
            }
            this.runningThread.interrupt();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        this.running.set(false);
    }
}

