/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.client.CrawlerClient;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;

public class CrawlerClientFactory {
    protected Map<Pattern, CrawlerClient> clientMap = new LinkedHashMap<Pattern, CrawlerClient>();

    public void addClient(String regex, CrawlerClient client) {
        if (StringUtil.isBlank((String)regex)) {
            throw new CrawlerSystemException("A regular expression is null.");
        }
        if (client == null) {
            throw new CrawlerSystemException("CrawlerClient is null.");
        }
        this.clientMap.put(Pattern.compile(regex), client);
    }

    public void addClient(String regex, CrawlerClient client, int pos) {
        if (StringUtil.isBlank((String)regex)) {
            throw new CrawlerSystemException("A regular expression is null.");
        }
        if (client == null) {
            throw new CrawlerSystemException("CrawlerClient is null.");
        }
        int current = 0;
        boolean added = false;
        LinkedHashMap<Pattern, CrawlerClient> newClientMap = new LinkedHashMap<Pattern, CrawlerClient>();
        for (Map.Entry<Pattern, CrawlerClient> entry : this.clientMap.entrySet()) {
            if (pos == current) {
                newClientMap.put(Pattern.compile(regex), client);
                added = true;
            }
            newClientMap.put(entry.getKey(), entry.getValue());
            ++current;
        }
        if (!added) {
            newClientMap.put(Pattern.compile(regex), client);
        }
        this.clientMap = newClientMap;
    }

    public void addClient(List<String> regexList, CrawlerClient client) {
        if (regexList == null || regexList.isEmpty()) {
            throw new CrawlerSystemException("A regular expression list is null or empty.");
        }
        if (client == null) {
            throw new CrawlerSystemException("CrawlerClient is null.");
        }
        for (String regex : regexList) {
            if (!StringUtil.isNotBlank((String)regex)) continue;
            this.clientMap.put(Pattern.compile(regex), client);
        }
    }

    public CrawlerClient getClient(String url) {
        if (StringUtil.isBlank((String)url)) {
            return null;
        }
        for (Map.Entry<Pattern, CrawlerClient> entry : this.clientMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(url);
            if (!matcher.matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setInitParameterMap(Map<String, Object> params) {
        if (params != null) {
            for (CrawlerClient client : this.clientMap.values()) {
                client.setInitParameterMap(params);
            }
        }
    }

    public void setClientMap(Map<Pattern, CrawlerClient> clientMap) {
        this.clientMap = clientMap;
    }
}

