/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.fs;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.codelibs.core.io.InputStreamUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.builder.RequestDataBuilder;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemClient.class);
    protected String charset = "UTF-8";
    @Resource
    protected CrawlerContainer crawlerContainer;
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    protected AtomicBoolean isInit = new AtomicBoolean(false);

    @Override
    public ResponseData doGet(String uri) {
        return this.processRequest(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData processRequest(String uri, boolean includeContent) {
        if (!this.isInit.get()) {
            AtomicBoolean atomicBoolean = this.isInit;
            synchronized (atomicBoolean) {
                if (!this.isInit.get()) {
                    this.init();
                    this.isInit.set(true);
                }
            }
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.getResponseData(uri, includeContent);
            return responseData;
        }
        finally {
            if (this.accessTimeout != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData;
        block42: {
            responseData = new ResponseData();
            try {
                responseData.setMethod("GET");
                String filePath = this.preprocessUri(uri);
                responseData.setUrl(filePath);
                File file = null;
                try {
                    file = new File(new URI(filePath));
                }
                catch (URISyntaxException e) {
                    logger.warn("Could not parse url: " + filePath, (Throwable)e);
                }
                if (file == null) {
                    responseData.setHttpStatusCode(404);
                    responseData.setCharSet(this.charset);
                    responseData.setContentLength(0L);
                    break block42;
                }
                if (file.isFile()) {
                    responseData.setContentLength(file.length());
                    this.checkMaxContentLength(responseData);
                    responseData.setHttpStatusCode(200);
                    responseData.setCharSet(this.geCharSet(file));
                    responseData.setLastModified(new Date(file.lastModified()));
                    if (file.canRead()) {
                        Throwable throwable;
                        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper");
                        try {
                            throwable = null;
                            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                                responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)is, file.getName()));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Exception e) {
                            responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                        }
                        if (this.contentLengthHelper != null) {
                            long maxLength = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                            if (responseData.getContentLength() > maxLength) {
                                throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + maxLength + " byte. The url is " + filePath);
                            }
                        }
                        if (!includeContent) break block42;
                        if (file.length() < this.maxCachedContentSize) {
                            try {
                                throwable = null;
                                try (BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(file));){
                                    responseData.setResponseBody(InputStreamUtil.getBytes((InputStream)contentStream));
                                    break block42;
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                            }
                            catch (Exception e) {
                                logger.warn("I/O Exception.", (Throwable)e);
                                responseData.setHttpStatusCode(500);
                            }
                            break block42;
                        }
                        responseData.setResponseBody(file, false);
                        break block42;
                    }
                    responseData.setHttpStatusCode(403);
                    responseData.setMimeType("application/octet-stream");
                    break block42;
                }
                if (file.isDirectory()) {
                    File[] files;
                    HashSet<RequestData> requestDataSet = new HashSet<RequestData>();
                    if (includeContent && (files = file.listFiles()) != null) {
                        for (File f : files) {
                            String chileUri = f.toURI().toASCIIString();
                            requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                        }
                    }
                    throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData(String, boolean)");
                }
                responseData.setHttpStatusCode(404);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
            }
            catch (CrawlerSystemException e) {
                IOUtils.closeQuietly((Closeable)responseData);
                throw e;
            }
            catch (Exception e) {
                IOUtils.closeQuietly((Closeable)responseData);
                throw new CrawlingAccessException("Could not access " + uri, e);
            }
        }
        return responseData;
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new CrawlerSystemException("The uri is empty.");
        }
        String filePath = uri;
        if (!filePath.startsWith("file:")) {
            filePath = "file://" + filePath;
        }
        StringBuilder buf = new StringBuilder(filePath.length() + 100);
        try {
            for (char c : filePath.toCharArray()) {
                if (c == ' ') {
                    buf.append("%20");
                    continue;
                }
                String str = String.valueOf(c);
                if (StringUtil.isAsciiPrintable((CharSequence)str)) {
                    buf.append(c);
                    continue;
                }
                buf.append(URLEncoder.encode(str, this.charset));
            }
        }
        catch (UnsupportedEncodingException e) {
            return filePath;
        }
        return buf.toString();
    }

    protected String geCharSet(File file) {
        return this.charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.processRequest(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }
}

