/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilters;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.io.InputStreamUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.builder.RequestDataBuilder;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.client.ftp.FtpAuthentication;
import org.codelibs.fess.crawler.client.ftp.FtpAuthenticationHolder;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.exception.CrawlerLoginFailureException;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(FtpClient.class);
    public static final String FTP_AUTHENTICATIONS_PROPERTY = "ftpAuthentications";
    protected String charset = "UTF-8";
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    @Resource
    protected CrawlerContainer crawlerContainer;
    public volatile FtpAuthenticationHolder ftpAuthenticationHolder;
    private FTPClientConfig ftpClientConfig;
    private final Queue<FTPClient> ftpClientQueue = new ConcurrentLinkedQueue<FTPClient>();
    private String activeExternalHost;
    private int activeMinPort;
    private int activeMaxPort;
    private boolean autodetectEncoding;
    private int connectTimeout;
    private int dataTimeout;
    private String controlEncoding;
    private int bufferSize;
    private String passiveLocalHost;
    private boolean passiveNatWorkaround;
    private String reportActiveExternalHost;
    private boolean useEPSVwithIPv4;

    @Override
    public synchronized void init() {
        if (this.ftpAuthenticationHolder != null) {
            return;
        }
        super.init();
        String systemKey = this.getInitParameter("ftpConfigSystemKey", "UNIX", String.class);
        this.ftpClientConfig = new FTPClientConfig(systemKey);
        String serverLanguageCode = this.getInitParameter("ftpConfigServerLanguageCode", "en", String.class);
        this.ftpClientConfig.setServerLanguageCode(serverLanguageCode);
        String serverTimeZoneId = this.getInitParameter("ftpConfigServerTimeZoneId", null, String.class);
        if (serverTimeZoneId != null) {
            this.ftpClientConfig.setServerTimeZoneId(serverTimeZoneId);
        }
        this.activeExternalHost = this.getInitParameter("activeExternalHost", null, String.class);
        this.activeMinPort = this.getInitParameter("activeMinPort", -1, Integer.class);
        this.activeMaxPort = this.getInitParameter("activeMaxPort", -1, Integer.class);
        this.autodetectEncoding = this.getInitParameter("autodetectEncoding", true, Boolean.class);
        this.connectTimeout = this.getInitParameter("connectTimeout", 0, Integer.class);
        this.dataTimeout = this.getInitParameter("dataTimeout", -1, Integer.class);
        this.controlEncoding = this.getInitParameter("controlEncoding", "UTF-8", String.class);
        this.bufferSize = this.getInitParameter("bufferSize", 0, Integer.class);
        this.passiveLocalHost = this.getInitParameter("passiveLocalHost", null, String.class);
        this.passiveNatWorkaround = this.getInitParameter("passiveNatWorkaround", true, Boolean.class);
        this.reportActiveExternalHost = this.getInitParameter("reportActiveExternalHost", null, String.class);
        this.useEPSVwithIPv4 = this.getInitParameter("useEPSVwithIPv4", false, Boolean.class);
        FtpAuthenticationHolder holder = new FtpAuthenticationHolder();
        FtpAuthentication[] ftpAuthentications = this.getInitParameter(FTP_AUTHENTICATIONS_PROPERTY, new FtpAuthentication[0], FtpAuthentication[].class);
        if (ftpAuthentications != null) {
            for (FtpAuthentication ftpAuthentication : ftpAuthentications) {
                holder.add(ftpAuthentication);
            }
        }
        this.ftpAuthenticationHolder = holder;
    }

    @PreDestroy
    public void destroy() {
        this.ftpAuthenticationHolder = null;
        for (FTPClient ftpClient : this.ftpClientQueue) {
            try {
                ftpClient.disconnect();
            }
            catch (IOException e) {
                logger.debug("Failed to disconnect FTPClient.", (Throwable)e);
            }
        }
    }

    @Override
    public ResponseData doGet(String uri) {
        return this.processRequest(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData processRequest(String uri, boolean includeContent) {
        if (this.ftpAuthenticationHolder == null) {
            this.init();
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.getResponseData(uri, includeContent);
            return responseData;
        }
        finally {
            if (this.accessTimeout != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData = new ResponseData();
        FTPClient client = null;
        try {
            responseData.setMethod("GET");
            FtpInfo ftpInfo = new FtpInfo(uri);
            responseData.setUrl(ftpInfo.toUrl());
            client = this.getClient(ftpInfo);
            FTPFile file = null;
            client.changeWorkingDirectory(ftpInfo.getParent());
            this.validateRequest(client);
            if (ftpInfo.getName() == null) {
                HashSet<RequestData> requestDataSet = new HashSet<RequestData>();
                if (includeContent) {
                    try {
                        void var11_25;
                        FTPFile[] files = client.listFiles(ftpInfo.getParent(), FTPFileFilters.NON_NULL);
                        this.validateRequest(client);
                        FTPFile[] fTPFileArray = files;
                        int n = fTPFileArray.length;
                        boolean bl = false;
                        while (var11_25 < n) {
                            FTPFile f = fTPFileArray[var11_25];
                            String chileUri = ftpInfo.toUrl(f.getName());
                            requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                            ++var11_25;
                        }
                    }
                    catch (IOException e) {
                        throw new CrawlingAccessException("Could not access " + uri, e);
                    }
                }
                this.ftpClientQueue.offer(client);
                throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData(String, boolean)");
            }
            FTPFile[] files = client.listFiles(null, FTPFileFilters.NON_NULL);
            this.validateRequest(client);
            for (FTPFile fTPFile : files) {
                if (!ftpInfo.getName().equals(fTPFile.getName())) continue;
                file = fTPFile;
                break;
            }
            if (file == null) {
                responseData.setHttpStatusCode(404);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
            } else if (file.isFile()) {
                responseData.setHttpStatusCode(200);
                responseData.setCharSet("UTF-8");
                responseData.setLastModified(file.getTimestamp().getTime());
                responseData.setContentLength(file.getSize());
                this.checkMaxContentLength(responseData);
                if (includeContent) {
                    File tempFile = null;
                    File outputFile = null;
                    try {
                        Throwable throwable;
                        tempFile = File.createTempFile("ftp-", ".tmp");
                        Throwable throwable2 = null;
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
                            if (!client.retrieveFile(ftpInfo.getName(), (OutputStream)out)) {
                                throw new CrawlingAccessException("Failed to retrieve: " + ftpInfo.toUrl());
                            }
                        }
                        catch (Throwable throwable3) {
                            Throwable throwable4 = throwable3;
                            throw throwable3;
                        }
                        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper");
                        try {
                            throwable = null;
                            try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                                responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)fileInputStream, file.getName()));
                            }
                            catch (Throwable chileUri) {
                                throwable = chileUri;
                                throw chileUri;
                            }
                        }
                        catch (Exception exception) {
                            responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                        }
                        if (this.contentLengthHelper != null) {
                            long l = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                            if (responseData.getContentLength() > l) {
                                throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + l + " byte. The url is " + uri);
                            }
                        }
                        responseData.setCharSet(this.geCharSet(tempFile));
                        if (tempFile.length() < this.maxCachedContentSize) {
                            throwable = null;
                            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(tempFile));){
                                responseData.setResponseBody(InputStreamUtil.getBytes((InputStream)bufferedInputStream));
                            }
                            catch (Throwable chileUri) {
                                throwable = chileUri;
                                throw chileUri;
                            }
                        }
                        outputFile = File.createTempFile("crawler-FileSystemClient-", ".out");
                        CopyUtil.copy((File)tempFile, (File)outputFile);
                        responseData.setResponseBody(outputFile, true);
                    }
                    catch (Exception e) {
                        logger.warn("I/O Exception.", (Throwable)e);
                        responseData.setHttpStatusCode(500);
                    }
                    finally {
                        if (tempFile != null && !tempFile.delete()) {
                            logger.warn("Could not delete " + tempFile.getAbsolutePath());
                        }
                        if (outputFile != null && !outputFile.delete()) {
                            logger.warn("Could not delete " + outputFile.getAbsolutePath());
                        }
                    }
                }
            } else {
                if (file.isDirectory()) {
                    HashSet<RequestData> requestDataSet = new HashSet<RequestData>();
                    if (includeContent) {
                        try {
                            FTPFile[] ftpFiles = client.listFiles(ftpInfo.getName(), FTPFileFilters.NON_NULL);
                            this.validateRequest(client);
                            for (FTPFile f : ftpFiles) {
                                String chileUri = ftpInfo.toUrl(f.getName());
                                requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                            }
                        }
                        catch (IOException e) {
                            throw new CrawlingAccessException("Could not access " + uri, e);
                        }
                    }
                    this.ftpClientQueue.offer(client);
                    throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData(String, boolean)");
                }
                responseData.setHttpStatusCode(404);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
            }
            this.ftpClientQueue.offer(client);
        }
        catch (CrawlerSystemException e) {
            IOUtils.closeQuietly((Closeable)responseData);
            throw e;
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)responseData);
            throw new CrawlingAccessException("Could not access " + uri, e);
        }
        return responseData;
    }

    private void validateRequest(FTPClient client) {
        int replyCode = client.getReplyCode();
        if (replyCode >= 200 && replyCode < 300) {
            return;
        }
        throw new CrawlingAccessException("Failed FTP request: " + client.getReplyString().trim());
    }

    protected String geCharSet(File file) {
        return this.charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.processRequest(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }

    protected FTPClient getClient(FtpInfo info) throws IOException {
        FTPClient ftpClient = this.ftpClientQueue.poll();
        if (ftpClient != null) {
            if (ftpClient.isAvailable()) {
                return ftpClient;
            }
            try {
                ftpClient.disconnect();
            }
            catch (Exception e) {
                logger.debug("Failed to disconnect " + info.toUrl(), (Throwable)e);
            }
        }
        try {
            ftpClient = new FTPClient();
            if (this.activeExternalHost != null) {
                ftpClient.setActiveExternalIPAddress(this.activeExternalHost);
            }
            if (this.passiveLocalHost != null) {
                ftpClient.setPassiveLocalIPAddress(this.passiveLocalHost);
            }
            if (this.reportActiveExternalHost != null) {
                ftpClient.setReportActiveExternalIPAddress(this.reportActiveExternalHost);
            }
            if (this.activeMinPort != -1 && this.activeMaxPort != -1) {
                ftpClient.setActivePortRange(this.activeMinPort, this.activeMaxPort);
            }
            ftpClient.setAutodetectUTF8(this.autodetectEncoding);
            ftpClient.setConnectTimeout(this.connectTimeout);
            ftpClient.setDataTimeout(this.dataTimeout);
            ftpClient.setControlEncoding(this.controlEncoding);
            ftpClient.setBufferSize(this.bufferSize);
            ftpClient.setPassiveNatWorkaround(this.passiveNatWorkaround);
            ftpClient.setUseEPSVwithIPv4(this.useEPSVwithIPv4);
            ftpClient.configure(this.ftpClientConfig);
            ftpClient.connect(info.getHost(), info.getPort());
            this.validateRequest(ftpClient);
            FtpAuthentication auth = this.ftpAuthenticationHolder.get(info.toUrl());
            if (auth != null && !ftpClient.login(auth.getUsername(), auth.getPassword())) {
                throw new CrawlerLoginFailureException("Login Failure: " + auth.getUsername() + " for " + info.toUrl());
            }
            ftpClient.setFileType(2);
            return ftpClient;
        }
        catch (IOException e) {
            if (ftpClient != null) {
                try {
                    ftpClient.disconnect();
                }
                catch (Exception e1) {
                    logger.debug("Failed to disconnect " + info.toUrl(), (Throwable)e);
                }
            }
            throw e;
        }
    }

    public String getActiveExternalHost() {
        return this.activeExternalHost;
    }

    public void setActiveExternalHost(String activeExternalHost) {
        this.activeExternalHost = activeExternalHost;
    }

    public int getActiveMinPort() {
        return this.activeMinPort;
    }

    public void setActiveMinPort(int activeMinPort) {
        this.activeMinPort = activeMinPort;
    }

    public int getActiveMaxPort() {
        return this.activeMaxPort;
    }

    public void setActiveMaxPort(int activeMaxPort) {
        this.activeMaxPort = activeMaxPort;
    }

    public boolean isAutodetectEncoding() {
        return this.autodetectEncoding;
    }

    public void setAutodetectEncoding(boolean autodetectEncoding) {
        this.autodetectEncoding = autodetectEncoding;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getDataTimeout() {
        return this.dataTimeout;
    }

    public void setDataTimeout(int dataTimeout) {
        this.dataTimeout = dataTimeout;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String controlEncoding) {
        this.controlEncoding = controlEncoding;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getPassiveLocalHost() {
        return this.passiveLocalHost;
    }

    public void setPassiveLocalHost(String passiveLocalHost) {
        this.passiveLocalHost = passiveLocalHost;
    }

    public boolean isPassiveNatWorkaround() {
        return this.passiveNatWorkaround;
    }

    public void setPassiveNatWorkaround(boolean passiveNatWorkaround) {
        this.passiveNatWorkaround = passiveNatWorkaround;
    }

    public String getReportActiveExternalHost() {
        return this.reportActiveExternalHost;
    }

    public void setReportActiveExternalHost(String reportActiveExternalHost) {
        this.reportActiveExternalHost = reportActiveExternalHost;
    }

    public boolean isUseEPSVwithIPv4() {
        return this.useEPSVwithIPv4;
    }

    public void setUseEPSVwithIPv4(boolean useEPSVwithIPv4) {
        this.useEPSVwithIPv4 = useEPSVwithIPv4;
    }

    public static class FtpInfo {
        private static final int DEFAULT_FTP_PORT = 21;
        private URL uri;
        private String parent;
        private String name;

        public FtpInfo(String s) {
            try {
                this.uri = new URL(s);
            }
            catch (MalformedURLException e) {
                throw new CrawlingAccessException("Invalid URL: " + s, e);
            }
            String path = this.uri.getPath();
            if (path == null) {
                this.parent = "/";
                this.name = null;
            } else {
                Object[] values = path.replaceAll("/+", "/").replaceFirst("/$", "").split("/");
                if (values.length == 1) {
                    this.parent = "/";
                    this.name = null;
                } else if (values.length == 2) {
                    this.parent = "/";
                    this.name = values[1];
                } else {
                    this.parent = StringUtils.join((Object[])values, (String)"/", (int)0, (int)(values.length - 1));
                    this.name = values[values.length - 1];
                }
            }
        }

        public String getCacheKey() {
            return this.getHost() + ":" + this.getPort();
        }

        public String getHost() {
            return this.uri.getHost();
        }

        public int getPort() {
            int port = this.uri.getPort();
            if (port == -1) {
                port = 21;
            }
            return port;
        }

        public String toUrl() {
            StringBuilder buf = new StringBuilder(100);
            buf.append("ftp://");
            buf.append(this.getHost());
            int port = this.getPort();
            if (port != 21) {
                buf.append(':').append(port);
            }
            buf.append(this.uri.getPath());
            if ("/".equals(this.uri.getPath())) {
                return buf.toString();
            }
            return buf.toString().replaceAll("/+$", "");
        }

        public String toUrl(String child) {
            String url = this.toUrl();
            if (url.endsWith("/")) {
                return this.toUrl() + child;
            }
            return this.toUrl() + "/" + child;
        }

        public String getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }
    }
}

