/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.http;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.PropertyDesc;
import org.codelibs.core.beans.factory.BeanDescFactory;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.CrawlerContext;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.client.http.Authentication;
import org.codelibs.fess.crawler.client.http.HcConnectionMonitorTarget;
import org.codelibs.fess.crawler.client.http.RequestHeader;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.RobotsTxt;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.codelibs.fess.crawler.helper.RobotsTxtHelper;
import org.codelibs.fess.crawler.util.CrawlingParameterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcHttpClient
extends AbstractCrawlerClient {
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connectionTimeout";
    @Deprecated
    public static final String STALE_CHECKING_ENABLED_PROPERTY = "staleCheckingEnabled";
    public static final String SO_TIMEOUT_PROPERTY = "soTimeout";
    public static final String PROXY_HOST_PROPERTY = "proxyHost";
    public static final String PROXY_PORT_PROPERTY = "proxyPort";
    public static final String PROXY_AUTH_SCHEME_PROPERTY = "proxyAuthScheme";
    public static final String PROXY_CREDENTIALS_PROPERTY = "proxyCredentials";
    public static final String USER_AGENT_PROPERTY = "userAgent";
    public static final String ROBOTS_TXT_ENABLED_PROPERTY = "robotsTxtEnabled";
    public static final String BASIC_AUTHENTICATIONS_PROPERTY = "basicAuthentications";
    public static final String REQUERT_HEADERS_PROPERTY = "requestHeaders";
    public static final String REDIRECTS_ENABLED = "redirectsEnabled";
    public static final String COOKIES_PROPERTY = "cookies";
    public static final String AUTH_SCHEME_PROVIDERS_PROPERTY = "authSchemeProviders";
    private static final Logger logger = LoggerFactory.getLogger(HcHttpClient.class);
    @Resource
    protected RobotsTxtHelper robotsTxtHelper;
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    @Resource
    protected MimeTypeHelper mimeTypeHelper;
    protected volatile CloseableHttpClient httpClient;
    private final List<Header> requestHeaderList = new ArrayList<Header>();
    private final Map<String, Object> httpClientPropertyMap = new HashMap<String, Object>();
    private TimeoutTask connectionMonitorTask;
    protected Integer accessTimeout;
    protected Integer connectionTimeout;
    protected Integer maxTotalConnections;
    protected Integer maxConnectionsPerRoute;
    @Deprecated
    protected Boolean staleCheckingEnabled;
    protected Integer soTimeout;
    protected String cookieSpec;
    protected String userAgent = "Crawler";
    protected HttpClientContext httpClientContext = HttpClientContext.create();
    protected String proxyHost;
    protected Integer proxyPort;
    protected AuthScheme proxyAuthScheme = new BasicScheme();
    protected Credentials proxyCredentials;
    protected String defaultMimeType = "application/octet-stream";
    protected CookieStore cookieStore = new BasicCookieStore();
    protected HttpClientConnectionManager clientConnectionManager;
    protected Map<String, AuthSchemeProvider> authSchemeProviderMap;
    protected int connectionCheckInterval = 5;
    protected long idleConnectionTimeout = 60000L;
    protected Pattern redirectHttpStatusPattern = Pattern.compile("[3][0-9][0-9]");
    protected boolean useRobotsTxtDisallows = true;
    protected boolean useRobotsTxtAllows = false;
    protected CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    protected AuthCache authCache = new BasicAuthCache();
    protected HttpRoutePlanner routePlanner;
    protected boolean redirectsEnabled = false;

    @Override
    public synchronized void init() {
        RequestHeader[] requestHeaders;
        Authentication[] siteCredentialList;
        HttpRoutePlanner planner;
        Integer soTimeoutParam;
        if (this.httpClient != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing " + HcHttpClient.class.getName());
        }
        super.init();
        Boolean robotsTxtEnabled = this.getInitParameter(ROBOTS_TXT_ENABLED_PROPERTY, Boolean.TRUE, Boolean.class);
        if (this.robotsTxtHelper != null) {
            this.robotsTxtHelper.setEnabled(robotsTxtEnabled);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        Integer connectionTimeoutParam = this.getInitParameter(CONNECTION_TIMEOUT_PROPERTY, this.connectionTimeout, Integer.class);
        if (connectionTimeoutParam != null) {
            requestConfigBuilder.setConnectTimeout(connectionTimeoutParam.intValue());
        }
        if ((soTimeoutParam = this.getInitParameter(SO_TIMEOUT_PROPERTY, this.soTimeout, Integer.class)) != null) {
            requestConfigBuilder.setSocketTimeout(soTimeoutParam.intValue());
        }
        RegistryBuilder authSchemeProviderBuilder = RegistryBuilder.create();
        Map factoryMap = this.getInitParameter(AUTH_SCHEME_PROVIDERS_PROPERTY, this.authSchemeProviderMap, Map.class);
        if (factoryMap != null) {
            for (Map.Entry entry : factoryMap.entrySet()) {
                authSchemeProviderBuilder.register((String)entry.getKey(), entry.getValue());
            }
        }
        this.userAgent = this.getInitParameter(USER_AGENT_PROPERTY, this.userAgent, String.class);
        if (StringUtil.isNotBlank((String)this.userAgent)) {
            httpClientBuilder.setUserAgent(this.userAgent);
        }
        if ((planner = this.buildRoutePlanner()) != null) {
            httpClientBuilder.setRoutePlanner(planner);
        }
        for (Authentication authentication : siteCredentialList = this.getInitParameter(BASIC_AUTHENTICATIONS_PROPERTY, new Authentication[0], Authentication[].class)) {
            AuthScope authScope = authentication.getAuthScope();
            this.credentialsProvider.setCredentials(authScope, authentication.getCredentials());
            AuthScheme authScheme = authentication.getAuthScheme();
            if (authScope.getHost() == null || authScheme == null) continue;
            HttpHost targetHost = new HttpHost(authScope.getHost(), authScope.getPort());
            this.authCache.put(targetHost, authScheme);
        }
        this.httpClientContext.setAuthCache(this.authCache);
        this.httpClientContext.setCredentialsProvider(this.credentialsProvider);
        for (RequestHeader requestHeader : requestHeaders = this.getInitParameter(REQUERT_HEADERS_PROPERTY, new RequestHeader[0], RequestHeader[].class)) {
            if (!requestHeader.isValid()) continue;
            this.requestHeaderList.add((Header)new BasicHeader(requestHeader.getName(), requestHeader.getValue()));
        }
        requestConfigBuilder.setRedirectsEnabled(this.getInitParameter(REDIRECTS_ENABLED, this.redirectsEnabled, Boolean.class).booleanValue());
        if (this.cookieSpec != null) {
            requestConfigBuilder.setCookieSpec(this.cookieSpec);
        }
        httpClientBuilder.setDefaultCookieStore(this.cookieStore);
        if (this.cookieStore != null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = this.getInitParameter(COOKIES_PROPERTY, new Cookie[0], Cookie[].class)) {
                this.cookieStore.addCookie(cookie);
            }
        }
        this.connectionMonitorTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)new HcConnectionMonitorTarget(this.clientConnectionManager, this.idleConnectionTimeout), this.connectionCheckInterval, true);
        CloseableHttpClient closeableHttpClient = httpClientBuilder.setConnectionManager(this.clientConnectionManager).setDefaultRequestConfig(requestConfigBuilder.build()).build();
        if (!this.httpClientPropertyMap.isEmpty()) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(closeableHttpClient.getClass());
            for (Map.Entry<String, Object> entry : this.httpClientPropertyMap.entrySet()) {
                String propertyName = entry.getKey();
                if (beanDesc.hasPropertyDesc(propertyName)) {
                    PropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
                    propertyDesc.setValue((Object)closeableHttpClient, entry.getValue());
                    continue;
                }
                logger.warn("DefaultHttpClient does not have " + propertyName + ".");
            }
        }
        this.httpClient = closeableHttpClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.connectionMonitorTask != null) {
            this.connectionMonitorTask.cancel();
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                logger.error("Failed to close httpClient.", (Throwable)e);
            }
        }
    }

    public void addHttpClientProperty(String name, Object value) {
        if (StringUtil.isNotBlank((String)name) && value != null) {
            this.httpClientPropertyMap.put(name, value);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRobotsTxt(String url) {
        HttpEntity httpEntity;
        block18: {
            if (StringUtil.isBlank((String)url)) {
                throw new CrawlerSystemException("url is null or empty.");
            }
            if (this.robotsTxtHelper == null) return;
            if (!this.robotsTxtHelper.isEnabled()) {
                return;
            }
            CrawlerContext crawlerContext = CrawlingParameterUtil.getCrawlerContext();
            if (crawlerContext == null) {
                return;
            }
            int idx = url.indexOf(47, url.indexOf("://") + 3);
            String hostUrl = idx >= 0 ? url.substring(0, idx) : url;
            String robotTxtUrl = hostUrl + "/robots.txt";
            if (crawlerContext.getRobotsTxtUrlSet().contains(robotTxtUrl)) {
                if (!logger.isDebugEnabled()) return;
                logger.debug(robotTxtUrl + " is already visited.");
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Checking URL: " + robotTxtUrl);
            }
            crawlerContext.getRobotsTxtUrlSet().add(robotTxtUrl);
            HttpGet httpGet = new HttpGet(robotTxtUrl);
            for (Header header : this.requestHeaderList) {
                httpGet.addHeader(header);
            }
            httpEntity = null;
            try {
                RobotsTxt.Directive directive;
                RobotsTxt robotsTxt;
                HttpResponse response = this.executeHttpClient((HttpUriRequest)httpGet);
                httpEntity = response.getEntity();
                int httpStatusCode = response.getStatusLine().getStatusCode();
                if (httpStatusCode != 200) break block18;
                Header contentLengthHeader = response.getFirstHeader("Content-Length");
                if (contentLengthHeader != null) {
                    long maxLength;
                    String value = contentLengthHeader.getValue();
                    long contentLength = Long.parseLong(value);
                    if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength("text/plain"))) {
                        throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + robotTxtUrl);
                    }
                }
                if (httpEntity == null || (robotsTxt = this.robotsTxtHelper.parse(httpEntity.getContent())) == null) break block18;
                String[] sitemaps = robotsTxt.getSitemaps();
                if (sitemaps.length > 0) {
                    crawlerContext.addSitemaps(sitemaps);
                }
                if ((directive = robotsTxt.getMatchedDirective(this.userAgent)) == null) break block18;
                if (this.useRobotsTxtDisallows) {
                    for (String urlPattern : directive.getDisallows()) {
                        if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                        urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                        crawlerContext.getUrlFilter().addExclude(hostUrl + urlPattern);
                    }
                }
                if (this.useRobotsTxtAllows) {
                    for (String urlPattern : directive.getAllows()) {
                        if (!StringUtil.isNotBlank((String)urlPattern)) continue;
                        urlPattern = this.convertRobotsTxtPathPattern(urlPattern);
                        crawlerContext.getUrlFilter().addInclude(hostUrl + urlPattern);
                    }
                }
            }
            catch (CrawlerSystemException e) {
                try {
                    httpGet.abort();
                    throw e;
                    catch (Exception e2) {
                        httpGet.abort();
                        throw new CrawlingAccessException("Could not process " + robotTxtUrl + ". ", e2);
                    }
                }
                catch (Throwable throwable) {
                    EntityUtils.consumeQuietly(httpEntity);
                    throw throwable;
                }
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
    }

    protected String convertRobotsTxtPathPattern(String path) {
        String newPath = path.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        if (newPath.charAt(0) != '/') {
            newPath = ".*" + newPath;
        }
        if (!newPath.endsWith("$") && !newPath.endsWith(".*")) {
            newPath = newPath + ".*";
        }
        return newPath.replaceAll("\\.\\*\\.\\*", ".*");
    }

    @Override
    public ResponseData doGet(String url) {
        HttpGet httpGet;
        try {
            httpGet = new HttpGet(url);
        }
        catch (IllegalArgumentException e) {
            throw new CrawlingAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpUriRequest)httpGet);
    }

    @Override
    public ResponseData doHead(String url) {
        HttpHead httpHead;
        try {
            httpHead = new HttpHead(url);
        }
        catch (IllegalArgumentException e) {
            throw new CrawlingAccessException("The url may not be valid: " + url, e);
        }
        return this.doHttpMethod(url, (HttpUriRequest)httpHead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData doHttpMethod(String url, HttpUriRequest httpRequest) {
        if (this.httpClient == null) {
            this.init();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Accessing " + url);
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.processHttpMethod(url, httpRequest);
            return responseData;
        }
        finally {
            if (this.accessTimeout != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResponseData processHttpMethod(String url, HttpUriRequest httpRequest) {
        ResponseData responseData;
        int httpStatusCode;
        HttpResponse response;
        HttpEntity httpEntity;
        ResponseData responseData2;
        block66: {
            block65: {
                try {
                    this.processRobotsTxt(url);
                }
                catch (CrawlingAccessException e) {
                    if (logger.isInfoEnabled()) {
                        StringBuilder buf = new StringBuilder(100);
                        buf.append(e.getMessage());
                        if (e.getCause() != null) {
                            buf.append(e.getCause().getMessage());
                        }
                        logger.info(buf.toString());
                    }
                    if (!logger.isDebugEnabled()) break block65;
                    logger.debug("Crawling Access Exception at " + url, (Throwable)e);
                }
            }
            for (Header header : this.requestHeaderList) {
                httpRequest.addHeader(header);
            }
            responseData2 = new ResponseData();
            httpEntity = null;
            response = this.executeHttpClient(httpRequest);
            httpEntity = response.getEntity();
            httpStatusCode = response.getStatusLine().getStatusCode();
            if (!this.isRedirectHttpStatus(httpStatusCode)) break block66;
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null) {
                logger.warn("Invalid redirect location at " + url);
                break block66;
            }
            responseData2 = new ResponseData();
            responseData2.setRedirectLocation(locationHeader.getValue());
            ResponseData responseData3 = responseData2;
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            return responseData3;
        }
        try {
            Date d;
            String value;
            long maxLength;
            String contentEncoding;
            long contentLength;
            String contentType;
            block70: {
                Header contentEncodingHeader;
                block68: {
                    Throwable throwable;
                    InputStream is;
                    File outputFile;
                    block71: {
                        block69: {
                            int idx;
                            contentType = null;
                            Header contentTypeHeader = response.getFirstHeader("Content-Type");
                            if (contentTypeHeader != null && (idx = (contentType = contentTypeHeader.getValue()).indexOf(59)) > 0 && "application/octet-stream".equals(contentType = contentType.substring(0, idx))) {
                                contentType = null;
                            }
                            contentLength = 0L;
                            contentEncoding = "UTF-8";
                            if (httpEntity != null) break block69;
                            responseData2.setResponseBody(new byte[0]);
                            if (contentType == null) {
                                contentType = this.defaultMimeType;
                            }
                            break block70;
                        }
                        InputStream responseBodyStream = httpEntity.getContent();
                        outputFile = File.createTempFile("crawler-HcHttpClient-", ".out");
                        DeferredFileOutputStream dfos = null;
                        try {
                            try {
                                dfos = new DeferredFileOutputStream((int)this.maxCachedContentSize, outputFile);
                                CopyUtil.copy((InputStream)responseBodyStream, (OutputStream)dfos);
                                dfos.flush();
                            }
                            catch (Throwable throwable2) {
                                IOUtils.closeQuietly(dfos);
                                throw throwable2;
                            }
                            IOUtils.closeQuietly((OutputStream)dfos);
                        }
                        catch (Exception e) {
                            if (!outputFile.delete()) {
                                logger.warn("Could not delete " + outputFile.getAbsolutePath());
                            }
                            throw e;
                        }
                        if (!dfos.isInMemory()) break block71;
                        responseData2.setResponseBody(dfos.getData());
                        contentLength = dfos.getData().length;
                        if (!outputFile.delete()) {
                            logger.warn("Could not delete " + outputFile.getAbsolutePath());
                        }
                        if (contentType == null) {
                            try {
                                is = new ByteArrayInputStream(dfos.getData());
                                throwable = null;
                                try {
                                    contentType = this.mimeTypeHelper.getContentType(is, url);
                                    break block68;
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (is != null) {
                                        if (throwable != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable.addSuppressed(throwable4);
                                            }
                                        } else {
                                            is.close();
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.debug("Failed to detect mime-type.", (Throwable)e);
                                contentType = this.defaultMimeType;
                            }
                        }
                        break block68;
                    }
                    responseData2.setResponseBody(outputFile, true);
                    contentLength = outputFile.length();
                    if (contentType == null) {
                        try {
                            is = new FileInputStream(outputFile);
                            throwable = null;
                            try {
                                contentType = this.mimeTypeHelper.getContentType(is, url);
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (is != null) {
                                    if (throwable != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        is.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.debug("Failed to detect mime-type.", (Throwable)e);
                            contentType = this.defaultMimeType;
                        }
                    }
                }
                if ((contentEncodingHeader = httpEntity.getContentEncoding()) != null) {
                    contentEncoding = contentEncodingHeader.getValue();
                }
            }
            if (this.contentLengthHelper != null && contentLength > (maxLength = this.contentLengthHelper.getMaxLength(contentType))) {
                throw new MaxLengthExceededException("The content length (" + contentLength + " byte) is over " + maxLength + " byte. The url is " + url);
            }
            responseData2.setUrl(url);
            responseData2.setCharSet(contentEncoding);
            if (httpRequest instanceof HttpHead) {
                responseData2.setMethod("HEAD");
            } else {
                responseData2.setMethod("GET");
            }
            responseData2.setHttpStatusCode(httpStatusCode);
            for (Header header : response.getAllHeaders()) {
                responseData2.addMetaData(header.getName(), header.getValue());
            }
            responseData2.setMimeType(contentType);
            Header contentLengthHeader = response.getFirstHeader("Content-Length");
            if (contentLengthHeader == null) {
                responseData2.setContentLength(contentLength);
            } else {
                String value2 = contentLengthHeader.getValue();
                try {
                    responseData2.setContentLength(Long.parseLong(value2));
                }
                catch (Exception e) {
                    responseData2.setContentLength(contentLength);
                }
            }
            this.checkMaxContentLength(responseData2);
            Header lastModifiedHeader = response.getFirstHeader("Last-Modified");
            if (lastModifiedHeader != null && StringUtil.isNotBlank((String)(value = lastModifiedHeader.getValue())) && (d = this.parseLastModified(value)) != null) {
                responseData2.setLastModified(d);
            }
            responseData = responseData2;
        }
        catch (UnknownHostException e) {
            try {
                this.closeResources(httpRequest, responseData2);
                throw new CrawlingAccessException("Unknown host(" + e.getMessage() + "): " + url, e);
                catch (NoRouteToHostException e2) {
                    this.closeResources(httpRequest, responseData2);
                    throw new CrawlingAccessException("No route to host(" + e2.getMessage() + "): " + url, e2);
                }
                catch (ConnectException e3) {
                    this.closeResources(httpRequest, responseData2);
                    throw new CrawlingAccessException("Connection time out(" + e3.getMessage() + "): " + url, e3);
                }
                catch (SocketException e4) {
                    this.closeResources(httpRequest, responseData2);
                    throw new CrawlingAccessException("Socket exception(" + e4.getMessage() + "): " + url, e4);
                }
                catch (IOException e5) {
                    this.closeResources(httpRequest, responseData2);
                    throw new CrawlingAccessException("I/O exception(" + e5.getMessage() + "): " + url, e5);
                }
                catch (CrawlerSystemException e6) {
                    this.closeResources(httpRequest, responseData2);
                    throw e6;
                }
                catch (Exception e7) {
                    this.closeResources(httpRequest, responseData2);
                    throw new CrawlerSystemException("Failed to access " + url, e7);
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        return responseData;
    }

    protected void closeResources(HttpUriRequest httpRequest, ResponseData responseData) {
        IOUtils.closeQuietly((Closeable)responseData);
        httpRequest.abort();
    }

    protected boolean isRedirectHttpStatus(int httpStatusCode) {
        return this.redirectHttpStatusPattern.matcher(Integer.toString(httpStatusCode)).matches();
    }

    protected HttpResponse executeHttpClient(HttpUriRequest httpRequest) throws IOException {
        return this.httpClient.execute(httpRequest, (HttpContext)new BasicHttpContext((HttpContext)this.httpClientContext));
    }

    protected Date parseLastModified(String value) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        try {
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected HttpRoutePlanner buildRoutePlanner() {
        if (this.routePlanner != null) {
            return this.routePlanner;
        }
        String proxyHost = this.getInitParameter(PROXY_HOST_PROPERTY, this.proxyHost, String.class);
        Integer proxyPort = this.getInitParameter(PROXY_PORT_PROPERTY, this.proxyPort, Integer.class);
        if (proxyHost != null && proxyPort != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            DefaultProxyRoutePlanner defaultRoutePlanner = new DefaultProxyRoutePlanner(proxy);
            Credentials credentials = this.getInitParameter(PROXY_CREDENTIALS_PROPERTY, this.proxyCredentials, Credentials.class);
            if (credentials != null) {
                this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), credentials);
                AuthScheme authScheme = this.getInitParameter(PROXY_AUTH_SCHEME_PROPERTY, this.proxyAuthScheme, AuthScheme.class);
                if (authScheme != null) {
                    this.authCache.put(proxy, authScheme);
                }
            }
            return defaultRoutePlanner;
        }
        return null;
    }

    @Override
    public void setAccessTimeout(Integer accessTimeout) {
        this.accessTimeout = accessTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setMaxConnectionsPerRoute(Integer maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public void setStaleCheckingEnabled(Boolean staleCheckingEnabled) {
        this.staleCheckingEnabled = staleCheckingEnabled;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setCookieSpec(String cookieSpec) {
        this.cookieSpec = cookieSpec;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyAuthScheme(AuthScheme proxyAuthScheme) {
        this.proxyAuthScheme = proxyAuthScheme;
    }

    public void setProxyCredentials(Credentials proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setDefaultMimeType(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setHttpClientContext(HttpClientContext httpClientContext) {
        this.httpClientContext = httpClientContext;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public void setAuthSchemeProviderMap(Map<String, AuthSchemeProvider> authSchemeProviderMap) {
        this.authSchemeProviderMap = authSchemeProviderMap;
    }

    public void setConnectionCheckInterval(int connectionCheckInterval) {
        this.connectionCheckInterval = connectionCheckInterval;
    }

    public void setIdleConnectionTimeout(long idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public void setRedirectHttpStatusPattern(Pattern redirectHttpStatusPattern) {
        this.redirectHttpStatusPattern = redirectHttpStatusPattern;
    }

    public void setUseRobotsTxtDisallows(boolean useRobotsTxtDisallows) {
        this.useRobotsTxtDisallows = useRobotsTxtDisallows;
    }

    public void setUseRobotsTxtAllows(boolean useRobotsTxtAllows) {
        this.useRobotsTxtAllows = useRobotsTxtAllows;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setAuthCache(AuthCache authCache) {
        this.authCache = authCache;
    }

    public void setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.redirectsEnabled = redirectsEnabled;
    }
}

