/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.smb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import jcifs.Config;
import jcifs.smb.ACE;
import jcifs.smb.SID;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.util.LogStream;
import org.apache.commons.io.IOUtils;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.io.InputStreamUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.builder.RequestDataBuilder;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.client.smb.SmbAuthentication;
import org.codelibs.fess.crawler.client.smb.SmbAuthenticationHolder;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(SmbClient.class);
    public static final String SMB_AUTHENTICATIONS_PROPERTY = "smbAuthentications";
    public static final String SMB_ACCESS_CONTROL_ENTRIES = "smbAccessControlEntries";
    public static final String SMB_CREATE_TIME = "smbCreateTime";
    public static final String SMB_OWNER_ATTRIBUTES = "smbOwnerAttributes";
    @Resource
    protected CrawlerContainer crawlerContainer;
    protected String charset = "UTF-8";
    protected boolean resolveSids = true;
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    public volatile SmbAuthenticationHolder smbAuthenticationHolder;

    @Override
    public synchronized void init() {
        if (this.smbAuthenticationHolder != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing SmbClient...");
        }
        super.init();
        SmbAuthenticationHolder holder = new SmbAuthenticationHolder();
        SmbAuthentication[] smbAuthentications = this.getInitParameter(SMB_AUTHENTICATIONS_PROPERTY, new SmbAuthentication[0], SmbAuthentication[].class);
        if (smbAuthentications != null) {
            for (SmbAuthentication smbAuthentication : smbAuthentications) {
                holder.add(smbAuthentication);
            }
        }
        this.smbAuthenticationHolder = holder;
    }

    @PreDestroy
    public void destroy() {
        this.smbAuthenticationHolder = null;
    }

    @Override
    public ResponseData doGet(String uri) {
        return this.processRequest(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData processRequest(String uri, boolean includeContent) {
        if (this.smbAuthenticationHolder == null) {
            this.init();
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.getResponseData(uri, includeContent);
            return responseData;
        }
        finally {
            if (this.accessTimeout != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData;
        block75: {
            responseData = new ResponseData();
            responseData.setMethod("GET");
            String filePath = this.preprocessUri(uri);
            responseData.setUrl(filePath);
            SmbFile file = null;
            SmbAuthentication smbAuthentication = this.smbAuthenticationHolder.get(filePath);
            if (logger.isDebugEnabled()) {
                logger.debug("Creating SmbFile: " + filePath);
            }
            try {
                file = smbAuthentication == null ? new SmbFile(filePath) : new SmbFile(filePath, smbAuthentication.getAuthentication());
            }
            catch (MalformedURLException e) {
                logger.warn("Could not parse url: " + filePath, (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Processing SmbFile: " + filePath);
            }
            try {
                if (file == null) {
                    responseData.setHttpStatusCode(404);
                    responseData.setCharSet(this.charset);
                    responseData.setContentLength(0L);
                    break block75;
                }
                if (file.isFile()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Checking SmbFile Size: " + filePath);
                    }
                    responseData.setContentLength(file.length());
                    this.checkMaxContentLength(responseData);
                    responseData.setHttpStatusCode(200);
                    responseData.setCharSet(this.geCharSet(file));
                    responseData.setLastModified(new Date(file.lastModified()));
                    responseData.addMetaData(SMB_CREATE_TIME, new Date(file.createTime()));
                    try {
                        SID ownerUser;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Parsing SmbFile Owner: " + filePath);
                        }
                        if ((ownerUser = file.getOwnerUser()) != null) {
                            String[] ownerAttributes = new String[]{ownerUser.getAccountName(), ownerUser.getDomainName()};
                            responseData.addMetaData(SMB_OWNER_ATTRIBUTES, ownerAttributes);
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Cannot get owner of the file: " + filePath);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Parsing SmbFile ACL: " + filePath);
                    }
                    this.processAccessControlEntries(responseData, file);
                    Map headerFieldMap = file.getHeaderFields();
                    if (headerFieldMap != null) {
                        for (Map.Entry entry : headerFieldMap.entrySet()) {
                            responseData.addMetaData((String)entry.getKey(), entry.getValue());
                        }
                    }
                    if (file.canRead()) {
                        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper");
                        if (includeContent) {
                            Throwable throwable;
                            block76: {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Parsing SmbFile Content: " + filePath);
                                }
                                if ((long)file.getContentLength() < this.maxCachedContentSize) {
                                    try {
                                        throwable = null;
                                        try (BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)new SmbFileInputStream(file));){
                                            responseData.setResponseBody(InputStreamUtil.getBytes((InputStream)bufferedInputStream));
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                    }
                                    catch (Exception exception) {
                                        logger.warn("I/O Exception.", (Throwable)exception);
                                        responseData.setHttpStatusCode(500);
                                    }
                                } else {
                                    File file2 = null;
                                    try {
                                        File file3 = File.createTempFile("crawler-SmbClient-", ".out");
                                        this.copy(file, file3);
                                        responseData.setResponseBody(file3, true);
                                    }
                                    catch (Exception e) {
                                        logger.warn("I/O Exception.", (Throwable)e);
                                        responseData.setHttpStatusCode(500);
                                        if (file2 == null || file2.delete()) break block76;
                                        logger.warn("Could not delete " + file2.getAbsolutePath());
                                    }
                                }
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("Parsing SmbFile MIME Type: " + filePath);
                            }
                            try {
                                throwable = null;
                                try (InputStream inputStream = responseData.getResponseBody();){
                                    responseData.setMimeType(mimeTypeHelper.getContentType(inputStream, file.getName()));
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                            }
                            catch (Exception exception) {
                                responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                            }
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Parsing SmbFile MIME Type: " + filePath);
                            }
                            try (SmbFileInputStream smbFileInputStream = new SmbFileInputStream(file);){
                                responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)smbFileInputStream, file.getName()));
                            }
                            catch (Exception exception) {
                                responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                            }
                        }
                        if (this.contentLengthHelper != null) {
                            long l = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                            if (responseData.getContentLength() > l) {
                                throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + l + " byte. The url is " + filePath);
                            }
                        }
                        break block75;
                    }
                    responseData.setHttpStatusCode(403);
                    responseData.setMimeType("application/octet-stream");
                    break block75;
                }
                if (file.isDirectory()) {
                    SmbFile[] files;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Parsing SmbFile Directory: " + filePath);
                    }
                    HashSet<RequestData> requestDataSet = new HashSet<RequestData>(100);
                    if (includeContent && (files = file.listFiles()) != null) {
                        for (SmbFile f : files) {
                            String chileUri = f.toString();
                            requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                        }
                    }
                    throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData(String, boolean)");
                }
                responseData.setHttpStatusCode(404);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
            }
            catch (CrawlerSystemException e) {
                IOUtils.closeQuietly((Closeable)responseData);
                throw e;
            }
            catch (SmbException e) {
                IOUtils.closeQuietly((Closeable)responseData);
                throw new CrawlingAccessException("Could not access " + uri, e);
            }
        }
        return responseData;
    }

    protected void processAccessControlEntries(ResponseData responseData, SmbFile file) {
        try {
            ACE[] aces = file.getSecurity(this.resolveSids);
            if (aces != null) {
                responseData.addMetaData(SMB_ACCESS_CONTROL_ENTRIES, aces);
            }
        }
        catch (IOException e) {
            throw new CrawlingAccessException("Could not access " + file.getPath(), e);
        }
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new CrawlerSystemException("The uri is empty.");
        }
        return uri;
    }

    protected String geCharSet(SmbFile file) {
        return this.charset;
    }

    @Override
    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.processRequest(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }

    private void copy(SmbFile src, File dest) {
        if (dest.exists() && !dest.canWrite()) {
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream((InputStream)new SmbFileInputStream(src));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));){
            int length;
            byte[] buf = new byte[1024];
            while (-1 < (length = in.read(buf))) {
                out.write(buf, 0, length);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public boolean isResolveSids() {
        return this.resolveSids;
    }

    public void setResolveSids(boolean resolveSids) {
        this.resolveSids = resolveSids;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    static {
        if (Config.getInt((String)"jcifs.util.loglevel", (int)-1) == -1) {
            if (logger.isTraceEnabled()) {
                LogStream.setLevel((int)4);
            } else if (logger.isDebugEnabled()) {
                LogStream.setLevel((int)3);
            } else if (logger.isWarnEnabled()) {
                LogStream.setLevel((int)2);
            } else if (logger.isErrorEnabled()) {
                LogStream.setLevel((int)1);
            } else {
                LogStream.setLevel((int)0);
            }
        }
        LogStream.setInstance((PrintStream)new PrintStream(new OutputStream(){
            private static final int MAX_LEN = 1000;
            private final ByteArrayOutputStream buf = new ByteArrayOutputStream(1000);

            @Override
            public void write(int b) throws IOException {
                if (b == 10 || b == 13 || this.buf.size() >= 1000) {
                    try {
                        String msg = this.buf.toString("UTF-8");
                        if (StringUtil.isNotBlank((String)msg)) {
                            if (logger.isTraceEnabled()) {
                                logger.trace(msg);
                            } else if (logger.isDebugEnabled()) {
                                logger.debug(msg);
                            } else if (logger.isWarnEnabled()) {
                                logger.warn(msg);
                            } else if (logger.isErrorEnabled()) {
                                logger.error(msg);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn(e.getLocalizedMessage());
                    }
                    this.buf.reset();
                } else {
                    this.buf.write(b);
                }
            }
        }));
    }
}

