/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.container;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.codelibs.core.beans.BeanDesc;
import org.codelibs.core.beans.FieldDesc;
import org.codelibs.core.beans.MethodDesc;
import org.codelibs.core.beans.factory.BeanDescFactory;
import org.codelibs.core.lang.ClassUtil;
import org.codelibs.core.lang.FieldUtil;
import org.codelibs.core.lang.MethodUtil;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardCrawlerContainer
implements CrawlerContainer {
    private final Logger logger = LoggerFactory.getLogger(StandardCrawlerContainer.class);
    private final Map<String, ComponentHolder<?>> singletonMap = new ConcurrentHashMap();
    private final Map<String, ComponentDef<?>> prototypeMap = new ConcurrentHashMap();
    private boolean available = true;

    @Override
    public <T> T getComponent(String name) {
        if ("crawlerContainer".equals(name)) {
            StandardCrawlerContainer t = this;
            return (T)t;
        }
        ComponentDef<?> componentDef = this.prototypeMap.get(name);
        if (componentDef != null) {
            Object instance = componentDef.get();
            return (T)instance;
        }
        ComponentHolder<?> componentHolder = this.singletonMap.get(name);
        if (componentHolder != null) {
            Object instance = componentHolder.get();
            return (T)instance;
        }
        return null;
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void destroy() {
        this.available = false;
        for (ComponentHolder<?> componentHolder : this.singletonMap.values()) {
            try {
                componentHolder.destroy();
            }
            catch (Exception e) {
                this.logger.warn("Failed to destroy " + componentHolder.get(), (Throwable)e);
            }
        }
    }

    public <T> StandardCrawlerContainer prototype(String name, Class<T> cls, Consumer<T> component) {
        this.prototypeMap.put(name, new ComponentDef<Class<T>>(cls, component, this));
        return this;
    }

    public <T> StandardCrawlerContainer prototype(String name, Class<T> cls) {
        return this.prototype(name, cls, null);
    }

    public <T> StandardCrawlerContainer singleton(String name, Class<T> cls, Consumer<T> initializer, Consumer<T> destroyer) {
        ComponentDef<Class<T>> componentDef = new ComponentDef<Class<T>>(cls, initializer, this);
        Class<T> instance = componentDef.get();
        this.singletonMap.put(name, new ComponentHolder<Class<T>>(instance, destroyer));
        return this;
    }

    public <T> StandardCrawlerContainer singleton(String name, Class<T> cls, Consumer<T> initializer) {
        return this.singleton(name, (T)cls, initializer, (Consumer<T>)null);
    }

    public <T> StandardCrawlerContainer singleton(String name, Class<T> cls) {
        return this.singleton(name, (T)cls, (Consumer<T>)null, (Consumer<T>)null);
    }

    public <T> StandardCrawlerContainer singleton(String name, T instance, Consumer<T> initializer, Consumer<T> destroyer) {
        ComponentDef<T> componentDef = new ComponentDef<T>(instance, initializer, this);
        this.singletonMap.put(name, new ComponentHolder<T>(componentDef.get(), destroyer));
        return this;
    }

    public <T> StandardCrawlerContainer singleton(String name, T instance, Consumer<T> initializer) {
        return this.singleton(name, instance, initializer, null);
    }

    public <T> StandardCrawlerContainer singleton(String name, T instance) {
        return this.singleton(name, instance, null, null);
    }

    protected static class ComponentDef<T> {
        protected Class<T> cls;
        protected Consumer<T> initializer;
        protected StandardCrawlerContainer container;
        private T instance;

        protected ComponentDef(Class<T> cls, Consumer<T> initializer, StandardCrawlerContainer container) {
            this.cls = cls;
            this.initializer = initializer;
            this.container = container;
        }

        protected ComponentDef(T instance, Consumer<T> initializer, StandardCrawlerContainer container) {
            this.instance = instance;
            this.initializer = initializer;
            this.container = container;
        }

        protected T get() {
            Object component = this.instance == null ? ClassUtil.newInstance(this.cls) : this.instance;
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
            for (FieldDesc fieldDesc : beanDesc.getFieldDescs()) {
                Object injected;
                Resource annotation = fieldDesc.getField().getAnnotation(Resource.class);
                if (annotation == null || (injected = this.container.getComponent(fieldDesc.getFieldName())) == null) continue;
                FieldUtil.set((Field)fieldDesc.getField(), (Object)component, injected);
            }
            for (String methodName : beanDesc.getMethodNames()) {
                Method method;
                PostConstruct postConstruct;
                MethodDesc methodDesc = beanDesc.getMethodDescNoException(methodName, new Class[0]);
                if (methodDesc == null || (postConstruct = (method = methodDesc.getMethod()).getAnnotation(PostConstruct.class)) == null) continue;
                MethodUtil.invoke((Method)method, (Object)component, (Object[])new Object[0]);
            }
            if (this.initializer != null) {
                this.initializer.accept(component);
            }
            return (T)component;
        }
    }

    protected static class ComponentHolder<T> {
        protected T instance;
        protected Consumer<T> destroyer;

        protected ComponentHolder(T instance, Consumer<T> destroyer) {
            this.instance = instance;
            this.destroyer = destroyer;
        }

        protected T get() {
            return this.instance;
        }

        protected void destroy() {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.instance.getClass());
            for (String methodName : beanDesc.getMethodNames()) {
                Method method;
                PreDestroy postConstruct;
                MethodDesc methodDesc = beanDesc.getMethodDescNoException(methodName, new Class[0]);
                if (methodDesc == null || (postConstruct = (method = methodDesc.getMethod()).getAnnotation(PreDestroy.class)) == null) continue;
                MethodUtil.invoke((Method)method, this.instance, (Object[])new Object[0]);
            }
            if (this.destroyer != null) {
                this.destroyer.accept(this.instance);
            }
        }
    }
}

