/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.extractor.Extractor;

public class ExtractorFactory {
    protected Map<String, Extractor> extractorMap = new HashMap<String, Extractor>();

    public void addExtractor(String key, Extractor extractor) {
        if (StringUtil.isBlank((String)key)) {
            throw new CrawlerSystemException("The key is null.");
        }
        if (extractor == null) {
            throw new CrawlerSystemException("The extractor is null.");
        }
        this.extractorMap.put(key, extractor);
    }

    public void addExtractor(List<String> keyList, Extractor extractor) {
        if (keyList == null || keyList.isEmpty()) {
            throw new CrawlerSystemException("The key list is empty.");
        }
        for (String key : keyList) {
            this.addExtractor(key, extractor);
        }
    }

    public Extractor getExtractor(String key) {
        return this.extractorMap.get(key);
    }

    public void setExtractorMap(Map<String, Extractor> extractorMap) {
        this.extractorMap = extractorMap;
    }
}

