/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.exception.ExtractException;
import org.codelibs.fess.crawler.extractor.Extractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmlExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(EmlExtractor.class);
    protected Properties mailProperties = new Properties();

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        Properties props = new Properties(this.mailProperties);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            Session mailSession = Session.getDefaultInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(mailSession, in);
            String content = this.getBodyText(message);
            ExtractData data = new ExtractData(content != null ? content.toString() : "");
            Enumeration headers = message.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                data.putValue(header.getName(), header.getValue());
            }
            try {
                this.putValue(data, "Content-ID", message.getContentID());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Content-Language", message.getContentLanguage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Content-MD5", message.getContentMD5());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Description", message.getDescription());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Disposition", message.getDisposition());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Encoding", message.getEncoding());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "File-Name", message.getFileName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "From", message.getFrom());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Line-Count", message.getLineCount());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Message-ID", message.getMessageID());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Message-Number", message.getMessageNumber());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Received-Date", EmlExtractor.getReceivedDate((Message)message));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Reply-To", message.getReplyTo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Sender", message.getSender());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Sent-Date", message.getSentDate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Size", message.getSize());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Subject", message.getSubject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Receipients", message.getAllRecipients());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "To", message.getRecipients(Message.RecipientType.TO));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Cc", message.getRecipients(Message.RecipientType.CC));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.putValue(data, "Bcc", message.getRecipients(Message.RecipientType.BCC));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (MessagingException e) {
            throw new ExtractException(e);
        }
    }

    private void putValue(ExtractData data, String key, Object value) {
        if (value instanceof String) {
            if ("Subject".equals(key)) {
                data.putValue(key, this.getDecodeText(value.toString()));
            } else {
                data.putValue(key, value.toString());
            }
        } else if (value instanceof String[]) {
            data.putValues(key, (String[])value);
        } else if (value instanceof Integer) {
            data.putValue(key, ((Integer)value).toString());
        } else if (value instanceof Address[]) {
            int size = ((Address[])value).length;
            String[] values = new String[size];
            for (int i = 0; i < size; ++i) {
                Address address = ((Address[])value)[i];
                values[i] = this.getDecodeText(address.toString());
            }
            data.putValues(key, values);
        } else if (value instanceof Date) {
            data.putValue(key, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(value));
        } else if (value != null) {
            data.putValue(key, value.toString());
        }
    }

    String getDecodeText(String value) {
        if (value == null) {
            return "";
        }
        try {
            return MimeUtility.decodeText((String)value);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Invalid encoding.", (Throwable)e);
            return "";
        }
    }

    public Properties getMailProperties() {
        return this.mailProperties;
    }

    public void setMailProperties(Properties mailProperties) {
        this.mailProperties = mailProperties;
    }

    private String getBodyText(MimeMessage message) {
        String result = null;
        try {
            Object content = message.getContent();
            if (content instanceof Multipart) {
                BodyPart textPlain = null;
                BodyPart textHtml = null;
                Multipart multipart = (Multipart)content;
                int count = multipart.getCount();
                for (int i = 0; i < count; ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    String disposition = bodyPart.getDisposition();
                    if (disposition != null && disposition.equalsIgnoreCase("ATTACHMENT")) continue;
                    if (bodyPart.isMimeType("text/plain")) {
                        textPlain = bodyPart;
                        break;
                    }
                    if (!bodyPart.isMimeType("text/html")) continue;
                    textHtml = bodyPart;
                }
                if (textPlain != null) {
                    result = (String)textPlain.getContent();
                } else if (textHtml != null) {
                    result = (String)textHtml.getContent();
                }
            } else if (content instanceof String) {
                result = (String)content;
            }
        }
        catch (IOException | MessagingException e) {
            throw new ExtractException(e);
        }
        return result;
    }

    private static Date getReceivedDate(Message message) throws MessagingException {
        Date today = new Date();
        String[] received = message.getHeader("received");
        if (received != null) {
            for (String v : received) {
                String dateStr = null;
                try {
                    dateStr = EmlExtractor.getDateString(v);
                    Date receivedDate = new MailDateFormat().parse(dateStr);
                    if (!receivedDate.after(today)) {
                        return receivedDate;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static String getDateString(String text) {
        String[] dayOfWeek;
        for (String dow : dayOfWeek = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"}) {
            int i = text.lastIndexOf(dow);
            if (i == -1) continue;
            return text.substring(i);
        }
        return null;
    }
}

