/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.Constants;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.ExtractException;
import org.codelibs.fess.crawler.extractor.Extractor;
import org.codelibs.fess.crawler.extractor.impl.PdfExtractor;
import org.codelibs.fess.crawler.extractor.impl.XmlExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JodExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(JodExtractor.class);
    public OfficeManager officeManager;
    public File tempDir = null;
    public String outputEncoding = "UTF-8";
    private final Map<String, String> extensionMap = new HashMap<String, String>();
    private final Map<String, Extractor> extractorMap = new HashMap<String, Extractor>();

    public JodExtractor() {
        this.extensionMap.put("", "txt");
        this.extensionMap.put("odt", "txt");
        this.extensionMap.put("sxw", "txt");
        this.extensionMap.put("rtf", "txt");
        this.extensionMap.put("doc", "txt");
        this.extensionMap.put("docx", "pdf");
        this.extensionMap.put("wpd", "txt");
        this.extensionMap.put("ods", "pdf");
        this.extensionMap.put("sxc", "tsv");
        this.extensionMap.put("xls", "pdf");
        this.extensionMap.put("xlsx", "pdf");
        this.extensionMap.put("csv", "tsv");
        this.extensionMap.put("tsv", "tsv");
        this.extensionMap.put("odp", "pdf");
        this.extensionMap.put("sxi", "pdf");
        this.extensionMap.put("ppt", "pdf");
        this.extensionMap.put("pptx", "pdf");
        this.extensionMap.put("odg", "svg");
        this.extractorMap.put("pdf", new PdfExtractor());
        this.extractorMap.put("svg", new XmlExtractor());
    }

    @PostConstruct
    public void init() {
        if (this.officeManager == null) {
            throw new CrawlerSystemException("officeManager is null.");
        }
        this.officeManager.start();
    }

    @PreDestroy
    public void destroy() {
        this.officeManager.stop();
    }

    public void addConversionRule(String inExt, String outExt) {
        this.extensionMap.put(inExt, outExt);
    }

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        String extension;
        String filePrefix;
        String resourceName;
        if (in == null) {
            throw new CrawlerSystemException("in is null.");
        }
        String string = resourceName = params == null ? null : params.get("resourceName");
        if (StringUtil.isNotBlank((String)resourceName)) {
            String name = this.getFileName(resourceName);
            String[] strings = name.split("\\.");
            StringBuilder buf = new StringBuilder(100);
            if (strings.length > 1) {
                for (int i = 0; i < strings.length - 1; ++i) {
                    if (buf.length() != 0) {
                        buf.append('.');
                    }
                    buf.append(strings[i]);
                }
                filePrefix = buf.toString();
                extension = strings[strings.length - 1];
            } else {
                filePrefix = name;
                extension = "";
            }
        } else {
            filePrefix = "none";
            extension = "";
        }
        File inputFile = null;
        File outputFile = null;
        try {
            inputFile = File.createTempFile("jodextin_" + filePrefix + "_", StringUtil.isNotBlank((String)extension) ? "." + extension : extension, this.tempDir);
            String outExt = this.getOutputExtension(extension);
            outputFile = File.createTempFile("cmdextout_" + filePrefix + "_", "." + outExt, this.tempDir);
            CopyUtil.copy((InputStream)in, (File)inputFile);
            OfficeDocumentConverter converter = new OfficeDocumentConverter(this.officeManager);
            converter.convert(inputFile, outputFile);
            ExtractData extractData = new ExtractData(this.getOutputContent(outputFile, outExt));
            if (StringUtil.isNotBlank((String)resourceName)) {
                extractData.putValues("resourceName", new String[]{resourceName});
            }
            ExtractData extractData2 = extractData;
            return extractData2;
        }
        catch (IOException e) {
            throw new ExtractException("Could not extract a content.", e);
        }
        finally {
            if (inputFile != null && !inputFile.delete()) {
                logger.info("Failed to delete " + inputFile.getAbsolutePath());
            }
            if (outputFile != null && !outputFile.delete()) {
                logger.info("Failed to delete " + outputFile.getAbsolutePath());
            }
        }
    }

    protected String getOutputContent(File outputFile, String outExt) {
        Extractor extractor = this.getExtractor(outExt);
        if (extractor != null) {
            String string;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("resourceName", outputFile.getName());
            FileInputStream in = null;
            try {
                in = new FileInputStream(outputFile);
                ExtractData extractData = extractor.getText(in, params);
                string = extractData.getContent();
            }
            catch (FileNotFoundException e) {
                try {
                    throw new ExtractException("Could not open " + outputFile.getAbsolutePath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            return string;
        }
        try {
            return new String(FileUtil.readBytes((File)outputFile), this.outputEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(FileUtil.readBytes((File)outputFile), Constants.UTF_8_CHARSET);
        }
    }

    private Extractor getExtractor(String ext) {
        return this.extractorMap.get(ext);
    }

    private String getOutputExtension(String extension) {
        String outExt = this.extensionMap.get(extension);
        return outExt == null ? "txt" : outExt;
    }

    private String getFileName(String resourceName) {
        String name = resourceName.replaceAll("/+$", "");
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }
}

