/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.text.PDFTextStripper;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.ExtractException;
import org.codelibs.fess.crawler.extractor.Extractor;

public class PdfExtractor
implements Extractor {
    protected Object pdfBoxLockObj = new Object();
    protected Map<Pattern, String> passwordMap = new HashMap<Pattern, String>();
    protected long timeout = 30000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new CrawlerSystemException("The inputstream is null.");
        }
        Object object = this.pdfBoxLockObj;
        synchronized (object) {
            String password = this.getPassword(params);
            try (PDDocument document = PDDocument.load((InputStream)in, (String)password);){
                StringWriter output = new StringWriter();
                PDFTextStripper stripper = new PDFTextStripper();
                AtomicBoolean done = new AtomicBoolean(false);
                PDDocument doc = document;
                HashSet exceptionSet = new HashSet();
                Thread task = new Thread(() -> {
                    try {
                        stripper.writeText(doc, (Writer)output);
                    }
                    catch (Exception e) {
                        exceptionSet.add(e);
                    }
                    finally {
                        done.set(true);
                    }
                });
                task.setDaemon(true);
                task.start();
                task.join(this.timeout);
                if (!done.get()) {
                    for (int i = 0; i < 100 && !done.get(); ++i) {
                        task.interrupt();
                        Thread.sleep(50L);
                    }
                    throw new ExtractException("PDFBox process cannot finish in " + this.timeout + " sec.");
                }
                if (!exceptionSet.isEmpty()) {
                    throw (Exception)exceptionSet.iterator().next();
                }
                output.flush();
                ExtractData extractData = new ExtractData(output.toString());
                this.extractMetadata(document, extractData);
                ExtractData extractData2 = extractData;
                return extractData2;
            }
            catch (Exception e) {
                throw new ExtractException(e);
            }
        }
    }

    private void extractMetadata(PDDocument document, ExtractData extractData) {
        PDDocumentInformation info = document.getDocumentInformation();
        if (info == null) {
            return;
        }
        for (String key : info.getMetadataKeys()) {
            String value = info.getCustomMetadataValue(key);
            this.addMetadata(extractData, key, value);
        }
    }

    private void addMetadata(ExtractData extractData, String name, String value) {
        if (value != null) {
            extractData.putValue(name, value);
        }
    }

    public void addPassword(String regex, String password) {
        this.passwordMap.put(Pattern.compile(regex), password);
    }

    protected String getPassword(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        String password = params.get("org.apache.tika.parser.pdf.password");
        if (password == null && !this.passwordMap.isEmpty()) {
            String url = params.get("url");
            String resourceName = params.get("resourceName");
            String value = null;
            if (StringUtil.isNotEmpty((String)url)) {
                value = url;
            } else if (StringUtil.isNotEmpty((String)resourceName)) {
                value = resourceName;
            }
            if (value != null) {
                for (Map.Entry<Pattern, String> entry : this.passwordMap.entrySet()) {
                    if (!entry.getKey().matcher(value).matches()) continue;
                    return entry.getValue();
                }
            }
        }
        return password == null ? "" : password;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

