/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.SecureContentHandler;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.extractor.Extractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(TikaExtractor.class);
    @Resource
    protected CrawlerContainer crawlerContainer;
    public String outputEncoding = "UTF-8";
    public boolean readAsTextIfFailed = true;
    public long maxCompressionRatio = 100L;
    public long maxUncompressionSize = 1000000L;
    public int initialBufferSize = 10000;
    public boolean replaceDuplication = false;
    public int memorySize = 0x100000;
    public int maxAlphanumTermSize = -1;
    public int maxSymbolTermSize = -1;
    public TikaConfig tikaConfig;
    protected Map<String, String> pdfPasswordMap = new HashMap<String, String>();

    @PostConstruct
    public void init() {
        if (this.tikaConfig == null) {
            this.tikaConfig = TikaConfig.getDefaultConfig();
        }
        if (logger.isDebugEnabled()) {
            Parser parser = this.tikaConfig.getParser();
            logger.debug("supportedTypes: {}", (Object)parser.getSupportedTypes(new ParseContext()));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ExtractData getText(InputStream inputStream, Map<String, String> params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected InputStream getContentStream(DeferredFileOutputStream dfos) throws IOException {
        if (dfos.isInMemory()) {
            return new ByteArrayInputStream(dfos.getData());
        }
        return new BufferedInputStream(new FileInputStream(dfos.getFile()));
    }

    /*
     * Exception decompiling
     */
    protected String getContent(ContentWriter out, String encoding) throws TikaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String getPdfPassword(String url, String resourceName) {
        if (this.pdfPasswordMap.isEmpty()) {
            return null;
        }
        String value = null;
        if (StringUtil.isNotEmpty((String)url)) {
            value = url;
        } else if (StringUtil.isNotEmpty((String)resourceName)) {
            value = resourceName;
        }
        if (value != null) {
            for (Map.Entry<String, String> entry : this.pdfPasswordMap.entrySet()) {
                if (!value.matches(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private Metadata createMetadata(String resourceName, String contentType, String contentEncoding, String pdfPassword) {
        Metadata metadata = new Metadata();
        if (StringUtil.isNotEmpty((String)resourceName)) {
            metadata.set("resourceName", resourceName);
        }
        if (StringUtil.isNotBlank((String)contentType)) {
            metadata.set("Content-Type", contentType);
        }
        if (StringUtil.isNotBlank((String)contentEncoding)) {
            metadata.set("Content-Encoding", contentEncoding);
        }
        if (pdfPassword != null) {
            metadata.add("org.apache.tika.parser.pdf.password", pdfPassword);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("metadata: {}", (Object)metadata);
        }
        return metadata;
    }

    public void addPdfPassword(String regex, String password) {
        this.pdfPasswordMap.put(regex, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$getText$6(boolean bl, InputStream inputStream, String string, File file, Writer writer) throws Exception {
        BufferedReader br = null;
        try {
            String line;
            if (bl) {
                inputStream.reset();
                br = new BufferedReader(new InputStreamReader(inputStream, string));
            } else {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            }
            while ((line = br.readLine()) != null) {
                writer.write(line);
            }
        }
        catch (Exception e) {
            try {
                logger.warn("Could not read " + (file != null ? file.getAbsolutePath() : "a byte stream"), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
        }
        IOUtils.closeQuietly((Reader)br);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$getText$5(boolean bl, InputStream inputStream, File file, Parser parser, Metadata metadata, ParseContext parseContext, Writer writer) throws Exception {
        InputStream in = null;
        try {
            if (bl) {
                inputStream.reset();
                in = inputStream;
            } else {
                in = new FileInputStream(file);
            }
            parser.parse(in, (ContentHandler)new BodyContentHandler(writer), metadata, parseContext);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$getText$4(boolean bl, InputStream inputStream, File file, Parser parser, Metadata metadata, ParseContext parseContext, Writer writer) throws Exception {
        InputStream in = null;
        try {
            if (bl) {
                inputStream.reset();
                in = inputStream;
            } else {
                in = new FileInputStream(file);
            }
            parser.parse(in, (ContentHandler)new BodyContentHandler(writer), metadata, parseContext);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$getText$3(boolean bl, File file, InputStream inputStream, Parser parser, Metadata metadata, ParseContext parseContext, Writer writer) throws Exception {
        InputStream in = null;
        try {
            if (!bl) {
                try (FileOutputStream out = new FileOutputStream(file);){
                    CopyUtil.copy((InputStream)inputStream, (OutputStream)out);
                }
                in = new FileInputStream(file);
            } else {
                in = inputStream;
            }
            parser.parse(in, (ContentHandler)new BodyContentHandler(writer), metadata, parseContext);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @FunctionalInterface
    protected static interface ContentWriter {
        public void accept(Writer var1) throws Exception;
    }

    protected class DetectParser
    extends CompositeParser {
        private static final long serialVersionUID = 1L;
        private final Detector detector;

        public DetectParser() {
            this(this$0.tikaConfig);
        }

        public DetectParser(TikaConfig config) {
            super(config.getMediaTypeRegistry(), new Parser[]{config.getParser()});
            this.detector = config.getDetector();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            TemporaryResources tmp = new TemporaryResources();
            try {
                TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
                MediaType type = this.detector.detect((InputStream)tis, metadata);
                metadata.set("Content-Type", type.toString());
                SecureContentHandler sch = new SecureContentHandler(handler, tis);
                sch.setMaximumCompressionRatio(TikaExtractor.this.maxCompressionRatio);
                sch.setOutputThreshold(TikaExtractor.this.maxUncompressionSize);
                if (logger.isDebugEnabled()) {
                    logger.debug("type: {}, metadata: {}, maxCompressionRatio: {}, maxUncompressionSize: {}", new Object[]{type, metadata, TikaExtractor.this.maxCompressionRatio, TikaExtractor.this.maxUncompressionSize});
                }
                try {
                    super.parse((InputStream)tis, (ContentHandler)sch, metadata, context);
                }
                catch (SAXException e) {
                    sch.throwIfCauseOf(e);
                    throw e;
                }
            }
            finally {
                tmp.dispose();
            }
        }

        public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
            ParseContext context = new ParseContext();
            context.set(Parser.class, (Object)this);
            this.parse(stream, handler, metadata, context);
        }
    }
}

