/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.helper;

import java.util.HashMap;
import java.util.Map;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;

public class ContentLengthHelper {
    protected long defaultMaxLength = 0xA00000L;
    protected Map<String, Long> maxLengthMap = new HashMap<String, Long>();

    public void addMaxLength(String mimeType, long maxLength) {
        if (StringUtil.isBlank((String)mimeType)) {
            throw new CrawlerSystemException("MIME type is a blank.");
        }
        if (maxLength < 0L) {
            throw new CrawlerSystemException("The value of maxLength is invalid.");
        }
        this.maxLengthMap.put(mimeType, maxLength);
    }

    public long getMaxLength(String mimeType) {
        if (StringUtil.isBlank((String)mimeType)) {
            return this.defaultMaxLength;
        }
        Long maxLength = this.maxLengthMap.get(mimeType);
        if (maxLength != null && maxLength >= 0L) {
            return maxLength;
        }
        return this.defaultMaxLength;
    }

    public long getDefaultMaxLength() {
        return this.defaultMaxLength;
    }

    public void setDefaultMaxLength(long defaultMaxLength) {
        this.defaultMaxLength = defaultMaxLength;
    }
}

