/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.pool;

import javax.annotation.Resource;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.codelibs.fess.crawler.container.CrawlerContainer;

public class CrawlerPooledObjectFactory<T>
extends BasePooledObjectFactory<T> {
    @Resource
    protected CrawlerContainer crawlerContainer;
    protected String componentName;
    protected OnDestroyListener<T> onDestroyListener;

    public T create() throws Exception {
        Object component = this.crawlerContainer.getComponent(this.componentName);
        return component;
    }

    public PooledObject<T> wrap(T obj) {
        return new DefaultPooledObject(obj);
    }

    public void destroyObject(PooledObject<T> p) throws Exception {
        if (this.onDestroyListener != null) {
            this.onDestroyListener.onDestroy(p);
        }
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public OnDestroyListener<T> getOnDestroyListener() {
        return this.onDestroyListener;
    }

    public void setOnDestroyListener(OnDestroyListener<T> onDestroyListener) {
        this.onDestroyListener = onDestroyListener;
    }

    public static interface OnDestroyListener<T> {
        public void onDestroy(PooledObject<T> var1);
    }
}

