/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.processor.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.lang.SystemUtil;
import org.codelibs.fess.crawler.CrawlerContext;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.AccessResult;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.ResultData;
import org.codelibs.fess.crawler.entity.UrlQueue;
import org.codelibs.fess.crawler.processor.ResponseProcessor;
import org.codelibs.fess.crawler.service.UrlQueueService;
import org.codelibs.fess.crawler.transformer.Transformer;
import org.codelibs.fess.crawler.util.CrawlingParameterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponseProcessor
implements ResponseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResponseProcessor.class);
    @Resource
    protected CrawlerContainer crawlerContainer;
    protected Transformer transformer;
    protected int[] successfulHttpCodes;
    protected int[] notModifiedHttpCodes;

    @Override
    public void process(ResponseData responseData) {
        if (this.isNotModified(responseData)) {
            UrlQueue<?> urlQueue = CrawlingParameterUtil.getUrlQueue();
            ResultData resultData = new ResultData();
            resultData.setData(new byte[0]);
            resultData.setEncoding("UTF-8");
            resultData.setTransformerName("NONE");
            this.processResult(urlQueue, responseData, resultData);
        } else if (this.isSuccessful(responseData)) {
            if (this.transformer == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No Transformer for (" + responseData.getUrl() + "). PLEASE CHECK YOUR CONFIGURATION.");
                }
            } else {
                ResultData resultData = this.transformer.transform(responseData);
                if (resultData == null) {
                    logger.warn("No data for (" + responseData.getUrl() + ", " + responseData.getMimeType() + ")");
                } else {
                    UrlQueue<?> urlQueue = CrawlingParameterUtil.getUrlQueue();
                    this.processResult(urlQueue, responseData, resultData);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ignore a response(" + responseData.getStatus() + "): " + responseData.getUrl());
        }
    }

    protected boolean isSuccessful(ResponseData responseData) {
        if (this.successfulHttpCodes == null) {
            return true;
        }
        int httpStatusCode = responseData.getHttpStatusCode();
        for (int code : this.successfulHttpCodes) {
            if (code != httpStatusCode) continue;
            return true;
        }
        return false;
    }

    protected boolean isNotModified(ResponseData responseData) {
        if (this.notModifiedHttpCodes == null) {
            return false;
        }
        int httpStatusCode = responseData.getHttpStatusCode();
        for (int code : this.notModifiedHttpCodes) {
            if (code != httpStatusCode) continue;
            return true;
        }
        return false;
    }

    protected void processResult(UrlQueue<?> urlQueue, ResponseData responseData, ResultData resultData) {
        AccessResult accessResult = (AccessResult)this.crawlerContainer.getComponent("accessResult");
        accessResult.init(responseData, resultData);
        CrawlerContext crawlerContext = CrawlingParameterUtil.getCrawlerContext();
        UrlQueueService<UrlQueue<?>> urlQueueService = CrawlingParameterUtil.getUrlQueueService();
        if (logger.isDebugEnabled()) {
            logger.debug("Processing accessResult: " + accessResult);
        }
        if (!urlQueueService.visited(urlQueue)) {
            if (this.checkAccessCount(crawlerContext)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Storing accessResult: " + accessResult);
                }
                try {
                    CrawlingParameterUtil.getDataService().store(accessResult);
                }
                catch (RuntimeException e) {
                    crawlerContext.decrementAndGetAccessCount();
                    if (urlQueueService.visited(urlQueue)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(urlQueue.getUrl() + " exists.", (Throwable)e);
                        }
                        return;
                    }
                    throw e;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Storing child urls: " + resultData.getChildUrlSet());
                }
                this.storeChildUrls(crawlerContext, resultData.getChildUrlSet(), urlQueue.getUrl(), urlQueue.getDepth() == null ? 1 : urlQueue.getDepth() + 1, resultData.getEncoding());
            } else if (crawlerContext.getMaxDepth() < 0 || urlQueue.getDepth() <= crawlerContext.getMaxDepth()) {
                crawlerContext.decrementAndGetAccessCount();
                ArrayList newUrlQueueList = new ArrayList();
                newUrlQueueList.add(urlQueue);
                urlQueueService.offerAll(crawlerContext.getSessionId(), newUrlQueueList);
            }
        }
    }

    private boolean checkAccessCount(CrawlerContext crawlerContext) {
        if (crawlerContext.getMaxAccessCount() > 0L) {
            return crawlerContext.incrementAndGetAccessCount() <= crawlerContext.getMaxAccessCount();
        }
        return true;
    }

    private void storeChildUrls(CrawlerContext crawlerContext, Set<RequestData> childUrlList, String url, int depth, String encoding) {
        if (crawlerContext.getMaxDepth() >= 0 && depth > crawlerContext.getMaxDepth()) {
            return;
        }
        HashSet urlSet = new HashSet();
        List childList = childUrlList.stream().filter(d -> StringUtil.isNotBlank((String)d.getUrl()) && urlSet.add(d.getUrl() + "\n" + d.getMetaData()) && crawlerContext.getUrlFilter().match(d.getUrl())).map(d -> {
            UrlQueue uq = (UrlQueue)this.crawlerContainer.getComponent("urlQueue");
            uq.setCreateTime(SystemUtil.currentTimeMillis());
            uq.setDepth(depth);
            uq.setMethod(d.getMethod().name());
            uq.setEncoding(encoding);
            uq.setParentUrl(url);
            uq.setSessionId(crawlerContext.getSessionId());
            uq.setUrl(d.getUrl());
            uq.setMetaData(d.getMetaData());
            return uq;
        }).collect(Collectors.toList());
        if (!childList.isEmpty()) {
            CrawlingParameterUtil.getUrlQueueService().offerAll(crawlerContext.getSessionId(), childList);
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public int[] getSuccessfulHttpCodes() {
        return this.successfulHttpCodes;
    }

    public void setSuccessfulHttpCodes(int[] successfulHttpCodes) {
        this.successfulHttpCodes = successfulHttpCodes;
    }

    public int[] getNotModifiedHttpCodes() {
        return this.notModifiedHttpCodes;
    }

    public void setNotModifiedHttpCodes(int[] notModifiedHttpCodes) {
        this.notModifiedHttpCodes = notModifiedHttpCodes;
    }
}

