/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.processor.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import javax.annotation.Resource;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.fess.crawler.builder.RequestDataBuilder;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.Sitemap;
import org.codelibs.fess.crawler.entity.SitemapSet;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.helper.SitemapsHelper;
import org.codelibs.fess.crawler.processor.ResponseProcessor;

public class SitemapsResponseProcessor
implements ResponseProcessor {
    @Resource
    protected CrawlerContainer crawlerContainer;

    @Override
    public void process(ResponseData responseData) {
        SitemapsHelper sitemapsHelper = (SitemapsHelper)this.crawlerContainer.getComponent("sitemapsHelper");
        try {
            InputStream responseBody = responseData.getResponseBody();
            Throwable throwable = null;
            try {
                try {
                    SitemapSet sitemapSet = sitemapsHelper.parse(responseBody);
                    LinkedHashSet<RequestData> requestDataSet = new LinkedHashSet<RequestData>();
                    for (Sitemap sitemap : sitemapSet.getSitemaps()) {
                        requestDataSet.add(RequestDataBuilder.newRequestData().get().url(sitemap.getLoc()).build());
                    }
                    throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#process(ResponseData)");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (responseBody != null) {
                    if (throwable != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        responseBody.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

