/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.rule.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.rule.impl.AbstractRule;

public class RegexRule
extends AbstractRule {
    private static final long serialVersionUID = 1L;
    protected boolean defaultRule = false;
    protected boolean allRequired = true;
    protected Map<String, Pattern> regexMap = new HashMap<String, Pattern>();

    @Override
    public boolean match(ResponseData responseData) {
        if (this.defaultRule) {
            return true;
        }
        HashMap map = new HashMap();
        BeanUtil.copyBeanToMap((Object)responseData, map, option -> option.excludeWhitespace());
        for (Map.Entry<String, Pattern> entry : this.regexMap.entrySet()) {
            String value = "";
            Object obj = map.get(entry.getKey());
            if (obj != null) {
                value = obj.toString();
            }
            Matcher matcher = entry.getValue().matcher(value);
            if (this.allRequired) {
                if (matcher.matches()) continue;
                return false;
            }
            if (!matcher.matches()) continue;
            return true;
        }
        return this.allRequired;
    }

    public void addRule(String key, String regex) {
        this.regexMap.put(key, Pattern.compile(regex));
    }

    public void addRule(String key, Pattern pattern) {
        this.regexMap.put(key, pattern);
    }

    public boolean isDefaultRule() {
        return this.defaultRule;
    }

    public void setDefaultRule(boolean defaultRule) {
        this.defaultRule = defaultRule;
    }

    public boolean isAllRequired() {
        return this.allRequired;
    }

    public void setAllRequired(boolean allRequired) {
        this.allRequired = allRequired;
    }

    public boolean equals(Object obj) {
        RegexRule rule;
        return obj instanceof RegexRule && this.allRequired == (rule = (RegexRule)obj).isAllRequired() && this.defaultRule == rule.isDefaultRule() && this.regexMap.equals(rule.regexMap);
    }

    public int hashCode() {
        int hash = this.regexMap.hashCode();
        if (this.defaultRule) {
            hash = hash * 31 + 1;
        }
        if (this.allRequired) {
            hash = hash * 31 + 2;
        }
        return hash;
    }

    public void setRegexMap(Map<String, Pattern> regexMap) {
        this.regexMap = regexMap;
    }
}

