/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.rule.impl;

import java.io.InputStream;
import javax.annotation.Resource;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.helper.SitemapsHelper;
import org.codelibs.fess.crawler.rule.impl.RegexRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitemapsRule
extends RegexRule {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SitemapsRule.class);
    @Resource
    protected CrawlerContainer crawlerContainer;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean match(ResponseData responseData) {
        if (!super.match(responseData)) return false;
        try (InputStream is = responseData.getResponseBody();){
            SitemapsHelper sitemapsHelper = (SitemapsHelper)this.crawlerContainer.getComponent("sitemapsHelper");
            boolean bl = sitemapsHelper.isValid(is);
            return bl;
        }
        catch (CrawlingAccessException e) {
            throw e;
        }
        catch (Exception e) {
            if (!logger.isDebugEnabled()) return false;
            logger.debug("Failed a sitemap check: " + responseData, (Throwable)e);
        }
        return false;
    }
}

